/*  Petri-Foo is a fork of the Specimen audio sampler.

    Original Specimen author Pete Bessman
    Copyright 2005 Pete Bessman
    Copyright 2011 James W. Morris

    This file is part of Petri-Foo.

    Petri-Foo is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as
    published by the Free Software Foundation.

    Petri-Foo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Petri-Foo.  If not, see <http://www.gnu.org/licenses/>.

    This file is a derivative of a Specimen original, modified 2011
*/


#include <gtk/gtk.h>
#include <phat/phat.h>
#include "channelsection.h"
#include "gui.h"
#include "patchlist.h"
#include "midi.h"
#include "patch_set_and_get.h"



G_DEFINE_TYPE(ChannelSection, channel_section, GTK_TYPE_VBOX)


static void channel_section_class_init(ChannelSectionClass* klass)
{
    channel_section_parent_class = g_type_class_peek_parent(klass);
}


static void channel_cb(PhatSliderButton* button, ChannelSection* self)
{
    int channel = (int)phat_slider_button_get_value(button);
    PatchList* list = gui_get_patch_list();

    patch_set_channel(self->patch, channel-1);
    patch_list_update(list, patch_list_get_current_patch(list),
                                                PATCH_LIST_PATCH);
}


static void connect(ChannelSection* self)
{
    g_signal_connect(G_OBJECT(self->chan_sb), "value-changed",
                        G_CALLBACK(channel_cb), (gpointer) self);
}


static void channel_section_init(ChannelSection* self)
{
    GtkBox* box = GTK_BOX(self);
    GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
    GtkBox* h = GTK_BOX(hbox);

    self->patch = -1;

    gui_pack(box, hbox);
    gui_label_pack("Channel:", h);
    gui_pack(h, gui_hpad_new(GUI_TEXTSPACE));

    /* channel sliderbutton */
    self->chan_sb = phat_slider_button_new_with_range(1, 1, MIDI_CHANS,1,0);
    phat_slider_button_set_threshold(PHAT_SLIDER_BUTTON(self->chan_sb),
                                                        GUI_THRESHOLD);
    gui_pack(h, self->chan_sb);

    /* done */
    connect(self);
}


static void block(ChannelSection* self)
{
    g_signal_handlers_block_by_func(self->chan_sb, channel_cb, self);
}


static void unblock(ChannelSection* self)
{
    g_signal_handlers_unblock_by_func(self->chan_sb, channel_cb, self);
}


static void set_sensitive(ChannelSection* self, gboolean val)
{
    gtk_widget_set_sensitive(self->chan_sb, val);
}


GtkWidget* channel_section_new(void)
{
    return (GtkWidget*) g_object_new(CHANNEL_SECTION_TYPE, NULL);
}


void channel_section_set_patch(ChannelSection* self, int patch)
{
    int channel;

    self->patch = patch;

    if (patch < 0)
        set_sensitive(self, FALSE);
    else
    {
        set_sensitive(self, TRUE);
        channel = patch_get_channel(patch);
        block(self);
        phat_slider_button_set_value(PHAT_SLIDER_BUTTON(self->chan_sb),
                                                                channel+1);
        unblock(self);
    }
}


int channel_section_get_channel(ChannelSection* self)
{
    return (self->patch < 0) ? 0 : patch_get_channel(self->patch);
}
