/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _LIST_H_
#define _LIST_H_

#include <stddef.h>

#include "src/types.h"

list_t
list_new();

void
list_append(list_t list, void *data);

void
list_append_copy(list_t list, void *data, size_t size);

#define list_push list_append

void *
list_pop(list_t list);

void
list_for_each(list_t list, void (*callback)(void *data, void *context),
	      void *context);

void
list_for_each_rev(list_t list, void (*callback)(void *data, void *context),
		  void *context);

void *
list_find(list_t list, int (*cmp)(void *d1, void *d2), void *data);

void
list_merge(list_t head, list_t tail);

void *
list_get_last_data(list_t list);

char
list_is_empty(list_t list);

unsigned long
list_get_n_elems(list_t list);

list_t
list_copy(list_t list);

void
list_free(list_t list);

void
list_dump(list_t list);

#endif /* !_LIST_H_ */
