/*
 * Permafrost - Physical modelling framework
 *
 * Copyright (C) 2009, 2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#ifndef _EXPR_H_
#define _EXPR_H_

#include "src/types.h"

expr_t
expr_new_value(double value);

expr_t
expr_new_sample_rate();

expr_t
expr_new_signal(char *id, char in, expr_t delay, expr_t delay_max);

expr_t
expr_new_signal_ref(struct scheduled_expr *ref, expr_t delay, expr_t delay_max);

expr_t
expr_new_call(char *id, list_t args);

/* expr + expr2 */
void
expr_push_add(expr_t expr, expr_t expr2);

/* expr - expr2 */
void
expr_push_sub(expr_t expr, expr_t expr2);

/* expr * expr2 */
void
expr_push_mul(expr_t expr, expr_t expr2);

/* expr / expr2 */
void
expr_push_div(expr_t expr, expr_t expr2);

/* + expr */
void
expr_push_plus(expr_t expr);

/* - expr */
void
expr_push_minus(expr_t expr);

char
expr_top_is_sign(expr_t expr);

struct expr_signal_id *
expr_bind_to_ports(expr_t expr, list_t ports);

void
expr_bind_consts(expr_t expr, list_t consts);

char *
expr_bind_ext_funcs(expr_t expr, list_t ext_funcs);

struct expr_signal_id *
expr_find_unbinded(expr_t expr);

struct ext_func *
expr_check_ext_func_args(expr_t expr);

list_t
expr_get_inputs(expr_t expr);

list_t
expr_get_refs(expr_t expr);

list_t
expr_get_df_refs(expr_t expr);

list_t
expr_get_delays(expr_t expr, struct scheduled_expr *ref);

list_t
expr_get_ext_funcs(expr_t);

expr_t
expr_copy(expr_t expr);

void
expr_port_to_value(expr_t expr, struct port *port, double value);

void
expr_port_to_ref(expr_t expr, struct port *port, struct scheduled_expr *ref);

char
expr_contains_ref(expr_t expr);

char
expr_contains_sample_rate(expr_t expr);

char
expr_is_const(expr_t expr);

char
expr_is_rt_const(expr_t expr);

double
expr_eval(expr_t expr);

void
expr_free(expr_t expr);

void
expr_dump(expr_t expr);

void
expr_c_compile(expr_t expr, FILE *fp, char inside_run);

#endif /* !_EXPR_H_ */
