#!/usr/bin/perl
use strict;
use warnings;
use blib;
use File::Compare;
use File::Copy;
use Test::More;
use Shell;

version_test();

sub version_test {
    my $version = nmap(-V);
    chomp($version);
    $version =~ s/\n//;
    if ($version !~ /3\.\d{2}/ and $version !~ /4\.0\d{1}/ and $version !~ /4\.1\d{1}/){
         plan ( tests => 1);
         is (1,1,"Nmap version is too new for these Tests");
         exit;
    }
}

plan ( tests => no_plan );
my $db = "data.dbl";
#chdir("t") or die "couldn't change directory";
#copy("../outputpbnj", ".");
#copy("../config.yaml", ".");
#copy("../data.dbl", ".");
#copy("../query.yaml", ".");
#tests
is(system("perl outputpbnj -q latestinfo -t csv -f test1.csv"),0,"latestinfo CSV Output input from $db");
is(system("perl outputpbnj -q latestinfo -t tab -f test1.tab"),0,"latestinfo Tab Output input from $db");
is(system("perl outputpbnj -q sdump -t csv -f test2.csv"),0,"sdump Tab Output input from $db");
is(system("perl outputpbnj -q sdump -t tab -f test2.tab"),0,"sdump Tab Output input from $db");

is(compare("test1.csv", "output.csv"),1,"CSV test latestinfo");
is(compare("test1.tab", "output.tab"),1,"TAB test latestinfo");
is(compare("test2.csv", "output2.csv"),1,"CSV test dumpservices");
is(compare("test2.tab", "output2.tab"),1,"TAB test dumpservices");

#is(unlink("test1.csv"),1,"Remove Test1.csv");
#is(unlink("test1.tab"),1,"Remove Test1.tab");
#is(unlink("test2.tab"),1,"Remove Test2.tab");
#is(unlink("test2.csv"),1,"Remove Test2.tab");

#is(unlink("outputpbnj"),1,"Remove Test2.tab");
#is(unlink($db),1,"Remove DB");
