/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     operimg.c                                                      *
 *            Functions to handle operation image                            *
 * Author:    Andreas Tille                                                  *
 * Date:      01.02.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include "paul.h"
#include "callback.h"
#include "names.h"

static void CreateOperationFrame(PAUL *p)
/* Set/Unset frame for name of operation image
 * --- Parameter: ---
 * PAUL          *p     :
 */
{
  static GtkWidget *frame     = NULL,
                   *list      = NULL,
                   *item      = NULL,
                   *label     = NULL;
  GtkWidget        *p_table;
   
  g_return_if_fail ( IS_PAUL(p) );
  g_return_if_fail ( GTK_IS_SCROLLED_WINDOW(p->w) );
  g_return_if_fail ( GTK_IS_TABLE((p->w)->parent) );
  
  p_table    = GTK_WIDGET(GTK_TABLE((p->w)->parent));
  if ( !p->op ) {
    if ( frame ) gtk_widget_destroy(frame);
    frame = list = label = NULL;
    gtk_widget_show_all(p_table);
    MenueSensitive(p);
    return;
  }
  if ( !p->op->file ) p->op->file = g_strdup(_("Unknown"));
  if ( frame ) {
    if ( label ) gtk_label_set(GTK_LABEL(label), p->op->file);
    else         g_warning(_("Frame has no label"));
  } else {
    gchar *buf;
      
    frame = gtk_frame_new(Operating);
    gtk_table_attach_defaults(GTK_TABLE(p_table), frame, 0, 1, 1, 2);
    list  = gtk_list_new();
    gtk_container_add(GTK_CONTAINER(frame), list);
    gtk_signal_connect(GTK_OBJECT(list), "button_press_event", 
                       GTK_SIGNAL_FUNC(OperationToList), p);
    gtk_object_set_user_data(GTK_OBJECT(list), p);
    item  = gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(list), item);
    g_return_if_fail ( (buf = ImgFileName(p->op)) );
    label = gtk_label_new(buf);
    FREE(buf);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_container_add(GTK_CONTAINER(item), label);
  }
  if ( p->opi && GTK_IS_WINDOW(p->opi) )
    gtk_object_set_user_data(GTK_OBJECT(p->opi), list);
  
  MenueSensitive(p);
  gtk_widget_show_all(p_table);
}


static void OperImgDestroy(GtkWidget *widget, PAUL *p)
/* destroy p->opi widget and set to NULL
 */
{
  g_return_if_fail ( widget != NULL );
  g_return_if_fail ( GTK_IS_WIDGET(widget) );
  g_return_if_fail ( IS_PAUL(p) );
  g_return_if_fail ( widget == p->opi );
    
  MenueSensitive(p);
  gtk_object_destroy(GTK_OBJECT(widget));
  p->opi = NULL;
}


void OperationToList(gpointer *realdata, gpointer *flagdata)
/* move operation image back to the image list
 * --- Parameter: ---
 * gpointer *realdata : list widget with single list element as operation image
 *                      PAUL *p set as user data    _OR_
 *                      PAUL *p if flagdata == NULL                        
 * gpointer *flagdata : NULL if realdata == PAUL *p, else if realdata is list widget
 * 
 */
{
  PAUL *p;
   
  if ( flagdata ) {
    g_return_if_fail ( GTK_IS_LIST(realdata) );
    g_return_if_fail ( (p = (PAUL *)gtk_object_get_user_data(GTK_OBJECT(realdata))) );
  } else 
    g_return_if_fail ( (p = (PAUL *)realdata ) );
  g_return_if_fail ( IS_PAUL(p) );

  if ( ANIMATION_SPEED != SINGLE ) {
    g_warning(_("Please avoid inserting %s while animation is running"), operating);
    return;
  }
  g_return_if_fail(IS_PICTURE(p->op));
  
  if ( p->opi ) {
    g_return_if_fail ( GTK_IS_WINDOW(p->opi) );
    OperImgDestroy(p->opi, p); 
  }
  AddImageToFilelist(p, p->op);
  p->op = NULL;
   
  CreateOperationFrame(p);
}

void CreateOperationImageWindow(PAUL *p)
/*
 */
{
  PICTURE *bild;
  gchar   *buf;

  g_return_if_fail ( IS_PAUL(p) );
  g_return_if_fail ( IS_PICTURE(bild = p->op) );
  
  /* Attention: expect problems when empty picture list */
  p->opi = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  CreateOperationFrame(p);
  gtk_signal_connect(GTK_OBJECT(p->opi), "destroy", GTK_SIGNAL_FUNC(OperImgDestroy), p);
  gtk_widget_set_usize(p->opi, bild->W, bild->H);
  gtk_widget_set_app_paintable (p->opi, TRUE);   
  gtk_widget_realize(p->opi); /* creates the window which is checked in the following test */
  g_return_if_fail ( p->opi->window );
  gtk_widget_show(p->opi);
  gtk_signal_connect(GTK_OBJECT(p->opi), "key_press_event", GTK_SIGNAL_FUNC(PictureKeyPressed), p);
  bild->mark = NOSEL;
  if ( !(bild->im) ) g_return_if_fail( (bild->im = 
                              at_imlib_set_image_from_data(&(bild->DATA), bild->W, bild->H)) );
  ApplyPicture(p->opi->window, bild);
  buf = g_strdup_printf("%s (%s)", Operating, bild->file);
  gtk_window_set_title(GTK_WINDOW(p->opi), buf);
  FREE(buf);
  if ( bild->mark | TMPSEL ) bild->mark &= ~TMPSEL;
}

