/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+1.2, Imlib, GtkImreg                                       *
 * Modul:     gcutarea.c                                                     *
 *            Callback function to cut area                                  *
 * Author:    Andreas Tille                                                  *
 * Date:      07.10.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <stdlib.h>
#include <gtkimreg.h>
#include "paul.h"
#include "callback.h"

static void CutCallbackEnd(GtkWidget *widget, GtkImReg *imreg)
/* Needed to reset the flag that Cut proces ended
 * --- Parameter: ---
 * GtkWidget *widget : OK or Cancel-button inside GtkImReg widget
 *                     GList containing image to cut as user_data
 * GtkImReg *imreg   : GtkImReg widget, PAUL *p set as user_data
 */
{
  PAUL    *p;

  g_return_if_fail ( GTK_IS_IMREG(imreg) ) ;
  g_return_if_fail ( (p = gtk_object_get_user_data(GTK_OBJECT(imreg)) ) ) ;
  g_return_if_fail ( IS_PAUL(p) ) ;

  g_return_if_fail ( CheckPicList(p->piclist) );

  if ( p->spiclist ) {
    if ( p->spiclist != p->piclist ) {
      g_list_free(p->piclist);
      p->piclist = p->spiclist;
    }
    p->spiclist     = NULL;
  } 
}

static void CutCallbackOK(GtkWidget *widget, GtkImReg *imreg)
/*
 * --- Parameter: ---
 * GtkWidget *widget : OK-button inside GtkImReg widget
 *                     GList containing image to cut as user_data
 * GtkImReg *imreg   : GtkImReg widget, PAUL *p set as user_data
 */
{
  PAUL    *p;
  PICTURE *bild;
  BOX      box;
  GList   *pl;

  g_return_if_fail ( GTK_IS_IMREG(imreg) ) ;
  g_return_if_fail ( (p = gtk_object_get_user_data(GTK_OBJECT(imreg)) ) ) ;
  g_return_if_fail ( IS_PAUL(p) ) ;
  g_return_if_fail ( GTK_IS_BUTTON(widget) ) ;
  g_return_if_fail ( (pl = gtk_object_get_user_data(GTK_OBJECT(widget)) ) ) ;
  g_return_if_fail ( (bild = BILD(pl)) );
  g_return_if_fail ( bild->im == imreg->im ) ;

  gtk_imreg_get(imreg, &(box.x1), &(box.y1), &(box.x2), &(box.y2));
  if ( ( box.x1 == 0           && box.y1 == 0 &&
         box.x2 == bild->W - 1 && box.y2 == bild->H - 1 ) ||
         box.x1 == box.x2      || box.y1 == box.y2 )
    return;

  if ( !(p->opt->cut) ) p->opt->cut = g_new(BOX, 1);
  p->opt->cut->x1 = box.x1;
  p->opt->cut->y1 = box.y1;
  p->opt->cut->x2 = box.x2 + 1;
  p->opt->cut->y2 = box.y2 + 1;

  g_return_if_fail ( !CutAreas(p->piclist, p->opt) );
  FREE(p->opt->cut);
  for ( pl = p->piclist; pl; pl = pl->next ) RefreshImage(GTK_CLIST(p->filelist), pl);

     /* Don't destroy the imreg widget before this point!! The destroy callback resets something *
      * in the paul structure                     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                 */
  gtk_widget_destroy(GTK_WIDGET(imreg));
     /* Don't destroy the imreg widget after this point!! The destroy callback resets something  *
      * in the paul structure                     !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                 */
 
  p->activ = g_list_find(p->piclist, bild);
  if ( !(p->activ) ) p->activ = p->piclist;
  
  SelectAndUpdateInfo(p);
}


int CutPaul(PAUL *p)
/* use GtkImreg widget to cut images
 * --- Parameter: ---
 * PAUL *p         : PAUL structure with possibly changed piclist to handle only
 *                   these images the user requested
 * --- Return: ---
 * int   CutPaul() : RET_SPECIAL, to tell ApplyPaulFunc that there is special handling
 *                   of the image list done by the called function.
 *                   This is required to handle the changed image list after callback.
 */
{
  static GtkWidget *window = NULL;
  gchar            *buf;
   
  g_return_val_if_fail ( IS_PAUL(p), RET_ERR ) ;
  g_return_val_if_fail ( CheckPicList(p->activ), RET_ERR ) ;
  g_return_val_if_fail ( BILD(p->activ)->im, RET_ERR ) ;
  
  if ( window ) {
    gtk_widget_destroy(window);
    return RET_OK;
  }
  buf = g_strdup_printf(_("Cut area of %s"), BILD(p->activ)->file);
  window = gtk_imreg_new(buf, BILD(p->activ)->im, 0, 0, NULL);
  g_free(buf);
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
  gtk_object_set_user_data(GTK_OBJECT(window), p);

  gtk_signal_connect(GTK_OBJECT(GTK_IMREG(window)->ok_button), "clicked", 
                     GTK_SIGNAL_FUNC(CutCallbackOK), window);
  gtk_object_set_user_data(GTK_OBJECT(GTK_IMREG(window)->ok_button), p->activ);

  gtk_signal_connect_object(GTK_OBJECT(GTK_IMREG(window)->cancel_button), "clicked", 
                            GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));

  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(CutCallbackEnd), window);

  gtk_widget_show(window);
  return RET_SPECIAL;
}













