r"""collaboration is a helper module useful for handling synchronisation
in multi-client configuration as well as providing other collaboration
related methods

A simple example:
  from paraview import collaboration

  collaboration.processServerEvents()
"""
#==============================================================================
#
#  Program:   ParaView
#  Module:    collaboration.py
#
#  Copyright (c) Kitware, Inc.
#  All rights reserved.
#  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.
#
#     This software is distributed WITHOUT ANY WARRANTY; without even
#     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#     PURPOSE.  See the above copyright notice for more information.
#
#==============================================================================

import paraview, re, new, sys, vtk
import simple
import servermanager

from vtkPVClientServerCorePython import *
from vtkPVServerImplementationPython import *
from vtkPVServerManagerPython import *
from vtkPVCommonPython import *

def processServerEvents():
  """Update the local state based on the notifications received from the server
  that have been generated by other clients."""
  if servermanager.ActiveConnection:
     session = servermanager.ActiveConnection.Session
     if session.IsMultiClients() and session.IsNotBusy():
        while vtkProcessModule.GetProcessModule().GetNetworkAccessManager().ProcessEvents(100):
          pass
