/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class LongArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private long[] array;

    public LongArray() {
        this(512);
    }

    public LongArray(int n) {
        this.array = new long[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        this.valueCount = 0;
    }

    public void add(long l) {
        if (this.valueCount == this.array.length) {
            long[] lArray = new long[this.array.length + 256];
            System.arraycopy(this.array, 0, lArray, 0, this.array.length);
            this.array = lArray;
        }
        this.array[this.valueCount++] = l;
    }

    public void add(long[] lArray) {
        int n = this.valueCount + lArray.length;
        if (n >= this.array.length) {
            long[] lArray2 = new long[n];
            System.arraycopy(this.array, 0, lArray2, 0, this.array.length);
            this.array = lArray2;
        }
        System.arraycopy(lArray, 0, this.array, this.valueCount, lArray.length);
        this.valueCount = n;
    }

    public long get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, long l) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = l;
    }

    public long remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        long l = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return l;
    }

    public long[] toArray() {
        long[] lArray = new long[this.valueCount];
        System.arraycopy(this.array, 0, lArray, 0, this.valueCount);
        return lArray;
    }

    public long[] toArray(long[] lArray) {
        long[] lArray2 = null;
        lArray2 = lArray.length >= this.valueCount ? lArray : new long[this.valueCount];
        System.arraycopy(this.array, 0, lArray2, 0, this.valueCount);
        return lArray2;
    }
}

