/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LaunchProfile.h>
#include <DataNode.h>

// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Init utility for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LaunchProfile::Init()
{
    profileName = "notset";
    timeout = 480;
    numProcessors = 1;
    numNodesSet = false;
    numNodes = 1;
    partitionSet = false;
    bankSet = false;
    timeLimitSet = false;
    launchMethodSet = false;
    forceStatic = true;
    forceDynamic = false;
    active = false;
    parallel = false;
    launchArgsSet = false;
    sublaunchArgsSet = false;
    sublaunchPreCmdSet = false;
    sublaunchPostCmdSet = false;
    machinefileSet = false;
    visitSetsUpEnv = false;
    canDoHWAccel = false;
    havePreCommand = false;
    havePostCommand = false;

    LaunchProfile::SelectAll();
}

// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Copy utility for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LaunchProfile::Copy(const LaunchProfile &obj)
{
    profileName = obj.profileName;
    timeout = obj.timeout;
    numProcessors = obj.numProcessors;
    numNodesSet = obj.numNodesSet;
    numNodes = obj.numNodes;
    partitionSet = obj.partitionSet;
    partition = obj.partition;
    bankSet = obj.bankSet;
    bank = obj.bank;
    timeLimitSet = obj.timeLimitSet;
    timeLimit = obj.timeLimit;
    launchMethodSet = obj.launchMethodSet;
    launchMethod = obj.launchMethod;
    forceStatic = obj.forceStatic;
    forceDynamic = obj.forceDynamic;
    active = obj.active;
    arguments = obj.arguments;
    parallel = obj.parallel;
    launchArgsSet = obj.launchArgsSet;
    launchArgs = obj.launchArgs;
    sublaunchArgsSet = obj.sublaunchArgsSet;
    sublaunchArgs = obj.sublaunchArgs;
    sublaunchPreCmdSet = obj.sublaunchPreCmdSet;
    sublaunchPreCmd = obj.sublaunchPreCmd;
    sublaunchPostCmdSet = obj.sublaunchPostCmdSet;
    sublaunchPostCmd = obj.sublaunchPostCmd;
    machinefileSet = obj.machinefileSet;
    machinefile = obj.machinefile;
    visitSetsUpEnv = obj.visitSetsUpEnv;
    canDoHWAccel = obj.canDoHWAccel;
    havePreCommand = obj.havePreCommand;
    hwAccelPreCommand = obj.hwAccelPreCommand;
    havePostCommand = obj.havePostCommand;
    hwAccelPostCommand = obj.hwAccelPostCommand;

    LaunchProfile::SelectAll();
}

// Type map format string
const char *LaunchProfile::TypeMapFormatString = LAUNCHPROFILE_TMFS;
const AttributeGroup::private_tmfs_t LaunchProfile::TmfsStruct = {LAUNCHPROFILE_TMFS};


// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Default constructor for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile::LaunchProfile() : 
    AttributeSubject(LaunchProfile::TypeMapFormatString)
{
    LaunchProfile::Init();
}

// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Constructor for the derived classes of LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile::LaunchProfile(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LaunchProfile::Init();
}

// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Copy constructor for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile::LaunchProfile(const LaunchProfile &obj) : 
    AttributeSubject(LaunchProfile::TypeMapFormatString)
{
    LaunchProfile::Copy(obj);
}

// ****************************************************************************
// Method: LaunchProfile::LaunchProfile
//
// Purpose: 
//   Copy constructor for derived classes of the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile::LaunchProfile(const LaunchProfile &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LaunchProfile::Copy(obj);
}

// ****************************************************************************
// Method: LaunchProfile::~LaunchProfile
//
// Purpose: 
//   Destructor for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile::~LaunchProfile()
{
    // nothing here
}

// ****************************************************************************
// Method: LaunchProfile::operator = 
//
// Purpose: 
//   Assignment operator for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LaunchProfile& 
LaunchProfile::operator = (const LaunchProfile &obj)
{
    if (this == &obj) return *this;

    LaunchProfile::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LaunchProfile::operator == 
//
// Purpose: 
//   Comparison operator == for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LaunchProfile::operator == (const LaunchProfile &obj) const
{
    // Create the return value
    return ((profileName == obj.profileName) &&
            (timeout == obj.timeout) &&
            (numProcessors == obj.numProcessors) &&
            (numNodesSet == obj.numNodesSet) &&
            (numNodes == obj.numNodes) &&
            (partitionSet == obj.partitionSet) &&
            (partition == obj.partition) &&
            (bankSet == obj.bankSet) &&
            (bank == obj.bank) &&
            (timeLimitSet == obj.timeLimitSet) &&
            (timeLimit == obj.timeLimit) &&
            (launchMethodSet == obj.launchMethodSet) &&
            (launchMethod == obj.launchMethod) &&
            (forceStatic == obj.forceStatic) &&
            (forceDynamic == obj.forceDynamic) &&
            (active == obj.active) &&
            (arguments == obj.arguments) &&
            (parallel == obj.parallel) &&
            (launchArgsSet == obj.launchArgsSet) &&
            (launchArgs == obj.launchArgs) &&
            (sublaunchArgsSet == obj.sublaunchArgsSet) &&
            (sublaunchArgs == obj.sublaunchArgs) &&
            (sublaunchPreCmdSet == obj.sublaunchPreCmdSet) &&
            (sublaunchPreCmd == obj.sublaunchPreCmd) &&
            (sublaunchPostCmdSet == obj.sublaunchPostCmdSet) &&
            (sublaunchPostCmd == obj.sublaunchPostCmd) &&
            (machinefileSet == obj.machinefileSet) &&
            (machinefile == obj.machinefile) &&
            (visitSetsUpEnv == obj.visitSetsUpEnv) &&
            (canDoHWAccel == obj.canDoHWAccel) &&
            (havePreCommand == obj.havePreCommand) &&
            (hwAccelPreCommand == obj.hwAccelPreCommand) &&
            (havePostCommand == obj.havePostCommand) &&
            (hwAccelPostCommand == obj.hwAccelPostCommand));
}

// ****************************************************************************
// Method: LaunchProfile::operator != 
//
// Purpose: 
//   Comparison operator != for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LaunchProfile::operator != (const LaunchProfile &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LaunchProfile::TypeName
//
// Purpose: 
//   Type name method for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LaunchProfile::TypeName() const
{
    return "LaunchProfile";
}

// ****************************************************************************
// Method: LaunchProfile::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LaunchProfile::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LaunchProfile *tmp = (const LaunchProfile *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LaunchProfile::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LaunchProfile::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LaunchProfile(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LaunchProfile::NewInstance
//
// Purpose: 
//   NewInstance method for the LaunchProfile class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LaunchProfile::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LaunchProfile(*this);
    else
        retval = new LaunchProfile;

    return retval;
}

// ****************************************************************************
// Method: LaunchProfile::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LaunchProfile::SelectAll()
{
    Select(ID_profileName,         (void *)&profileName);
    Select(ID_timeout,             (void *)&timeout);
    Select(ID_numProcessors,       (void *)&numProcessors);
    Select(ID_numNodesSet,         (void *)&numNodesSet);
    Select(ID_numNodes,            (void *)&numNodes);
    Select(ID_partitionSet,        (void *)&partitionSet);
    Select(ID_partition,           (void *)&partition);
    Select(ID_bankSet,             (void *)&bankSet);
    Select(ID_bank,                (void *)&bank);
    Select(ID_timeLimitSet,        (void *)&timeLimitSet);
    Select(ID_timeLimit,           (void *)&timeLimit);
    Select(ID_launchMethodSet,     (void *)&launchMethodSet);
    Select(ID_launchMethod,        (void *)&launchMethod);
    Select(ID_forceStatic,         (void *)&forceStatic);
    Select(ID_forceDynamic,        (void *)&forceDynamic);
    Select(ID_active,              (void *)&active);
    Select(ID_arguments,           (void *)&arguments);
    Select(ID_parallel,            (void *)&parallel);
    Select(ID_launchArgsSet,       (void *)&launchArgsSet);
    Select(ID_launchArgs,          (void *)&launchArgs);
    Select(ID_sublaunchArgsSet,    (void *)&sublaunchArgsSet);
    Select(ID_sublaunchArgs,       (void *)&sublaunchArgs);
    Select(ID_sublaunchPreCmdSet,  (void *)&sublaunchPreCmdSet);
    Select(ID_sublaunchPreCmd,     (void *)&sublaunchPreCmd);
    Select(ID_sublaunchPostCmdSet, (void *)&sublaunchPostCmdSet);
    Select(ID_sublaunchPostCmd,    (void *)&sublaunchPostCmd);
    Select(ID_machinefileSet,      (void *)&machinefileSet);
    Select(ID_machinefile,         (void *)&machinefile);
    Select(ID_visitSetsUpEnv,      (void *)&visitSetsUpEnv);
    Select(ID_canDoHWAccel,        (void *)&canDoHWAccel);
    Select(ID_havePreCommand,      (void *)&havePreCommand);
    Select(ID_hwAccelPreCommand,   (void *)&hwAccelPreCommand);
    Select(ID_havePostCommand,     (void *)&havePostCommand);
    Select(ID_hwAccelPostCommand,  (void *)&hwAccelPostCommand);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LaunchProfile::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can
//   be saved to a config file.
//
//   This differs from the auto-generated one in the following ways:
//    - it checks to see if something is selected when saving instead
//      of checking to see if it differs from the default-constructor version,
//      which lets us select user-set values which differ from system-global
//      ones and save only those fields
//    - if any field was saved, we always add the profile name, as that's how
//      we identify which launch profile is which
//
// Programmer: Jeremy Meredith
// Creation:   April 29, 2010
//
// Modifications:
//   
// ****************************************************************************
bool
LaunchProfile::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LaunchProfile defaultObject;
    bool addToParent = false;
    // Create a node for LaunchProfile.
    DataNode *node = new DataNode("LaunchProfile");

    if(completeSave || IsSelected(ID_timeout))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeout", timeout));
    }

    if(completeSave || IsSelected(ID_numProcessors))
    {
        addToParent = true;
        node->AddNode(new DataNode("numProcessors", numProcessors));
    }

    if(completeSave || IsSelected(ID_numNodesSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodesSet", numNodesSet));
    }

    if(completeSave || IsSelected(ID_numNodes))
    {
        addToParent = true;
        node->AddNode(new DataNode("numNodes", numNodes));
    }

    if(completeSave || IsSelected(ID_partitionSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("partitionSet", partitionSet));
    }

    if(completeSave || IsSelected(ID_partition))
    {
        addToParent = true;
        node->AddNode(new DataNode("partition", partition));
    }

    if(completeSave || IsSelected(ID_bankSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("bankSet", bankSet));
    }

    if(completeSave || IsSelected(ID_bank))
    {
        addToParent = true;
        node->AddNode(new DataNode("bank", bank));
    }

    if(completeSave || IsSelected(ID_timeLimitSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeLimitSet", timeLimitSet));
    }

    if(completeSave || IsSelected(ID_timeLimit))
    {
        addToParent = true;
        node->AddNode(new DataNode("timeLimit", timeLimit));
    }

    if(completeSave || IsSelected(ID_launchMethodSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchMethodSet", launchMethodSet));
    }

    if(completeSave || IsSelected(ID_launchMethod))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchMethod", launchMethod));
    }

    if(completeSave || IsSelected(ID_forceStatic))
    {
        addToParent = true;
        node->AddNode(new DataNode("forceStatic", forceStatic));
    }

    if(completeSave || IsSelected(ID_forceDynamic))
    {
        addToParent = true;
        node->AddNode(new DataNode("forceDynamic", forceDynamic));
    }

    if(completeSave || IsSelected(ID_active))
    {
        addToParent = true;
        node->AddNode(new DataNode("active", active));
    }

    if(completeSave || IsSelected(ID_arguments))
    {
        addToParent = true;
        node->AddNode(new DataNode("arguments", arguments));
    }

    if(completeSave || IsSelected(ID_parallel))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallel", parallel));
    }

    if(completeSave || IsSelected(ID_launchArgsSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchArgsSet", launchArgsSet));
    }

    if(completeSave || IsSelected(ID_launchArgs))
    {
        addToParent = true;
        node->AddNode(new DataNode("launchArgs", launchArgs));
    }

    if(completeSave || IsSelected(ID_sublaunchArgsSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchArgsSet", sublaunchArgsSet));
    }

    if(completeSave || IsSelected(ID_sublaunchArgs))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchArgs", sublaunchArgs));
    }

    if(completeSave || IsSelected(ID_sublaunchPreCmdSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchPreCmdSet", sublaunchPreCmdSet));
    }

    if(completeSave || IsSelected(ID_sublaunchPreCmd))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchPreCmd", sublaunchPreCmd));
    }

    if(completeSave || IsSelected(ID_sublaunchPostCmdSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchPostCmdSet", sublaunchPostCmdSet));
    }

    if(completeSave || IsSelected(ID_sublaunchPostCmd))
    {
        addToParent = true;
        node->AddNode(new DataNode("sublaunchPostCmd", sublaunchPostCmd));
    }

    if(completeSave || IsSelected(ID_machinefileSet))
    {
        addToParent = true;
        node->AddNode(new DataNode("machinefileSet", machinefileSet));
    }

    if(completeSave || IsSelected(ID_machinefile))
    {
        addToParent = true;
        node->AddNode(new DataNode("machinefile", machinefile));
    }

    if(completeSave || IsSelected(ID_visitSetsUpEnv))
    {
        addToParent = true;
        node->AddNode(new DataNode("visitSetsUpEnv", visitSetsUpEnv));
    }

    if(completeSave || IsSelected(ID_canDoHWAccel))
    {
        addToParent = true;
        node->AddNode(new DataNode("canDoHWAccel", canDoHWAccel));
    }

    if(completeSave || IsSelected(ID_havePreCommand))
    {
        addToParent = true;
        node->AddNode(new DataNode("havePreCommand", havePreCommand));
    }

    if(completeSave || IsSelected(ID_hwAccelPreCommand))
    {
        addToParent = true;
        node->AddNode(new DataNode("hwAccelPreCommand", hwAccelPreCommand));
    }

    if(completeSave || IsSelected(ID_havePostCommand))
    {
        addToParent = true;
        node->AddNode(new DataNode("havePostCommand", havePostCommand));
    }

    if(completeSave || IsSelected(ID_hwAccelPostCommand))
    {
        addToParent = true;
        node->AddNode(new DataNode("hwAccelPostCommand", hwAccelPostCommand));
    }

    if (addToParent)
    {
        node->AddNode(new DataNode("profileName", profileName));
    }

    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}
// ****************************************************************************
// Method: LaunchProfile::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LaunchProfile::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LaunchProfile");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("profileName")) != 0)
        SetProfileName(node->AsString());
    if((node = searchNode->GetNode("timeout")) != 0)
        SetTimeout(node->AsInt());
    if((node = searchNode->GetNode("numProcessors")) != 0)
        SetNumProcessors(node->AsInt());
    if((node = searchNode->GetNode("numNodesSet")) != 0)
        SetNumNodesSet(node->AsBool());
    if((node = searchNode->GetNode("numNodes")) != 0)
        SetNumNodes(node->AsInt());
    if((node = searchNode->GetNode("partitionSet")) != 0)
        SetPartitionSet(node->AsBool());
    if((node = searchNode->GetNode("partition")) != 0)
        SetPartition(node->AsString());
    if((node = searchNode->GetNode("bankSet")) != 0)
        SetBankSet(node->AsBool());
    if((node = searchNode->GetNode("bank")) != 0)
        SetBank(node->AsString());
    if((node = searchNode->GetNode("timeLimitSet")) != 0)
        SetTimeLimitSet(node->AsBool());
    if((node = searchNode->GetNode("timeLimit")) != 0)
        SetTimeLimit(node->AsString());
    if((node = searchNode->GetNode("launchMethodSet")) != 0)
        SetLaunchMethodSet(node->AsBool());
    if((node = searchNode->GetNode("launchMethod")) != 0)
        SetLaunchMethod(node->AsString());
    if((node = searchNode->GetNode("forceStatic")) != 0)
        SetForceStatic(node->AsBool());
    if((node = searchNode->GetNode("forceDynamic")) != 0)
        SetForceDynamic(node->AsBool());
    if((node = searchNode->GetNode("active")) != 0)
        SetActive(node->AsBool());
    if((node = searchNode->GetNode("arguments")) != 0)
        SetArguments(node->AsStringVector());
    if((node = searchNode->GetNode("parallel")) != 0)
        SetParallel(node->AsBool());
    if((node = searchNode->GetNode("launchArgsSet")) != 0)
        SetLaunchArgsSet(node->AsBool());
    if((node = searchNode->GetNode("launchArgs")) != 0)
        SetLaunchArgs(node->AsString());
    if((node = searchNode->GetNode("sublaunchArgsSet")) != 0)
        SetSublaunchArgsSet(node->AsBool());
    if((node = searchNode->GetNode("sublaunchArgs")) != 0)
        SetSublaunchArgs(node->AsString());
    if((node = searchNode->GetNode("sublaunchPreCmdSet")) != 0)
        SetSublaunchPreCmdSet(node->AsBool());
    if((node = searchNode->GetNode("sublaunchPreCmd")) != 0)
        SetSublaunchPreCmd(node->AsString());
    if((node = searchNode->GetNode("sublaunchPostCmdSet")) != 0)
        SetSublaunchPostCmdSet(node->AsBool());
    if((node = searchNode->GetNode("sublaunchPostCmd")) != 0)
        SetSublaunchPostCmd(node->AsString());
    if((node = searchNode->GetNode("machinefileSet")) != 0)
        SetMachinefileSet(node->AsBool());
    if((node = searchNode->GetNode("machinefile")) != 0)
        SetMachinefile(node->AsString());
    if((node = searchNode->GetNode("visitSetsUpEnv")) != 0)
        SetVisitSetsUpEnv(node->AsBool());
    if((node = searchNode->GetNode("canDoHWAccel")) != 0)
        SetCanDoHWAccel(node->AsBool());
    if((node = searchNode->GetNode("havePreCommand")) != 0)
        SetHavePreCommand(node->AsBool());
    if((node = searchNode->GetNode("hwAccelPreCommand")) != 0)
        SetHwAccelPreCommand(node->AsString());
    if((node = searchNode->GetNode("havePostCommand")) != 0)
        SetHavePostCommand(node->AsBool());
    if((node = searchNode->GetNode("hwAccelPostCommand")) != 0)
        SetHwAccelPostCommand(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LaunchProfile::SetProfileName(const std::string &profileName_)
{
    profileName = profileName_;
    Select(ID_profileName, (void *)&profileName);
}

void
LaunchProfile::SetTimeout(int timeout_)
{
    timeout = timeout_;
    Select(ID_timeout, (void *)&timeout);
}

void
LaunchProfile::SetNumProcessors(int numProcessors_)
{
    numProcessors = numProcessors_;
    Select(ID_numProcessors, (void *)&numProcessors);
}

void
LaunchProfile::SetNumNodesSet(bool numNodesSet_)
{
    numNodesSet = numNodesSet_;
    Select(ID_numNodesSet, (void *)&numNodesSet);
}

void
LaunchProfile::SetNumNodes(int numNodes_)
{
    numNodes = numNodes_;
    Select(ID_numNodes, (void *)&numNodes);
}

void
LaunchProfile::SetPartitionSet(bool partitionSet_)
{
    partitionSet = partitionSet_;
    Select(ID_partitionSet, (void *)&partitionSet);
}

void
LaunchProfile::SetPartition(const std::string &partition_)
{
    partition = partition_;
    Select(ID_partition, (void *)&partition);
}

void
LaunchProfile::SetBankSet(bool bankSet_)
{
    bankSet = bankSet_;
    Select(ID_bankSet, (void *)&bankSet);
}

void
LaunchProfile::SetBank(const std::string &bank_)
{
    bank = bank_;
    Select(ID_bank, (void *)&bank);
}

void
LaunchProfile::SetTimeLimitSet(bool timeLimitSet_)
{
    timeLimitSet = timeLimitSet_;
    Select(ID_timeLimitSet, (void *)&timeLimitSet);
}

void
LaunchProfile::SetTimeLimit(const std::string &timeLimit_)
{
    timeLimit = timeLimit_;
    Select(ID_timeLimit, (void *)&timeLimit);
}

void
LaunchProfile::SetLaunchMethodSet(bool launchMethodSet_)
{
    launchMethodSet = launchMethodSet_;
    Select(ID_launchMethodSet, (void *)&launchMethodSet);
}

void
LaunchProfile::SetLaunchMethod(const std::string &launchMethod_)
{
    launchMethod = launchMethod_;
    Select(ID_launchMethod, (void *)&launchMethod);
}

void
LaunchProfile::SetForceStatic(bool forceStatic_)
{
    forceStatic = forceStatic_;
    Select(ID_forceStatic, (void *)&forceStatic);
}

void
LaunchProfile::SetForceDynamic(bool forceDynamic_)
{
    forceDynamic = forceDynamic_;
    Select(ID_forceDynamic, (void *)&forceDynamic);
}

void
LaunchProfile::SetActive(bool active_)
{
    active = active_;
    Select(ID_active, (void *)&active);
}

void
LaunchProfile::SetArguments(const stringVector &arguments_)
{
    arguments = arguments_;
    Select(ID_arguments, (void *)&arguments);
}

void
LaunchProfile::SetParallel(bool parallel_)
{
    parallel = parallel_;
    Select(ID_parallel, (void *)&parallel);
}

void
LaunchProfile::SetLaunchArgsSet(bool launchArgsSet_)
{
    launchArgsSet = launchArgsSet_;
    Select(ID_launchArgsSet, (void *)&launchArgsSet);
}

void
LaunchProfile::SetLaunchArgs(const std::string &launchArgs_)
{
    launchArgs = launchArgs_;
    Select(ID_launchArgs, (void *)&launchArgs);
}

void
LaunchProfile::SetSublaunchArgsSet(bool sublaunchArgsSet_)
{
    sublaunchArgsSet = sublaunchArgsSet_;
    Select(ID_sublaunchArgsSet, (void *)&sublaunchArgsSet);
}

void
LaunchProfile::SetSublaunchArgs(const std::string &sublaunchArgs_)
{
    sublaunchArgs = sublaunchArgs_;
    Select(ID_sublaunchArgs, (void *)&sublaunchArgs);
}

void
LaunchProfile::SetSublaunchPreCmdSet(bool sublaunchPreCmdSet_)
{
    sublaunchPreCmdSet = sublaunchPreCmdSet_;
    Select(ID_sublaunchPreCmdSet, (void *)&sublaunchPreCmdSet);
}

void
LaunchProfile::SetSublaunchPreCmd(const std::string &sublaunchPreCmd_)
{
    sublaunchPreCmd = sublaunchPreCmd_;
    Select(ID_sublaunchPreCmd, (void *)&sublaunchPreCmd);
}

void
LaunchProfile::SetSublaunchPostCmdSet(bool sublaunchPostCmdSet_)
{
    sublaunchPostCmdSet = sublaunchPostCmdSet_;
    Select(ID_sublaunchPostCmdSet, (void *)&sublaunchPostCmdSet);
}

void
LaunchProfile::SetSublaunchPostCmd(const std::string &sublaunchPostCmd_)
{
    sublaunchPostCmd = sublaunchPostCmd_;
    Select(ID_sublaunchPostCmd, (void *)&sublaunchPostCmd);
}

void
LaunchProfile::SetMachinefileSet(bool machinefileSet_)
{
    machinefileSet = machinefileSet_;
    Select(ID_machinefileSet, (void *)&machinefileSet);
}

void
LaunchProfile::SetMachinefile(const std::string &machinefile_)
{
    machinefile = machinefile_;
    Select(ID_machinefile, (void *)&machinefile);
}

void
LaunchProfile::SetVisitSetsUpEnv(bool visitSetsUpEnv_)
{
    visitSetsUpEnv = visitSetsUpEnv_;
    Select(ID_visitSetsUpEnv, (void *)&visitSetsUpEnv);
}

void
LaunchProfile::SetCanDoHWAccel(bool canDoHWAccel_)
{
    canDoHWAccel = canDoHWAccel_;
    Select(ID_canDoHWAccel, (void *)&canDoHWAccel);
}

void
LaunchProfile::SetHavePreCommand(bool havePreCommand_)
{
    havePreCommand = havePreCommand_;
    Select(ID_havePreCommand, (void *)&havePreCommand);
}

void
LaunchProfile::SetHwAccelPreCommand(const std::string &hwAccelPreCommand_)
{
    hwAccelPreCommand = hwAccelPreCommand_;
    Select(ID_hwAccelPreCommand, (void *)&hwAccelPreCommand);
}

void
LaunchProfile::SetHavePostCommand(bool havePostCommand_)
{
    havePostCommand = havePostCommand_;
    Select(ID_havePostCommand, (void *)&havePostCommand);
}

void
LaunchProfile::SetHwAccelPostCommand(const std::string &hwAccelPostCommand_)
{
    hwAccelPostCommand = hwAccelPostCommand_;
    Select(ID_hwAccelPostCommand, (void *)&hwAccelPostCommand);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
LaunchProfile::GetProfileName() const
{
    return profileName;
}

std::string &
LaunchProfile::GetProfileName()
{
    return profileName;
}

int
LaunchProfile::GetTimeout() const
{
    return timeout;
}

int
LaunchProfile::GetNumProcessors() const
{
    return numProcessors;
}

bool
LaunchProfile::GetNumNodesSet() const
{
    return numNodesSet;
}

int
LaunchProfile::GetNumNodes() const
{
    return numNodes;
}

bool
LaunchProfile::GetPartitionSet() const
{
    return partitionSet;
}

const std::string &
LaunchProfile::GetPartition() const
{
    return partition;
}

std::string &
LaunchProfile::GetPartition()
{
    return partition;
}

bool
LaunchProfile::GetBankSet() const
{
    return bankSet;
}

const std::string &
LaunchProfile::GetBank() const
{
    return bank;
}

std::string &
LaunchProfile::GetBank()
{
    return bank;
}

bool
LaunchProfile::GetTimeLimitSet() const
{
    return timeLimitSet;
}

const std::string &
LaunchProfile::GetTimeLimit() const
{
    return timeLimit;
}

std::string &
LaunchProfile::GetTimeLimit()
{
    return timeLimit;
}

bool
LaunchProfile::GetLaunchMethodSet() const
{
    return launchMethodSet;
}

const std::string &
LaunchProfile::GetLaunchMethod() const
{
    return launchMethod;
}

std::string &
LaunchProfile::GetLaunchMethod()
{
    return launchMethod;
}

bool
LaunchProfile::GetForceStatic() const
{
    return forceStatic;
}

bool
LaunchProfile::GetForceDynamic() const
{
    return forceDynamic;
}

bool
LaunchProfile::GetActive() const
{
    return active;
}

const stringVector &
LaunchProfile::GetArguments() const
{
    return arguments;
}

stringVector &
LaunchProfile::GetArguments()
{
    return arguments;
}

bool
LaunchProfile::GetParallel() const
{
    return parallel;
}

bool
LaunchProfile::GetLaunchArgsSet() const
{
    return launchArgsSet;
}

const std::string &
LaunchProfile::GetLaunchArgs() const
{
    return launchArgs;
}

std::string &
LaunchProfile::GetLaunchArgs()
{
    return launchArgs;
}

bool
LaunchProfile::GetSublaunchArgsSet() const
{
    return sublaunchArgsSet;
}

const std::string &
LaunchProfile::GetSublaunchArgs() const
{
    return sublaunchArgs;
}

std::string &
LaunchProfile::GetSublaunchArgs()
{
    return sublaunchArgs;
}

bool
LaunchProfile::GetSublaunchPreCmdSet() const
{
    return sublaunchPreCmdSet;
}

const std::string &
LaunchProfile::GetSublaunchPreCmd() const
{
    return sublaunchPreCmd;
}

std::string &
LaunchProfile::GetSublaunchPreCmd()
{
    return sublaunchPreCmd;
}

bool
LaunchProfile::GetSublaunchPostCmdSet() const
{
    return sublaunchPostCmdSet;
}

const std::string &
LaunchProfile::GetSublaunchPostCmd() const
{
    return sublaunchPostCmd;
}

std::string &
LaunchProfile::GetSublaunchPostCmd()
{
    return sublaunchPostCmd;
}

bool
LaunchProfile::GetMachinefileSet() const
{
    return machinefileSet;
}

const std::string &
LaunchProfile::GetMachinefile() const
{
    return machinefile;
}

std::string &
LaunchProfile::GetMachinefile()
{
    return machinefile;
}

bool
LaunchProfile::GetVisitSetsUpEnv() const
{
    return visitSetsUpEnv;
}

bool
LaunchProfile::GetCanDoHWAccel() const
{
    return canDoHWAccel;
}

bool
LaunchProfile::GetHavePreCommand() const
{
    return havePreCommand;
}

const std::string &
LaunchProfile::GetHwAccelPreCommand() const
{
    return hwAccelPreCommand;
}

std::string &
LaunchProfile::GetHwAccelPreCommand()
{
    return hwAccelPreCommand;
}

bool
LaunchProfile::GetHavePostCommand() const
{
    return havePostCommand;
}

const std::string &
LaunchProfile::GetHwAccelPostCommand() const
{
    return hwAccelPostCommand;
}

std::string &
LaunchProfile::GetHwAccelPostCommand()
{
    return hwAccelPostCommand;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LaunchProfile::SelectProfileName()
{
    Select(ID_profileName, (void *)&profileName);
}

void
LaunchProfile::SelectPartition()
{
    Select(ID_partition, (void *)&partition);
}

void
LaunchProfile::SelectBank()
{
    Select(ID_bank, (void *)&bank);
}

void
LaunchProfile::SelectTimeLimit()
{
    Select(ID_timeLimit, (void *)&timeLimit);
}

void
LaunchProfile::SelectLaunchMethod()
{
    Select(ID_launchMethod, (void *)&launchMethod);
}

void
LaunchProfile::SelectArguments()
{
    Select(ID_arguments, (void *)&arguments);
}

void
LaunchProfile::SelectLaunchArgs()
{
    Select(ID_launchArgs, (void *)&launchArgs);
}

void
LaunchProfile::SelectSublaunchArgs()
{
    Select(ID_sublaunchArgs, (void *)&sublaunchArgs);
}

void
LaunchProfile::SelectSublaunchPreCmd()
{
    Select(ID_sublaunchPreCmd, (void *)&sublaunchPreCmd);
}

void
LaunchProfile::SelectSublaunchPostCmd()
{
    Select(ID_sublaunchPostCmd, (void *)&sublaunchPostCmd);
}

void
LaunchProfile::SelectMachinefile()
{
    Select(ID_machinefile, (void *)&machinefile);
}

void
LaunchProfile::SelectHwAccelPreCommand()
{
    Select(ID_hwAccelPreCommand, (void *)&hwAccelPreCommand);
}

void
LaunchProfile::SelectHwAccelPostCommand()
{
    Select(ID_hwAccelPostCommand, (void *)&hwAccelPostCommand);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LaunchProfile::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LaunchProfile::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_profileName:         return "profileName";
    case ID_timeout:             return "timeout";
    case ID_numProcessors:       return "numProcessors";
    case ID_numNodesSet:         return "numNodesSet";
    case ID_numNodes:            return "numNodes";
    case ID_partitionSet:        return "partitionSet";
    case ID_partition:           return "partition";
    case ID_bankSet:             return "bankSet";
    case ID_bank:                return "bank";
    case ID_timeLimitSet:        return "timeLimitSet";
    case ID_timeLimit:           return "timeLimit";
    case ID_launchMethodSet:     return "launchMethodSet";
    case ID_launchMethod:        return "launchMethod";
    case ID_forceStatic:         return "forceStatic";
    case ID_forceDynamic:        return "forceDynamic";
    case ID_active:              return "active";
    case ID_arguments:           return "arguments";
    case ID_parallel:            return "parallel";
    case ID_launchArgsSet:       return "launchArgsSet";
    case ID_launchArgs:          return "launchArgs";
    case ID_sublaunchArgsSet:    return "sublaunchArgsSet";
    case ID_sublaunchArgs:       return "sublaunchArgs";
    case ID_sublaunchPreCmdSet:  return "sublaunchPreCmdSet";
    case ID_sublaunchPreCmd:     return "sublaunchPreCmd";
    case ID_sublaunchPostCmdSet: return "sublaunchPostCmdSet";
    case ID_sublaunchPostCmd:    return "sublaunchPostCmd";
    case ID_machinefileSet:      return "machinefileSet";
    case ID_machinefile:         return "machinefile";
    case ID_visitSetsUpEnv:      return "visitSetsUpEnv";
    case ID_canDoHWAccel:        return "canDoHWAccel";
    case ID_havePreCommand:      return "havePreCommand";
    case ID_hwAccelPreCommand:   return "hwAccelPreCommand";
    case ID_havePostCommand:     return "havePostCommand";
    case ID_hwAccelPostCommand:  return "hwAccelPostCommand";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LaunchProfile::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LaunchProfile::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_profileName:         return FieldType_string;
    case ID_timeout:             return FieldType_int;
    case ID_numProcessors:       return FieldType_int;
    case ID_numNodesSet:         return FieldType_bool;
    case ID_numNodes:            return FieldType_int;
    case ID_partitionSet:        return FieldType_bool;
    case ID_partition:           return FieldType_string;
    case ID_bankSet:             return FieldType_bool;
    case ID_bank:                return FieldType_string;
    case ID_timeLimitSet:        return FieldType_bool;
    case ID_timeLimit:           return FieldType_string;
    case ID_launchMethodSet:     return FieldType_bool;
    case ID_launchMethod:        return FieldType_string;
    case ID_forceStatic:         return FieldType_bool;
    case ID_forceDynamic:        return FieldType_bool;
    case ID_active:              return FieldType_bool;
    case ID_arguments:           return FieldType_stringVector;
    case ID_parallel:            return FieldType_bool;
    case ID_launchArgsSet:       return FieldType_bool;
    case ID_launchArgs:          return FieldType_string;
    case ID_sublaunchArgsSet:    return FieldType_bool;
    case ID_sublaunchArgs:       return FieldType_string;
    case ID_sublaunchPreCmdSet:  return FieldType_bool;
    case ID_sublaunchPreCmd:     return FieldType_string;
    case ID_sublaunchPostCmdSet: return FieldType_bool;
    case ID_sublaunchPostCmd:    return FieldType_string;
    case ID_machinefileSet:      return FieldType_bool;
    case ID_machinefile:         return FieldType_string;
    case ID_visitSetsUpEnv:      return FieldType_bool;
    case ID_canDoHWAccel:        return FieldType_bool;
    case ID_havePreCommand:      return FieldType_bool;
    case ID_hwAccelPreCommand:   return FieldType_string;
    case ID_havePostCommand:     return FieldType_bool;
    case ID_hwAccelPostCommand:  return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LaunchProfile::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LaunchProfile::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_profileName:         return "string";
    case ID_timeout:             return "int";
    case ID_numProcessors:       return "int";
    case ID_numNodesSet:         return "bool";
    case ID_numNodes:            return "int";
    case ID_partitionSet:        return "bool";
    case ID_partition:           return "string";
    case ID_bankSet:             return "bool";
    case ID_bank:                return "string";
    case ID_timeLimitSet:        return "bool";
    case ID_timeLimit:           return "string";
    case ID_launchMethodSet:     return "bool";
    case ID_launchMethod:        return "string";
    case ID_forceStatic:         return "bool";
    case ID_forceDynamic:        return "bool";
    case ID_active:              return "bool";
    case ID_arguments:           return "stringVector";
    case ID_parallel:            return "bool";
    case ID_launchArgsSet:       return "bool";
    case ID_launchArgs:          return "string";
    case ID_sublaunchArgsSet:    return "bool";
    case ID_sublaunchArgs:       return "string";
    case ID_sublaunchPreCmdSet:  return "bool";
    case ID_sublaunchPreCmd:     return "string";
    case ID_sublaunchPostCmdSet: return "bool";
    case ID_sublaunchPostCmd:    return "string";
    case ID_machinefileSet:      return "bool";
    case ID_machinefile:         return "string";
    case ID_visitSetsUpEnv:      return "bool";
    case ID_canDoHWAccel:        return "bool";
    case ID_havePreCommand:      return "bool";
    case ID_hwAccelPreCommand:   return "string";
    case ID_havePostCommand:     return "bool";
    case ID_hwAccelPostCommand:  return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LaunchProfile::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LaunchProfile::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LaunchProfile &obj = *((const LaunchProfile*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_profileName:
        {  // new scope
        retval = (profileName == obj.profileName);
        }
        break;
    case ID_timeout:
        {  // new scope
        retval = (timeout == obj.timeout);
        }
        break;
    case ID_numProcessors:
        {  // new scope
        retval = (numProcessors == obj.numProcessors);
        }
        break;
    case ID_numNodesSet:
        {  // new scope
        retval = (numNodesSet == obj.numNodesSet);
        }
        break;
    case ID_numNodes:
        {  // new scope
        retval = (numNodes == obj.numNodes);
        }
        break;
    case ID_partitionSet:
        {  // new scope
        retval = (partitionSet == obj.partitionSet);
        }
        break;
    case ID_partition:
        {  // new scope
        retval = (partition == obj.partition);
        }
        break;
    case ID_bankSet:
        {  // new scope
        retval = (bankSet == obj.bankSet);
        }
        break;
    case ID_bank:
        {  // new scope
        retval = (bank == obj.bank);
        }
        break;
    case ID_timeLimitSet:
        {  // new scope
        retval = (timeLimitSet == obj.timeLimitSet);
        }
        break;
    case ID_timeLimit:
        {  // new scope
        retval = (timeLimit == obj.timeLimit);
        }
        break;
    case ID_launchMethodSet:
        {  // new scope
        retval = (launchMethodSet == obj.launchMethodSet);
        }
        break;
    case ID_launchMethod:
        {  // new scope
        retval = (launchMethod == obj.launchMethod);
        }
        break;
    case ID_forceStatic:
        {  // new scope
        retval = (forceStatic == obj.forceStatic);
        }
        break;
    case ID_forceDynamic:
        {  // new scope
        retval = (forceDynamic == obj.forceDynamic);
        }
        break;
    case ID_active:
        {  // new scope
        retval = (active == obj.active);
        }
        break;
    case ID_arguments:
        {  // new scope
        retval = (arguments == obj.arguments);
        }
        break;
    case ID_parallel:
        {  // new scope
        retval = (parallel == obj.parallel);
        }
        break;
    case ID_launchArgsSet:
        {  // new scope
        retval = (launchArgsSet == obj.launchArgsSet);
        }
        break;
    case ID_launchArgs:
        {  // new scope
        retval = (launchArgs == obj.launchArgs);
        }
        break;
    case ID_sublaunchArgsSet:
        {  // new scope
        retval = (sublaunchArgsSet == obj.sublaunchArgsSet);
        }
        break;
    case ID_sublaunchArgs:
        {  // new scope
        retval = (sublaunchArgs == obj.sublaunchArgs);
        }
        break;
    case ID_sublaunchPreCmdSet:
        {  // new scope
        retval = (sublaunchPreCmdSet == obj.sublaunchPreCmdSet);
        }
        break;
    case ID_sublaunchPreCmd:
        {  // new scope
        retval = (sublaunchPreCmd == obj.sublaunchPreCmd);
        }
        break;
    case ID_sublaunchPostCmdSet:
        {  // new scope
        retval = (sublaunchPostCmdSet == obj.sublaunchPostCmdSet);
        }
        break;
    case ID_sublaunchPostCmd:
        {  // new scope
        retval = (sublaunchPostCmd == obj.sublaunchPostCmd);
        }
        break;
    case ID_machinefileSet:
        {  // new scope
        retval = (machinefileSet == obj.machinefileSet);
        }
        break;
    case ID_machinefile:
        {  // new scope
        retval = (machinefile == obj.machinefile);
        }
        break;
    case ID_visitSetsUpEnv:
        {  // new scope
        retval = (visitSetsUpEnv == obj.visitSetsUpEnv);
        }
        break;
    case ID_canDoHWAccel:
        {  // new scope
        retval = (canDoHWAccel == obj.canDoHWAccel);
        }
        break;
    case ID_havePreCommand:
        {  // new scope
        retval = (havePreCommand == obj.havePreCommand);
        }
        break;
    case ID_hwAccelPreCommand:
        {  // new scope
        retval = (hwAccelPreCommand == obj.hwAccelPreCommand);
        }
        break;
    case ID_havePostCommand:
        {  // new scope
        retval = (havePostCommand == obj.havePostCommand);
        }
        break;
    case ID_hwAccelPostCommand:
        {  // new scope
        retval = (hwAccelPostCommand == obj.hwAccelPostCommand);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method:  LaunchProfile::SelectOnlyDifferingFields
//
// Purpose:
//   Select only fields which differ from a compared attribute.
//
// Arguments:
//   other      the profile to compare against
//
// Programmer:  Jeremy Meredith
// Creation:    April 29, 2010
//
// ****************************************************************************
void
LaunchProfile::SelectOnlyDifferingFields(LaunchProfile &other)
{
    UnSelectAll();

    if (profileName != other.GetProfileName())
        Select(ID_profileName,         (void *)&profileName);
    if (timeout != other.GetTimeout())
        Select(ID_timeout,             (void *)&timeout);
    if (numProcessors != other.GetNumProcessors())
        Select(ID_numProcessors,       (void *)&numProcessors);
    if (numNodesSet != other.GetNumNodesSet())
        Select(ID_numNodesSet,         (void *)&numNodesSet);
    if (numNodes != other.GetNumNodes())
        Select(ID_numNodes,            (void *)&numNodes);
    if (partitionSet != other.GetPartitionSet())
        Select(ID_partitionSet,        (void *)&partitionSet);
    if (partition != other.GetPartition())
        Select(ID_partition,           (void *)&partition);
    if (bankSet != other.GetBankSet())
        Select(ID_bankSet,             (void *)&bankSet);
    if (bank != other.GetBank())
        Select(ID_bank,                (void *)&bank);
    if (timeLimitSet != other.GetTimeLimitSet())
        Select(ID_timeLimitSet,        (void *)&timeLimitSet);
    if (timeLimit != other.GetTimeLimit())
        Select(ID_timeLimit,           (void *)&timeLimit);
    if (launchMethodSet != other.GetLaunchMethodSet())
        Select(ID_launchMethodSet,     (void *)&launchMethodSet);
    if (launchMethod != other.GetLaunchMethod())
        Select(ID_launchMethod,        (void *)&launchMethod);
    if (forceStatic != other.GetForceStatic())
        Select(ID_forceStatic,         (void *)&forceStatic);
    if (forceDynamic != other.GetForceDynamic())
        Select(ID_forceDynamic,        (void *)&forceDynamic);
    if (active != other.GetActive())
        Select(ID_active,              (void *)&active);
    if (arguments != other.GetArguments())
        Select(ID_arguments,           (void *)&arguments);
    if (parallel != other.GetParallel())
        Select(ID_parallel,            (void *)&parallel);
    if (launchArgsSet != other.GetLaunchArgsSet())
        Select(ID_launchArgsSet,       (void *)&launchArgsSet);
    if (launchArgs != other.GetLaunchArgs())
        Select(ID_launchArgs,          (void *)&launchArgs);
    if (sublaunchArgsSet != other.GetSublaunchArgsSet())
        Select(ID_sublaunchArgsSet,    (void *)&sublaunchArgsSet);
    if (sublaunchArgs != other.GetSublaunchArgs())
        Select(ID_sublaunchArgs,       (void *)&sublaunchArgs);
    if (sublaunchPreCmdSet != other.GetSublaunchPreCmdSet())
        Select(ID_sublaunchPreCmdSet,  (void *)&sublaunchPreCmdSet);
    if (sublaunchPreCmd != other.GetSublaunchPreCmd())
        Select(ID_sublaunchPreCmd,     (void *)&sublaunchPreCmd);
    if (sublaunchPostCmdSet != other.GetSublaunchPostCmdSet())
        Select(ID_sublaunchPostCmdSet, (void *)&sublaunchPostCmdSet);
    if (sublaunchPostCmd != other.GetSublaunchPostCmd())
        Select(ID_sublaunchPostCmd,    (void *)&sublaunchPostCmd);
    if (machinefileSet != other.GetMachinefileSet())
        Select(ID_machinefileSet,      (void *)&machinefileSet);
    if (machinefile != other.GetMachinefile())
        Select(ID_machinefile,         (void *)&machinefile);
    if (visitSetsUpEnv != other.GetVisitSetsUpEnv())
        Select(ID_visitSetsUpEnv,      (void *)&visitSetsUpEnv);
    if (canDoHWAccel != other.GetCanDoHWAccel())
        Select(ID_canDoHWAccel,        (void *)&canDoHWAccel);
    if (havePreCommand != other.GetHavePreCommand())
        Select(ID_havePreCommand,      (void *)&havePreCommand);
    if (hwAccelPreCommand != other.GetHwAccelPreCommand())
        Select(ID_hwAccelPreCommand,   (void *)&hwAccelPreCommand);
    if (havePostCommand != other.GetHavePostCommand())
        Select(ID_havePostCommand,     (void *)&havePostCommand);
    if (hwAccelPostCommand != other.GetHwAccelPostCommand())
        Select(ID_hwAccelPostCommand,  (void *)&hwAccelPostCommand);
}

