/**
 * Acts as a MUDMaster/ZChat chat server.
 *
 * Accepts connections from other users.
 */

#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <malloc.h>

#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "zchat.h"

static int fd;

int server_init(int port) {
  static struct sockaddr_in sa_zero;
  struct sockaddr_in sa;
  int x = 1; // SO_REUSEADDR

  fd = socket(AF_INET, SOCK_STREAM, 0);
  if (fd < 0) {
    perror("ServerSocket::create: socket");
    return 0;
  }

  if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (char *) &x, sizeof(x)) < 0) {
    perror("ServerSocket::create: setsockopt");
    close(fd);
    return 0;
  }

  if (fcntl(fd, F_SETFD, FD_CLOEXEC) < 0) {
    perror("ServerSocket::create: fcntl");
    close(fd);
    return 0;
  }

  if (fcntl(fd, F_SETFL, O_NONBLOCK) == -1) {
    perror("ServerSocket::create: fcntl");
    close(fd);
    return 0;
  }

  sa = sa_zero;
  sa.sin_family = AF_INET;
  sa.sin_port = htons(port);

  if (bind(fd, (struct sockaddr *)&sa, sizeof(sa)) < 0) {
    perror("ServerSocket::create: bind");
    close(fd);
    return 0;
  }


  if (listen(fd, 128)) {
    perror("ServerSocket::listen: listen");
    close(fd);
    return 0;
  }

  printf("Papaya Chat now listening for chat requests.\n");
  return 1;
}

int server_accept() {
  int nfd = -1;
  struct sockaddr_in * addr = (struct sockaddr_in *)malloc(sizeof(struct sockaddr_in));
  unsigned int size = sizeof(struct sockaddr_in);
  struct connection * tmp;
  char buf[16384];

  nfd = accept(fd, (struct sockaddr *)addr, &size);
  if (nfd < 0) {
    if (errno == EWOULDBLOCK)
      return -1;

    perror("ServerSocket::accept: accept");
    exit(1);
  }

  if (getpeername(nfd, (struct sockaddr *)addr, &size) < 0) {
    perror("ServerSocket::accept: getpeername");
    close(nfd);
    return -1;
  }

  if (fcntl(nfd, F_SETFL, O_NONBLOCK) == -1) {
    perror("ServerSocket::accept: fcntl");
    close(nfd);
    return -1;
  }
  
  /* Create a new connection with this file descriptor. */
  tmp = new_connection(nfd);
  tmp->status = ConnWaitingForConnectString;
  tmp->client = addr;
  tmp->server_connection = 1;
  sprintf(buf, "Accepted connection on fd %d.\n", nfd);
  output_append(buf);
  return nfd;
}
