#ifndef TURFPROTOCOL_H
#define TURFPROTOCOL_H

#include "papaya/Plugin.h"

#include <list>
#include <algorithm>

typedef void (*CallbackPtr)(Connection *, char *, void *);

struct turf_data {
  bool supported; // Does this connection support Turf Protocol, default = false
  Connection * connection;
};

#define C4_WIDTH 7
#define C4_HEIGHT 7
#define C4_GAP 10

struct c4_data {
  Connection * connection;

  GtkWidget * board;
  GtkWidget * board_window;
  GtkWidget * board_status;
  GtkWidget * dialog;

  char * current_request;

  GtkWidget * player_list_window;
#ifdef USE_GTK
  GtkWidget * player_list; // The CList
#else
  GtkListStore * player_list_store;
  GtkWidget * player_list_view;
#endif

  short pieces[C4_WIDTH][C4_HEIGHT];
  int a, b, c, d;
  bool gameover;
};

struct TurfProtocolCallback {

  struct TurfProtocolCallback * next;

  Connection * conn;
  char * command;
  CallbackPtr callback;
  void * data;
  int id;
  bool reading; // Are we currently reading this command.
};

class G_MODULE_EXPORT TurfProtocol : public Plugin {

 public:

  TurfProtocol();
  ~TurfProtocol();

  void addCommand(Connection * c, char * command, CallbackPtr callback, void * data);
  void remove(struct TurfProtocolCallback *);
  void output(Connection *, char *);


  void pageSwitched();

  bool isSupported(Connection *);


  void canUse(Connection *);
  void onEvent(Event *, Connection *);
  char * getDescription();

  // Connect Four stuff

  void challengePlayer(struct c4_data *, char *);
  void boardClicked(GtkWidget *, GdkEvent *, gpointer);
  void exposeEvent(GtkWidget * widget, GdkEventExpose * expose, gpointer d);
  void okClicked(GtkWidget *, gpointer);
  void cancelClicked(GtkWidget *, gpointer);
  void getPlayers();

  static void keepalive_send(Connection *);

  void activate(GtkWidget *, gpointer);

  struct turf_data * find_turf_data(Connection *);
  struct c4_data * find_c4_data(Connection *);
  void remove_turf_data(struct turf_data *);
  void delete_turf_data(Connection *);
  void remove_c4_data(struct c4_data *);
  
 private:

  // Connect Four stuff

  void receiveCommand(char *);
  void readTurfProtocol(Connection *, char *);
  void readName(Connection *, char *);
  void readMessage(Connection *, char *);
  void readSiteInfo(Connection *, char *);
  void readConnectFour(Connection *, char *);
  void createBoard(Connection *);
  void create_c4_board(struct c4_data *);
  void init_c4_data(struct c4_data *);
  void placePiece(Connection *, char *);
  void placeLine(Connection *, char *);
  void displayMessage(Connection *, char *);
  void receiveChallenge(Connection *, char *);
  void addPlayer(Connection *, char *);
  struct c4_data * createPlayerList(Connection *);

  typedef std::list<struct c4_data *> C4DataList;
  std::list<struct c4_data *> c4Data;

  // Other stuff

  struct TurfProtocolCallback * first_cb;
  int id; // Used to generate a unique ID for each call.

  SystemTriggerEntity * identify_trigger, * identify_trigger2, * client_connect;

  typedef std::list<struct turf_data *> TurfDataList;
  std::list<struct turf_data *> turfData;
};

// Connect Four Functions
void create_c4_player_list(struct c4_data *);

void on_c4_list_select_row_gtk2(GtkTreeView *, void * arg, GtkTreeViewColumn * column, gpointer data);

void on_c4_challenge_button_clicked(GtkButton *, gpointer);
void on_c4_cancel_button_clicked(GtkButton *, gpointer);

void c4_board_clicked(GtkWidget *, GdkEvent *, gpointer);
void c4_expose_event(GtkWidget * widget, GdkEventExpose * expose, gpointer d);

void c4_ok_clicked(GtkWidget *, gpointer);
void c4_cancel_clicked(GtkWidget *, gpointer);

void mudmenu_add_item(char * name, GtkItemFactoryCallback callback);

void keepalive_callback(Connection *, char *, void *);

// Keepalive function pointer for non-Turfish muds - this has to be
// in this context or dlopen gets stroppy.
#ifndef WIN32 // No dlopen() atm
void (*turf_old_keepalive)(Connection *);
#else
extern void (*turf_old_keepalive)(Connection *);
#endif

#endif // TURFPROTOCOL_H
