#include "Area.h"
#include "Room.h"

extern struct directions direction_table[];
const char * fmtString = "%n\n[Exits: %e]\n%d";

Area::Area() {
  roomList = new PapayaList();
  currentRoom = NULL;
}

Area::~Area() {

  for (PapayaListElement * tmp = roomList->firstElement; tmp; tmp = tmp->getNext()) {
    delete (Room *)tmp->getData();
    tmp->setData(NULL);
  }

  delete roomList;

}

void Area::newRoom(struct mapper_data * data) {

  Room * room = new Room(getUniqueID());

  int x, y, z;
  if (!currentRoom)
    x = y = z = 0;
  else {
    x = currentRoom->getX();
    y = currentRoom->getY();
    z = currentRoom->getZ();
  }

  // Figure out modifiers
  int i = 0;
  while (1) {
    if (!direction_table[i].full_name) {
      printf("Failed to add room in that direction.\n");
      delete room;
      return;
    }

    if (!strcmp(data->cmd, direction_table[i].full_name)
	|| !strcmp(data->cmd, direction_table[i].abbreviated_name)) {

      break;
    }

    i++;
  }

  x += direction_table[i].x_mod;
  y += direction_table[i].y_mod;
  z += direction_table[i].z_mod;

  room->setLocation(x, y, z);

  // For the moment we are assuming a one-way exit.
  if (currentRoom) {
    Exit * exit = currentRoom->exits[direction_table[i].direction];
    if (exit->to) {
      printf("There is already a room there!\n");
      delete room;
      return;
    }
    
    exit->to = room;
    exit->from = currentRoom;
  }

  roomList->newEntry(room);
  currentRoom = room;

  room->parseOutput((char *)fmtString, data->record_buf);

  printf("Added a new room.\n");
  //  printArea();
  //  exportArea();
}

int Area::getUniqueID() {
  return unique_id++;
}

void Area::printArea() {
  // @@ Use standard C++ lists.
  for (PapayaListElement * tmp = roomList->firstElement; tmp; tmp = tmp->getNext())
    ((Room *)tmp->getData())->printRoom();
}


void Area::exportArea() {

  FILE * fp;

  // @@ Import openFile into plugin source code as otherwise it depends
  //    on Papaya too much.
  fp = fopen("test.fig", "w");
  if (!fp) {
    perror ("fopen");
    return;
  }

  fprintf(fp, "#FIG 3.2\n"
	  "Landscape\n"
	  "Center\n"
	  "Inches\n"
	  "Letter\n"
	  "100.00\n"
	  "Single\n"
	  "-2\n"
	  "1200 2\n");

  for (PapayaListElement * tmp = roomList->firstElement; tmp; tmp = tmp->getNext())
    ((Room *)tmp->getData())->exportRoom(fp);

  fclose(fp);

}
