#ifndef INCLUDE_BSXCACHE_H
#define INCLUDE_BSXCACHE_H

#include <list>
#include <algorithm>

typedef struct bsx_cache_entry_ {
  char * name;
  char * data;
} BSXCacheEntry;

class BSXCache {

 public:
  BSXCache(unsigned int);
  ~BSXCache();

  void insert(char * name, char * data);
  void remove(char * name);

  void replace(char * name, char * data);
  BSXCacheEntry * retrieve(char * name);

  void setMaxSize(unsigned int);
  unsigned int getMaxSize();
  unsigned int getCurrentSize();

 private:

  void expire();
  void expire(BSXCacheEntry *);
  unsigned int max_size;

  typedef std::list<BSXCacheEntry *> EntryList;
  std::list<BSXCacheEntry *> entries;


};

#endif // INCLUDE_BSXCACHE_H
