#include <list>
#include <algorithm>
#include <stdio.h>

#include "BSXCache.h"

BSXCache::BSXCache(unsigned int m) {
  setMaxSize(m);
  insert("dummy_entry", "");
}


BSXCache::~BSXCache() {
  // Delete any stored objects.
  EntryList::iterator next;
  for (EntryList::iterator i = entries.begin();
       i != entries.end();
       i = next) {
    next = i;
    ++next;

    free ((*i)->name);
    free ((*i)->data);
    free (*i);

    entries.erase(i);
  }
}

int EntryCmp(BSXCacheEntry * e1, BSXCacheEntry * e2) {
  return (e1 < e2);
}

void BSXCache::insert(char * n, char * d) {

  unsigned int size = strlen(d) + 1;

  if (size >= getMaxSize()) {
    // Item is too big to fit in the cache.
    printf("Item %s too big to fit in cache.\n", n);
    return;
  }

  // Expire items if necessary to fit this item in.
  while (size + getCurrentSize() >= getMaxSize()) {
    expire();
  }

  // Stick this into the list.
  BSXCacheEntry * e = (BSXCacheEntry *)malloc(sizeof(BSXCacheEntry));
  e->name = strdup(n);
  e->data = strdup(d);

  EntryList::iterator i = std::lower_bound(entries.begin(),
					   entries.end(),
					   e,
					   EntryCmp);

  entries.insert(i, e);

}


void BSXCache::remove(char * n) {
  BSXCacheEntry * e = NULL;
  EntryList::iterator i;

  for (i = entries.begin();
       i != entries.end();
       ++i ) {
    if (!strcmp((*i)->name, n)) {
      e = (*i);
      break;
    }
  }

  if (!e) {
    return;
  }

  i = std::lower_bound(entries.begin(),
					   entries.end(),
					   e,
					   EntryCmp);

  if (i == entries.end() || (*i) != e) {
    return;
  }

  entries.erase(i);

  free(e->name);
  free(e->data);
  free(e);
}

void BSXCache::replace(char * n, char * d) {

  for (EntryList::iterator i = entries.begin();
       i != entries.end();
       ++i ) {
    BSXCacheEntry * entry = (*i);
    if (!strcmp(entry->name, n)) {

      unsigned int size = strlen(d) + 1;
      // Expire items if necessary to fit this item in.
      while (size + getCurrentSize() >= getMaxSize()) {
	expire(entry);
      }

      if (entry->data) {
	free(entry->data);
      }

      entry->data = strdup(d);
      return;
    }
  }
}

BSXCacheEntry * BSXCache::retrieve(char * n) {
  for (EntryList::iterator i = entries.begin();
       i != entries.end();
       ++i ) {
    BSXCacheEntry * entry = (*i);

    if (!strcmp(entry->name, n)) {
      return entry;
    }
  }

  return NULL;
} 


unsigned int BSXCache::getMaxSize() {
  return max_size;
}

void BSXCache::setMaxSize(unsigned int m) {
  max_size = m;
}

unsigned int BSXCache::getCurrentSize() {
  int current_size = 0;

  for (EntryList::iterator i = entries.begin();
       i != entries.end();
       ++i )
    current_size += strlen((*i)->data);

  return current_size;
}

void BSXCache::expire(BSXCacheEntry * entry) {
  // Do NOT expire this cache entry.

}

void BSXCache::expire() {

  printf("Replace me with a cache expiry policy or loop infinitely.\n");

  


}
