#include "HistoryPreference.h"
#include "mudclient.h"

#include <gmodule.h>

static HistoryPreference * historyPreference;

HistoryPreference::HistoryPreference() {
  historyPreference = this;
  xml = NULL;

  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HistoryUseLimit", "history_limit_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HistoryIgnoreRepeats", "history_consecutive_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HistoryHonourNull", "history_empty_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HistoryCircular", "history_wrap_checkbox", WidgetToggle));
  availablePreferences = g_list_append(availablePreferences, new PreferenceOptions("HistoryLimit", "history_limit_spinbutton", WidgetSpinbutton));


}

HistoryPreference::~HistoryPreference() {
  if (xml)
    g_object_unref(xml);
  historyPreference = NULL;
}

GtkWidget * HistoryPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/historypreferences.glade", getPrefix());

  // Cache the xml object between calls.
  if (!xml) {
    xml = glade_xml_new(buf, NULL, NULL);
    glade_xml_signal_autoconnect(xml);
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox1");
    gtk_widget_show(vbox);
    return vbox;
  }

  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox1");
  return vbox;
}

void HistoryPreference::destroyWidget() {
  g_object_unref(xml);
  xml = NULL;
}

Category * HistoryPreference::getCategories() {
  return (Category *)history_categories;
}

void HistoryPreference::setHistoryLimitState(bool enable) {
  gtk_widget_set_sensitive(glade_xml_get_widget(xml, "history_limit_spinbutton"), enable);
}


extern "C" G_MODULE_EXPORT gint on_history_limit_checkbox_toggled(GtkWidget * widget, gpointer data) {
  historyPreference->setHistoryLimitState(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)));
  return 1;
}
