/**
 * Win32PluginAPITable.h
 *
 * Included only on WIN32, but also #defined to ensure only used on WIN32.
 *
 * Do not #include any Papaya header files.  Instead declare classes using
 * 'class <classname>;'
 */

#ifndef WIN32_PLUGIN_TABLE_H
#define WIN32_PLUGIN_TABLE_H

#ifdef WIN32

class CommandInterpreter;
class BaseWindow;
class EntityHandler;
class PluginHandler;
class Preference;
class SystemTriggerEntity;
class Fade;
class Entity;
class Message;
class Socket;
class Connection;
class VT;
class MUD;
class Prefs;
class Event;

#include "papaya/system.h"
#include "papaya/Event.h"

typedef void (*addr_register_plugin)(Plugin *, char *);
typedef void (*addr_unregister_plugin)(Plugin *);

typedef void (*addr_preference_add_editor)(Preference *);
typedef void (*addr_preference_remove_editor)(Preference *);

typedef Socket * (*addr_connection_get_socket)(Connection *);
typedef VT * (*addr_connection_get_vt)(Connection *);
typedef MUD * (*addr_connection_get_mud)(Connection *);

typedef void (*addr_vt_append)(VT *, char *);
typedef void (*addr_vt_add_to_tray)(VT *, GtkWidget *, GtkWidget **);
typedef void (*addr_vt_remove_from_tray)(VT *, GtkWidget *, GtkWidget *);
typedef void (*addr_vt_scroll)(VT *);

typedef int (*addr_socket_write)(Socket *, char *, int);
typedef bool (*addr_socket_get_telnet_option)(Socket *, int);

typedef EvType (*addr_event_get_type)(Event *);

typedef char * (*addr_connection_get_name)(Connection *);
typedef Connection * (*addr_connection_get_next)(Connection *);
typedef Prefs * (*addr_connection_query_preferences)(Connection *);

typedef char * (*addr_get_prefix)();

typedef char * (*addr_preferences_get_preference)(Prefs *, char *);
typedef void (*addr_preferences_set_preference)(Prefs *, char *, char *);
typedef int (*addr_preferences_get_preference_integer)(Prefs *, char *);
typedef void (*addr_preferences_set_preference_integer)(Prefs *, char *, int);
typedef bool (*addr_preferences_get_preference_boolean)(Prefs *, char *);
typedef void (*addr_preferences_set_preference_boolean)(Prefs *, char *, bool);

typedef Prefs * (*addr_get_global_preferences)();
typedef Connection * (*addr_get_first_connection)();
typedef CommandInterpreter * (*addr_get_command_interpreter)();
typedef BaseWindow * (*addr_get_main_window)();
typedef PluginHandler * (*addr_get_plugin_handler)();
typedef EntityHandler * (*addr_get_entity_handler)();
typedef Connection * (*addr_get_connection_by_name)(char *);

typedef Connection * (*addr_main_window_get_current_connection)(BaseWindow *);
typedef GtkItemFactory * (*addr_main_window_get_item_factory)(BaseWindow *);
typedef GtkWidget * (*addr_main_window_add_page_for_app)(BaseWindow *, char *);

typedef void (*addr_entity_handler_add_entity)(EntityHandler *, char * group, void * entity);
typedef void (*addr_entity_handler_remove_entity)(EntityHandler *, void * entity);

typedef SystemTriggerEntity * (*addr_system_trigger_entity_new)(char *, Connection *, SystemTriggerCallbackFunction, void *);

typedef void (*addr_command_interpreter_interpret)(CommandInterpreter *, Connection *, char *);

typedef void (*addr_plugin_handler_client_message)(PluginHandler *, Connection *, char *);
typedef void (*addr_plugin_handler_add_input_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_add_output_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_add_prompt_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_add_telopt_filter)(PluginHandler *, Plugin *, unsigned char);
typedef void (*addr_plugin_handler_remove_input_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_remove_output_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_remove_prompt_filter)(PluginHandler *, Plugin *);
typedef void (*addr_plugin_handler_remove_telopt_filter)(PluginHandler *, Plugin *, unsigned char);
typedef void (*addr_plugin_handler_remove_telopt_filters)(PluginHandler *, Plugin *);

typedef Prefs * (*addr_mud_get_preferences)(MUD *);
typedef char * (*addr_mud_get_password)(MUD *);
typedef void (*addr_mud_set_password)(MUD *, char *);
typedef char * (*addr_mud_get_login_name)(MUD *);
typedef void (*addr_mud_set_login_name)(MUD *, char *);
typedef char * (*addr_mud_get_login_trigger)(MUD *);
typedef void (*addr_mud_set_login_trigger)(MUD *, char *);
typedef char * (*addr_mud_get_password_trigger)(MUD *);
typedef void (*addr_mud_set_password_trigger)(MUD *, char *);

typedef void (*addr_turf_protocol_add_command)(void *, char *, void *, gpointer);
typedef bool (*addr_turf_protocol_is_supported)(void *);

typedef Message * (*addr_message_new)(char *, char *, bool);

typedef GdkColor * (*addr_fade_get_shade)(Fade *, int, int);
typedef GtkWidget * (*addr_fade_get_editor)(Fade *);
typedef void (*addr_fade_on_prefs_cancel)(Fade *);
typedef void (*addr_fade_on_prefs_apply)(Fade *);
typedef char * (*addr_fade_string_max_colour)(Fade *);
typedef char * (*addr_fade_string_mid_colour)(Fade *);
typedef char * (*addr_fade_string_min_colour)(Fade *);
typedef char * (*addr_fade_string_use_three)(Fade *);
typedef Fade * (*addr_fade_new)(gboolean, char *, char *, char *);
typedef void (*addr_fade_reset)(Fade *, gboolean, char *, char *, char *);
typedef void (*addr_fade_delete)(Fade *);

typedef struct {
#include "Win32PluginApiDecl.h"
} plugin_address_table_t;

#else

typedef void * plugin_address_table_t;

#endif

#endif // WIN32_PLUGIN_TABLE_H
