#ifndef PLUGINHANDLER_H
#define PLUGINHANDLER_H

#if defined(WIN32) && !defined(__MINGW32__)
// Disable warnings about debug tokens being too long.
#pragma warning(disable : 4786)

// However, thanks to a compiler bug this may not work. :(
#endif

#include "PapayaList.h"
#include "papaya/Plugin.h"

#include <gmodule.h>
#include <list>
#include <algorithm>

typedef PapayaList List;
typedef PapayaListElement ListElement;

struct handler_entry {
  struct handler_entry * next;
  GModule * handler;
};

struct telopt_filter_entry {
  Plugin * plugin;
  unsigned char option; // The option to look for.
};

class PluginData;

class PluginHandler {

 public:

  PluginHandler();
  ~PluginHandler();

  void unloadPlugins();
  void loadPlugins();
  void loadFile(PluginData *);
  void unloadFile(PluginData *);

  void registerPlugin(Plugin *, char *);
  void unregisterPlugin(Plugin *);
  void addHandlerEntry(GModule *);

  GModule * findPlugin(char *);
  void * findPlugin(char *, char *);

  void displayPlugins();

  // @@  GtkWidget * pluginList;

  void saveConfigFile();

  /* Shouldn't need to change these. */

  void addInputFilter(Plugin *);
  void addOutputFilter(Plugin *);
  void addPromptFilter(Plugin *);
  void removeInputFilter(Plugin *); // called by unregisterPlugin
  void removeOutputFilter(Plugin *); // called by unregisterPlugin
  void removePromptFilter(Plugin *); // called by unregisterPlugin

  void addTeloptFilter(Plugin *, unsigned char option);
  void removeTeloptFilter(Plugin *, unsigned char option);
  void removeTeloptFilters(Plugin *); // called by unregisterPlugin

  void processInputFilters(Connection *, char *);
  void processOutputFilters(Connection *, char *);
  void processPromptFilters(Connection *, char *);

  void teloptSubneg(Connection *, Telnet::option_t, char *, int);
  bool teloptAllowLocal(Connection *, Telnet::option_t);
  bool teloptAllowRemote(Connection *, Telnet::option_t);
  void teloptHandleRemote(Connection *, Telnet::option_t, bool);

  void clientMessage(Connection *, char *);
  void pageSwitched();


  void fireEvent(Event *, Connection *);
  void promptExpose(GtkWidget *, GdkEventExpose *, gpointer);

  void updateAvailablePlugins();
  void displayAvailablePlugins();

  void loadConfigFile();
  void checkPlugins();
  void loadPluginData(); // Loads plugin data from the .so files.

  void onPrefsApply(MUD *);
  void onPrefsOk(MUD *);
  void onPrefsCancel(MUD *);
  void savePrefs(FILE *, MUD *);

  void toggleEnabled(char * name);


 private:

  PapayaList * pluginList; // The currently loaded set of plugins.
  PapayaList * availablePlugins; // The available set of plugins.

  struct handler_entry * first_handler;
  GtkWidget * create_plugin_list();
  void populate_plugin_list();

  void checkToLoad(PluginData *, bool);
  void checkDirForPlugins(char *);
  void loadEnabledPlugins();

  PluginData * queryPlugin(char * file, char * path);
  bool isNameValid(char *); // Gareth Owen

  char module_message[16384];

  typedef std::list<Plugin *> PluginList;
  typedef std::list<struct telopt_filter_entry *> TeloptList;

  std::list<Plugin *> outputFilters;
  std::list<Plugin *> inputFilters;
  std::list<Plugin *> promptFilters;
  std::list<struct telopt_filter_entry *> teloptFilters;

  /*
  GtkWidget * pluginList_clist;
  void create_pluginList();
  */
};

#endif
