#ifndef INCLUDE_GNOMEWINDOWTWO_H
#define INCLUDE_GNOMEWINDOWTWO_H

#include "BaseWindow.h"

class GnomeWindowTwo : public BaseWindow {

 public:

  GnomeWindowTwo();
  ~GnomeWindowTwo();

  // Event generated - we switched to page x.
  void pageSwitch(int);

  // Please switch to the next page.
  void nextPage();
  // Please switch to page x.
  void switchPage(int);
  void switchPage(Connection *);
  void switchPage(GtkWidget *);

  // Please attempt to swallow an application.
  void swallow();

  // Please close the currently active window.
  void closeWindow();

  // Please add a notebook page with specified name.
  GtkWidget * addPageForApp(char *);

  // Please add a page with specified name and specified contents.
  void addPage(char *, GtkWidget *);

  void fixMenus(Connection *);

  void addConnection(Connection *);
  void removeConnection(Connection *);
  Connection * getCurrentConnection();

  void nextText(Connection *);

  void addCustomMenu(char *, GtkItemFactoryCallback);

  //  void createPopupMenu(GtkWidget *, Connection *);

  int timeout();
  int callback(int);

 private:

  void createInterface();

  // How many pages have we in our notebook?
  int numPages();

  GtkWidget * notebook;
  GtkWidget * background_pixmap;
  GtkWidget * window;
  GtkWidget *appbar1;
  void setTitle(char *);
  
  int configureUsers();
  int count_timeout;

};

#endif //  INCLUDE_GNOMEWINDOW_H
