// Tell emacs this is really -*- C++ -*-

#ifndef INCLUDE_BUFFER_H
#define INCLUDE_BUFFER_H

class Buffer
{

public:
    Buffer();
    ~Buffer();

    void append(char *);
    void append(char *, int);
    void append(Buffer &);
    
    char * getText(void);
    int getLength(void);
   
    void reset(void);
    void trim(void);
    void strip(int);
    
    char *prepare_space(int);
    void consume_space(int);
    
    void swap(Buffer &other);
    void transfer_to(Buffer &dest);
    
    void discard_end(int len);
    
private:    
    char * body;
    int length;

    int max_len;
    
};

#endif



