#ifndef __AGGREGATOR_H_2007_06_2
#define __AGGREGATOR_H_2007_06_2


#include <ept/debtags/debtags.h>
#include <ept/apt/apt.h>


namespace ept {
namespace apt {
class Apt;
}
namespace debtags {
class Debtags;
class Vocabulary;
}
namespace textsearch {
class TextSearch;
}

/**
 * Aggregate libept data providers in a convenient place.
 *
 * \note The new ept does not have an aggregator anymore, but we can simply
 *       rebuild one here.
 */
class Aggregator
{
	ept::apt::Apt* m_apt;
	ept::debtags::Debtags* m_debtags;
	ept::textsearch::TextSearch* m_textsearch;
public:
	Aggregator();
	~Aggregator();

	/// Reinstantiate the data providers once the caches change
	void invalidate();

	ept::apt::Apt& apt() { return *m_apt; }
	const ept::apt::Apt& apt() const { return *m_apt; }
	ept::debtags::Debtags& debtags() { return *m_debtags; }
	const ept::debtags::Debtags& debtags() const { return *m_debtags; }
	ept::debtags::Vocabulary& vocabulary();
	const ept::debtags::Vocabulary& vocabulary() const;
	ept::textsearch::TextSearch& textsearch() { return *m_textsearch; }
	const ept::textsearch::TextSearch& textsearch() const { return *m_textsearch; }
};

}	// namespace ept

#endif //	__AGGREGATOR_H_2007_06_2

