///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __SCRIPTING_PLUGIN_H
#define __SCRIPTING_PLUGIN_H

// Microsoft VC 8 specifc
#ifndef _CRT_SECURE_NO_DEPRECATE
	#define _CRT_SECURE_NO_DEPRECATE 1	// Tell the compiler to stop complaining about using localtime etc...
#endif
#ifndef _SCL_SECURE_NO_DEPRECATE
	#define _SCL_SECURE_NO_DEPRECATE 1	// Stop complaining about std::copy etc...
#endif
#ifndef _CRT_NONSTDC_NO_DEPRECATE
	#define _CRT_NONSTDC_NO_DEPRECATE 1	// To stop complaining about old POSIX names.
#endif

// Include the Boost.Python library.
#include <boost/python.hpp>
#include <boost/python/to_python_converter.hpp>
#include <boost/python/object.hpp>
#include <boost/python/handle.hpp>
#include <boost/python/iterator.hpp>
#include <boost/python/suite/indexing/indexing_suite.hpp>
#include <boost/python/suite/indexing/vector_indexing_suite.hpp>
#include <boost/python/suite/indexing/map_indexing_suite.hpp>
#include <boost/python/exec.hpp>

// Always include the core module. 
#include <core/Core.h>

/******************************************************************************
* Define the DLL export macros.
******************************************************************************/
#ifdef MAKING_MODULE_SCRIPTING
#define SCRIPTING_DLLEXPORT DLL_EXPORT_DECL
#else
#define SCRIPTING_DLLEXPORT DLL_IMPORT_DECL
#endif

#endif // __SCRIPTING_PLUGIN_H
