/**
  @file bt-utils.c

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <glib.h>

#include "bt-utils.h"

#define BDA_STRLEN 17

gboolean bda_ok(const char *bda)
{
    int i;
    if (strlen(bda) != BDA_STRLEN)
        return FALSE;
    for (i = 0; i < BDA_STRLEN; i++) {
        if (!(isxdigit(bda[i]) || bda[i] == ':'))
            return FALSE;
    }
    return TRUE;
}

