// This software is released into the Public Domain.  See copying.txt for details.
package org.openstreetmap.osmosis.core.mysql.v0_5.impl;

import org.openstreetmap.osmosis.core.domain.v0_5.Tag;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;


/**
 * A data class for representing an entity tag database record. This extends a
 * tag with fields relating it to the owning entity.
 * 
 * @author Brett Henderson
 */
public class DBEntityTag implements Storeable {
	
	private long entityId;
	private Tag tag;
	
	
	/**
	 * Creates a new instance.
	 * 
	 * @param entityId
	 *            The owning entity id.
	 * @param tag
	 *            The tag to be wrapped.
	 */
	public DBEntityTag(long entityId, Tag tag) {
		this.entityId = entityId;
		this.tag = tag;
	}
	
	
	/**
	 * Creates a new instance.
	 * 
	 * @param sr
	 *            The store to read state from.
	 * @param scr
	 *            Maintains the mapping between classes and their identifiers
	 *            within the store.
	 */
	public DBEntityTag(StoreReader sr, StoreClassRegister scr) {
		this(
			sr.readLong(),
			new Tag(sr, scr)
		);
	}
	
	
	/**
	 * {@inheritDoc}
	 */
	public void store(StoreWriter sw, StoreClassRegister scr) {
		sw.writeLong(entityId);
		tag.store(sw, scr);
	}
	
	
	/**
	 * @return The entity id.
	 */
	public long getEntityId() {
		return entityId;
	}
	
	
	/**
	 * @return The tag.
	 */
	public Tag getTag() {
		return tag;
	}
}
