
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_database.h
**  Date:    June 2, 2002
**
**  Author:  Brian Wotring
**  Purpose: handle various database operations for management daemon.
**
******************************************************************************/

#ifndef MD_DATABASE_H_
#define MD_DATABASE_H_


#define DB_FILE_READ_CHUNK_SIZE 	512


int create_new_database_for_host( OSI_DB *db,
                                  OSI_HOST *host );

int generate_new_database_name_for_host( char *name, int name_size,
                                         const char *host, osi_bool archiving,
                                         const char *base_db );

int osi_host_remove_db( const char *host, const char *name );

int osi_host_open_default_db( OSI_DB *db,
                              OSI_HOST *host );

int osi_host_read_databases( OSI_HOST *host );
int osi_host_read_database_briefs( OSI_HOST *host );

int osi_host_set_database_path_with_name( OSI_DB *db, const char *host,
                                          const char *name );

int osi_host_read_database_header_from_path( OSI_DB_HEADER *db_header,
                                             const char *path );

int osi_host_read_database_header_with_name( OSI_DB_HEADER *db_header,
                                             const char *host,
                                             const char *name );

int osi_host_read_database_brief_with_name( OSI_DATABASE_BRIEF *db_brief,
                                            const char *host,
                                            const char *name );

FILE * osi_host_open_db_file_read_only( const char *host, const char *name );

unsigned long osi_host_determine_db_file_size( const char *host,
                                               const char *name );

unsigned long osi_host_get_db_error_count( const char *host, const char *name );

unsigned long osi_host_get_db_record_count( const char *host,
                                            const char *name );

osi_bool osi_host_database_exists( const char *host, const char *name );


#endif
