# kst-gpl
#
# (C) Michel Arboi
# GPLv2
#

if (description)
{
 script_id(80095);;
 script_version ("$Revision: 1.6 $");
 script_tag(name:"risk_factor", value:"None");
 script_name( "XOT Detection");
 desc = '
Synopsis :

This plugin detects XOT (X.25 over TCP).

Description :

The remote target is an XOT router.
For more information, read RFC 1613 or
http://www.cisco.com/univercd/cc/td/doc/cisintwk/ito_doc/x25.pdf

Risk factor : 

None';
 script_description(desc);
 script_summary( 'Detect XOT by sending an invalid packet');
 script_copyright( 'This script is Copyright (C) 2008 Michel Arboi');
 script_dependencie('find_service1.nasl', 'find_service2.nasl');
 script_category(ACT_GATHER_INFO);
 script_family( "Service detection");
 script_require_ports(1998, "Services/unknown");
 exit(0);
}

# include('dump.inc');
include('misc_func.inc');
include('global_settings.inc');

if ( get_kb_item("global_settings/disable_service_discovery")) exit(0);
port = 1998;

if (! get_port_state(port)) exit(0);

# XOT is not silent: it abruptly closes the connection when it receives
# invalid data
#if (silent_service(port)) exit(0);

# By the way, GET and HELP are definitely invalid. So...
b = get_unknown_banner(port: port, dontfetch: 1);
if (strlen(b) > 0) exit(0);

soc = open_sock_tcp(port);
if (! soc) exit(0);
x25 = '\x20'		# Data for user, local ack, mod-128 seq
      			# LGCN = 0
    + '\0'		# LCN = 0 (reserved => invalid)
    + '\0'		# Data packet
    + '\0\0\0\0';	# Data

# XOT encapsulation (RFC 1613): 
# 2 bytes for version (must be 0) + 2 bytes for length of X25 packet
len = strlen(x25);
xot = raw_string(0, 0, (len >> 8), (len & 0xFF));

send(socket: soc, data: xot + x25);
# t1 = unixtime();
r = recv(socket: soc, length: 512);
# t2 = unixtime();
close(soc);
# dump(dtitle: 'XOT', ddata: r);
lenxot = strlen(r);
if (lenxot < 4) exit(0);
if (r[0] != '\0' || r[1] != '\0') exit(0);
lenx25 = (ord(r[2]) << 8) | ord(r[3]);
if (lenx25 + 4 != lenxot) exit(0);
register_service(port: port, proto: 'xot');
security_note(port);
