##############################################################################
#
#  Total Video Player 'TVP type' Tag Handling Remote BOF Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/12/10
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0541
#
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program. 
##############################################################################
if(description)
{
  script_id(900409);
  script_bugtraq_id(32456);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"8.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Total Video Player 'TVP type' Tag Handling Remote BOF Vulnerability");
  script_summary("Check for vulnerable version of Total Video Player");
  desc = "
  Overview:
  This host is installed with Total Video Player and is prone to remote Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The vulnerability is caused when the application parses a '.au' file containing
  specially crafted 'TVP type' tags containing overly long strings. These can be
  exploited by lack of bound checking in user supplied data before copying it to
  an insufficiently sized memory buffer.

  Impact:
  Successful exploitation will let the attacker execute malicious arbitrary
  codes and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  EffectMatrix Software, Total Video Player version 1.31 and prior on Windows.

  Fix: No solution/patch is available as on 10th December, 2008.

  References:
  http://milw0rm.com/exploits/7219
  http://www.juniper.net/security/auto/vulnerabilities/vuln32456.html

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 7.5
  Risk factor: High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key:key);

foreach entries (keys)
{
  tvpName = registry_get_sz(key:key + entries, item:"DisplayName");
  pattern = "Player ([0]\..*|1\.([0-2]?[0-9]|3[01]))($|[^.0-9])";

  #Grep for version 1.31 or prior
  if("E.M. Total Video Player" >< tvpName &&
     egrep(pattern:pattern, string:tvpName)){
    security_warning(0);
  }
}
