###################################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ortro_detect.nasl 6536 2010-01-12 14:20:22Z jan $
#
# Ortro Version Detection
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(800980);
  script_version("$Revision: 7732 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Ortro Version Detection");
  desc = "
  Overview: This script detects the installed Ortro version and sets
  the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the version of Ortro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

ortroPort = get_http_port(default:80);
if(!ortroPort){
  exit(0);
}

foreach dir (make_list("/", "/ortro", "/ortro/www", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:ortroPort);
  rcvRes = http_keepalive_send_recv(port:ortroPort, data:sndReq, bodyonly:1);
  if("Ortro" >< rcvRes)
  {
    ortroVer = eregmatch(pattern:"v(([0-9.]+).([a-zA-Z0-9]+)?)", string:rcvRes);
    if(ortroVer[1] != NULL)
    {
      ortroVer[1] = ereg_replace(pattern:"-| ", replace:".", string:ortroVer[1]);
      set_kb_item(name:"www/"+ ortroPort + "/Ortro", value:ortroVer[1] +
                  " under " + dir);
      security_note(data:"Ortro version " + ortroVer[1] + " running at location "
                        + dir + " was detected on the host");
    }
  }
}

