###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for pcre CESA-2007:1065-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880321);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "CESA", value: "2007:1065-01");
  script_cve_id("CVE-2006-7228", "CVE-2007-1660");
  script_name( "CentOS Update for pcre CESA-2007:1065-01 centos2 i386");
  desc = "

  Vulnerability Insight:
  PCRE is a Perl-compatible regular expression library.
  
  Flaws were discovered in the way PCRE handles certain malformed regular
  expressions. If an application linked against PCRE parses a malicious
  regular expression, it may have been possible to run arbitrary code as the
  user running the application. (CVE-2006-7228, CVE-2007-1660)
  
  Users of PCRE are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.
  
  Red Hat would like to thank Ludwig Nussel for reporting these issues.


  Affected Software/OS:
  pcre on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-November/014471.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pcre");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS2")
{

  if(isrpmvuln(pkg:"pcre", rpm:"pcre~3.4~2.4", rls:"CentOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pcre-devel", rpm:"pcre-devel~3.4~2.4", rls:"CentOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
