# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1475-1 (gforge)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60268);
 script_cve_id("CVE-2007-0176");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1475-1 (gforge)";
 script_name(name);

 desc = "The remote host is missing an update to gforge
announced via advisory DSA 1475-1.

Jos Ramn Palanco discovered th a cross site scripting vulnerability
in GForge, a collaborative development tool, allows remote attackers to
inject arbitrary web script or HTML in the context of a logged in user's
session.

For the stable distribution (etch), this problem has been fixed in version
4.5.14-22etch5.

The old stable distribution (sarge) is not affected by this problem.

For the unstable distribution (sid) this problem has been fixed in
version 4.6.99+svn6347-1.

We recommend that you upgrade your gforge package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201475-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1475-1 (gforge)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gforge-mta-postfix", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-common", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-exim4", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-web-apache", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-mta-courier", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-db-postgresql", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-lists-mailman", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ftp-proftpd", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-dns-bind9", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-shell-ldap", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-shell-postgresql", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gforge-ldap-openldap", ver:"4.5.14-22etch5", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
