#
# Auto-update manager
#
# Automatically connects and checks for updates to OpenRPG
# Called by main.py during system startup
#
# Author: Todd Faris (Snowdog)
# Date: 5/16/05



from wxPython.wx import *
import orpg_update
import orpg.orpg_version
import orpg.orpg_windows
import traceback



class AutoUpdate:
    def __init__(self):
        pass

    def check(self, parent, settings):
        #if updates off bail out now.
        if int(settings.get_setting("Disableupdate" )):
            print "Updates disabled. Automatic update check skipped."
            return False

        url = settings.get_setting( "PackagesBaseURL" )
        p = None
        updater = None
        try:
            updater = orpg_update.orpg_update(url,self.log_msg)
            p = updater.get_package()
            is_up2date = updater.is_up2date(orpg.orpg_version.VERSION, orpg.orpg_version.BUILD)
            if is_up2date:
                #code up to date. Skip autoupdate
                return False
        except: #error handing update check. Likely no internet connection. skip update check
            print "[WARNING] Automatic update check failed."
            return False

        dmsg = "A newer version is available.\nWould you like to update to "
        dmsg += p.getAttribute("version")+" (build "+p.getAttribute("build")+") now?\n"
        if p.hasAttribute("notes"):
            dmsg += "\nRelease Notes:\n" + p.getAttribute("notes") + "\n"
        dlg = wx.wxMessageDialog(parent,dmsg,"OpenRPG Automatic Update",wxYES_NO)
        if dlg.ShowModal() == wxID_NO:
            dlg.Destroy()
            return False #user abort! bail out.
        else:
            dlg.Destroy()


        dlg2 = orpg.orpg_windows.do_progress_dlg(parent,"OpenRPG Automatic Updater","Please wait while OpenRPG upates...",3)
        dlg2.Update(1,"Please wait while OpenRPG upates...")
        updater.update()
        dlg2.Update(3,"Done.")
        dlg2.Hide()
        dlg2.Destroy()

        dlg3 = wx.wxMessageDialog(parent,"OpenRPG must be restarted to finish updating." ,"OpenRPG Automatic Update",wxOK)
        dlg3.ShowModal()
        dlg3.Destroy()
        return True


    def log_msg(self, msg):
        print msg
