import xmltramp
import orpg.dirpath

class PluginDB:
    def __init__(self, filename="plugindb.xml"):
        self.filename = orpg.dirpath.dir_struct["user"] + filename
        orpg.tools.config_files.validate_config_file(filename,"default_plugindb.xml")
        self.xml_dom = self.LoadDoc()

    def GetString(self, plugname, strname, defaultval, verbose=0):
        for plugin in self.xml_dom:
            if plugname == plugin._name:
                for child in plugin._dir:
                    if child._name == strname:
                        #str() on this to make sure it's ASCII, not unicode, since orpg can't handle unicode.
                        if verbose:
                            print "successfully found the value"
                        if len(child):
                            return str(child[0].replace("$$lt$$", "<").replace("$$gt$$", ">").replace("$$amp$$","&"))
                        else:
                            return ""
        else:
            if verbose:
                print "plugindb: no value has been stored for " + strname + " in " + plugname + " so the default has been returned"
            return defaultval

    def SetString(self, plugname, strname, val):
        val = val.replace("<", "$$lt$$").replace(">", "$$gt$$").replace("&","$$amp$$")
        for plugin in self.xml_dom:##this isn't absolutely necessary, but it saves the trouble of sending a parsed object instead of a simple string.
            if plugname == plugin._name:
                plugin[strname] = val
                plugin[strname]._attrs["type"] = "string"
                self.SaveDoc()
                return "found plugin"
        else:
            self.xml_dom[plugname] = xmltramp.parse("<"+strname+" type=\"string\">"+val+"</"+strname+">")
            self.SaveDoc()
            return "added plugin"

    def GetList(self, plugname, listname, defaultval, verbose=0):
        for plugin in self.xml_dom:
            if plugname == plugin._name:
                for child in plugin._dir:
                    if child._name == listname and child._attrs["type"] == "list":
                        retlist = []
                        for litem in child[0]._dir:
                            if litem._attrs["type"] == "int":
                                retlist += [int(litem[0])]
                            elif litem._attrs["type"] == "long":
                                retlist += [long(litem[0])]
                            elif litem._attrs["type"] == "float":
                                retlist += [float(litem[0])]
                            else:
                                retlist += [str(litem[0].replace("$$lt$$", "<").replace("$$gt$$", ">").replace("$$amp$$","&"))]
                        if verbose:
                            print "successfully found the value"
                        return retlist
        else:
            if verbose:
                print "plugindb: no value has been stored for " + listname + " in " + plugname + " so the default has been returned"
            return defaultval

    def SetList(self, plugname, listname, val):
        listerine = "<list>"
        for item in val:
            if type(item) == type(""):#it's a string
                listerine += "<lobject type=\"str\">"+item.replace("<", "$$lt$$").replace(">", "$$gt$$").replace("&","$$amp$$")+"</lobject>"
            elif type(item) == type(0):#it's an int
                listerine += "<lobject type=\"int\">"+str(item)+"</lobject>"
            elif type(item) == type(0.0):#it's a float
                listerine += "<lobject type=\"float\">"+str(item)+"</lobject>"
            elif type(item) == type(255*255*255*255):#it's a long
                listerine += "<lobject type=\"long\">"+str(item)+"</lobject>"
            else:
                return "type unknown"
        listerine += "</list>"

        list = xmltramp.parse(listerine)
        for plugin in self.xml_dom:
            if plugname == plugin._name:
                plugin[listname] = list
                plugin[listname]._attrs["type"] = "list"
                self.SaveDoc()
                return "found plugin"
        else:
            self.xml_dom[plugname] = xmltramp.parse("<"+listname+"></"+listname+">")
            self.xml_dom[plugname][listname] = list
            self.xml_dom[plugname][listname]._attrs["type"] = "list"
            self.SaveDoc()
            return "added plugin"

    def SetDict(self, plugname, dictname, val, file="plugindb.xml"):
        dictator = "<dict>"
        for item in val.keys():
            if type(val[item]) == type(""):
                dictator += "<dobject name=\""+item+"\" type=\"str\">"+val[item].replace("<", "$$lt$$").replace(">", "$$gt$$").replace("&","$$amp$$")+"</dobject>"
            elif type(val[item]) == type(0):#it's an int
                dictator += "<dobject name=\""+item+"\" type=\"int\">"+str(val[item])+"</dobject>"
            elif type(val[item]) == type(0.1):#it's a float
                dictator += "<dobject name=\""+item+"\" type=\"float\">"+str(val[item])+"</dobject>"
            elif type(val[item]) == type(255*255*255*255):#it's a long
                dictator += "<dobject name=\""+item+"\" type=\"long\">"+str(val[item])+"</dobject>"
            else:
                return str(val[item]) + ": type unknown"
        dictator += "</dict>"

        dict = xmltramp.parse(dictator)
        for plugin in self.xml_dom:
            if plugname == plugin._name:
                plugin[dictname] = dict
                plugin[dictname]._attrs["type"] = "dict"
                self.SaveDoc()
                return "found plugin"
        else:
            self.xml_dom[plugname] = xmltramp.parse("<"+dictname+"></"+dictname+">")
            self.xml_dom[plugname][dictname] = dict
            self.xml_dom[plugname][dictname]._attrs["type"] = "dict"
            self.SaveDoc()
            return "added plugin"

    def GetDict(self, plugname, dictname, defaultval, verbose=0):
        for plugin in self.xml_dom:
            if plugname == plugin._name:
                for child in plugin._dir:
                    if child._name == dictname and child._attrs["type"] == "dict":
                        retdict = {}
                        for ditem in child[0]._dir:
                            if ditem._attrs["type"] == "int":
                                retdict[ditem._attrs["name"]] = int(ditem[0])
                            elif ditem._attrs["type"] == "long":
                                retdict[ditem._attrs["name"]] = long(ditem[0])
                            elif ditem._attrs["type"] == "float":
                                retdict[ditem._attrs["name"]] = float(ditem[0])
                            else:
                                retdict[ditem._attrs["name"]] = str(ditem[0].replace("$$lt$$", "<").replace("$$gt$$", ">").replace("$$amp$$","&"))
                        return retdict
        else:
            if verbose:
                print "plugindb: no value has been stored for " + dictname + " in " + plugname + " so the default has been returned"
            return defaultval

    def SaveDoc(self):
        f = open(self.filename, "w")
        f.write(self.xml_dom.__repr__(1, 1))
        f.close()

    def LoadDoc(self):
        xml_file = open(self.filename)
        plugindb = xml_file.read()
        xml_file.close()
        return xmltramp.parse(plugindb)
