# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/background_handler.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: background_handler.py,v 1.9 2004/05/11 02:31:04 tdb30_ Exp $
#
# Description: Background layer handler
#
__version__ = "$Id: background_handler.py,v 1.9 2004/05/11 02:31:04 tdb30_ Exp $"

from background import *
from base_handler import *

CTRL_BG_TYPE = wxNewId()
CTRL_URL_PATH = wxNewId()
CTRL_BG_COLOR = wxNewId()
CTRL_BG_TEXTURE = wxNewId()
CTRL_BG_IMAGE = wxNewId()
CTRL_BG_COLOR_VALUE = wxNewId()
CTRL_BG_APPLY = wxNewId()

class background_handler(base_layer_handler):
    def __init__(self, parent, id, canvas):
        base_layer_handler.__init__(self, parent, id, canvas)

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)
        #self.bg_type_radio = wxRadioBox(self, CTRL_BG_TYPE, "wxRadioBox", wxDefaultPosition, wxDefaultSize,
        #        ['Color','Texture','Image'], 3, wxRA_SPECIFY_COLS | wxNO_BORDER)
        #self.bg_type_radio = {}
        #self.bg_type_radio[CTRL_BG_COLOR] = wxRadioButton(self, CTRL_BG_COLOR, "Color", style=wxRB_GROUP)
        #self.bg_type_radio[CTRL_BG_TEXTURE] = wxRadioButton(self, CTRL_BG_TEXTURE, "Texture")
        #self.bg_type_radio[CTRL_BG_IMAGE] = wxRadioButton(self, CTRL_BG_IMAGE, "Image")

        self.bg_type = wxChoice(self, CTRL_BG_TYPE, choices = ["None", "Texture", "Image", "Color" ])
        self.url_path = orpgTextCtrl(self, CTRL_URL_PATH,"http://")
        self.color_button = wxButton(self, CTRL_BG_COLOR_VALUE, "Color", style=wxBU_EXACTFIT)
        self.apply_button = wxButton(self, CTRL_BG_APPLY, "Apply", style=wxBU_EXACTFIT)
        self.color_button.SetBackgroundColour(wxBLACK)
        self.color_button.SetForegroundColour(wxWHITE)
        self.sizer.Prepend(wxSize(20,25))
        self.sizer.Prepend(self.apply_button, 0, wxEXPAND)
        self.sizer.Prepend(wxSize(20,25))
        self.sizer.Prepend(self.color_button, 0, wxEXPAND)
        self.sizer.Prepend(self.url_path, 1, wxEXPAND)
        self.sizer.Prepend(self.bg_type, 0, wxEXPAND)

        EVT_BUTTON(self, CTRL_BG_COLOR_VALUE, self.on_bg_color)
        EVT_BUTTON(self, CTRL_BG_APPLY, self.on_apply)
        EVT_CHOICE(self, CTRL_BG_TYPE, self.on_bg_type)
        #EVT_RADIOBUTTON(self, CTRL_BG_COLOR, self.on_bg_type)
        #EVT_RADIOBUTTON(self, CTRL_BG_TEXTURE, self.on_bg_type)
        #EVT_RADIOBUTTON(self, CTRL_BG_IMAGE, self.on_bg_type)
        #EVT_RADIOBOX(self, CTRL_BG_TYPE, self.on_bg_type)
        self.update_info()

    def update_info(self):
        bg_type = self.canvas.layers['bg'].get_type()
        self.bg_type.SetSelection(bg_type)
        #self.bg_type_radio[CTRL_BG_COLOR].SetValue(BG_COLOR==bg_type)
        #self.bg_type_radio[CTRL_BG_TEXTURE].SetValue(BG_TEXTURE==bg_type)
        #self.bg_type_radio[CTRL_BG_IMAGE].SetValue(BG_IMAGE==bg_type)
        self.color_button.Enable(BG_COLOR==bg_type)
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.url_path.Show(false)
        else:
            self.url_path.Show(true)
            self.url_path.Enable(BG_COLOR!=bg_type)
        self.color_button.SetBackgroundColour(self.canvas.layers['bg'].get_color())
        self.url_path.SetValue(self.canvas.layers['bg'].get_img_path())

    def build_menu(self,label = "Background"):
        base_layer_handler.build_menu(self,label)

    def on_bg_color(self,evt):
        data = wxColourData()
        data.SetChooseFull(true)
        dlg = wxColourDialog(self.canvas, data)
        if dlg.ShowModal() == wxID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            self.color_button.SetBackgroundColour(color)
        dlg.Destroy()

    def on_bg_type(self, evt):
        index = self.bg_type.GetSelection()
        self.color_button.Enable((index==BG_COLOR))
        self.url_path.Enable((index!=BG_COLOR))

    def on_apply(self, evt):
        session=self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.use_roles()):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return

        index = self.bg_type.GetSelection()
        if index == 0:
            self.canvas.layers['bg'].clear()
        elif index == 1:
            self.canvas.layers['bg'].set_texture(self.url_path.GetValue())
        elif index == 2:
            self.size = self.canvas.layers['bg'].set_image(self.url_path.GetValue(),1)
        elif index == 3:
            self.canvas.layers['bg'].set_color(self.color_button.GetBackgroundColour())
        self.update_info()
        self.canvas.send_map_data()
        self.canvas.Refresh(false)





