# Copyright (C) 2000-2001 The OpenRPG Project
#
#        openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: chatmacro.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: chatmacro.py,v 1.6 2005/06/05 20:12:34 digitalxero Exp $
#
# Description: The file contains code for the form based nodehanlers
#

__version__ = "$Id: chatmacro.py,v 1.6 2005/06/05 20:12:34 digitalxero Exp $"

from core import *

##########################
## text node handler
##########################
class macro_handler(node_handler):
    """ A nodehandler for text blocks. Will open text in a text frame
        <nodehandler name='?' module='chatmacro' class='macro_handler'>
            <text>some text here</text>
        </nodehandler >
    """
    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)
        self.text_elem = self.master_dom.getElementsByTagName('text')[0]
        self.text = safe_get_text_node(self.text_elem)

    def set_text(self,txt):
        self.text._set_nodeValue(txt)

    def on_use(self,evt):
        txt = self.text._get_nodeValue()
        actionlist = txt.split("\n")
        for line in actionlist:
            if(line != ""):
                if line[0] != "/": ## it's not a slash command
                    action = self.chat.ParsePost(self.chat.colorize(self.chat.mytextcolor, line),true,true)
                else:
                    action = line
                    self.chat.chat_cmds.docmd(action)
        return 1

    def get_design_panel(self,parent):
        return macro_edit_panel(parent,self)

    def tohtml(self):
        title = self.master_dom.getAttribute("name")
        txt = self.text._get_nodeValue()
        txt = string.replace(txt,'\n',"<br>")
        return "<P><b>"+title+":</b><br>"+txt

P_TITLE = wxNewId()
P_BODY = wxNewId()
B_CHAT = wxNewId()

class macro_edit_panel(wxBoxedSizer):
    def __init__(self, parent, handler):
        wxBoxedSizer.__init__(self, parent, "Chat Macro")
        self.handler = handler
        self.text = {   P_TITLE : orpgTextCtrl(self, P_TITLE, handler.master_dom.getAttribute('name')),
                        P_BODY : orpgTextCtrl(self,P_BODY,handler.text._get_nodeValue(),style=wxTE_MULTILINE)
                      }
        #P_BODY : wxTextCtrl(self, P_BODY,handler.text._get_nodeValue(), style=wxTE_MULTILINE)
        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(wxStaticText(self, -1, "Title:"), 0, wxEXPAND)
        sizer.Add(self.text[P_TITLE], 0, wxEXPAND)
        sizer.Add(wxStaticText(self, -1, "Text Body:"), 0, wxEXPAND)
        sizer.Add(self.text[P_BODY], 1, wxEXPAND)
        sizer.Add(wxButton(self, B_CHAT, "Send To Chat"),0,wxEXPAND)
        EVT_SIZE(self, self.on_size)
        EVT_TEXT(self, P_TITLE, self.on_text)
        EVT_TEXT(self, P_BODY, self.on_text)
        EVT_BUTTON(self, B_CHAT, self.handler.on_use)
        self.set_sizer(sizer)
        #EVT_TEXT(self, P_BODY, self.on_text)

    def on_text(self,evt):
        id = evt.GetId()
        txt = self.text[id].GetValue()
        if txt == "":
            return
        if id == P_TITLE:
            self.handler.master_dom.setAttribute('name',txt)
            self.handler.rename(txt)
        elif id == P_BODY:
            self.handler.set_text(txt)


