/**********************************************************************
  FT_NLP.c:

     FT_NLP.c is a subroutine to Fourier transform projectors
     of nonlocal potentials.

  Log of FT_NLP.c:

     15/Sep/2002  Released by T.Ozaki

***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "openmx_common.h"

#ifdef nompi
#include "mimic_mpi.h"
#else
#include "mpi.h"
#endif

void FT_NLP()
{
  int numprocs,myid,ID,tag=999;
  int count,NumSpe;
  int i,kj,num_k,so;
  int Lspe,spe,L,GL,MaxGL;
  double dk,norm_k;
  double rmin,rmax,r,sum[2];
  double sj,sy,sjp,syp,h;
  double **SphB,**SphBp;
  double *tmp_SphB,*tmp_SphBp;
  double TStime, TEtime;
  MPI_Status stat;
  MPI_Request request;

  dtime(&TStime);

  /* MPI */
  MPI_Comm_size(mpi_comm_level1,&numprocs);
  MPI_Comm_rank(mpi_comm_level1,&myid);
 
  if (myid==Host_ID) printf("<FT_NLP>          Fourier transform of non-local projectors\n");

  for (Lspe=0; Lspe<MSpeciesNum; Lspe++){

    spe = Species_Top[myid] + Lspe;

    num_k = Ngrid_NormK;
    dk = PAO_Nkmax/(double)num_k;

    /* allocate SphB and SphBp */

    MaxGL = -1;
    for (L=1; L<=Spe_Num_RVPS[spe]; L++){
      GL = Spe_VPS_List[spe][L];
      if (MaxGL<GL) MaxGL = GL;
    }      

    SphB = (double**)malloc(sizeof(double*)*(MaxGL+3));
    for(GL=0; GL<(MaxGL+3); GL++){ 
      SphB[GL] = (double*)malloc(sizeof(double)*(OneD_Grid+1));
    }

    SphBp = (double**)malloc(sizeof(double*)*(MaxGL+3));
    for(GL=0; GL<(MaxGL+3); GL++){ 
      SphBp[GL] = (double*)malloc(sizeof(double)*(OneD_Grid+1));
    }

    tmp_SphB  = (double*)malloc(sizeof(double)*(MaxGL+3));
    tmp_SphBp = (double*)malloc(sizeof(double)*(MaxGL+3));

    /* kj loop */

    for (kj=0; kj<num_k; kj++){

      norm_k = (double)kj*dk;

      /* calculate SphB */

      rmin = Spe_VPS_RV[spe][0];
      rmax = Spe_Atom_Cut1[spe] + 0.5;
      h = (rmax - rmin)/(double)OneD_Grid;

      for (i=0; i<=OneD_Grid; i++){
        r = rmin + (double)i*h;

	Spherical_Bessel(norm_k*r,MaxGL,tmp_SphB,tmp_SphBp);

	for(GL=0; GL<=MaxGL; GL++){ 
	  SphB[GL][i]  =  tmp_SphB[GL]; 
	  SphBp[GL][i] = tmp_SphBp[GL]; 
	}
      }

      /* loof for L */

      for (L=1; L<=Spe_Num_RVPS[spe]; L++){

	GL = Spe_VPS_List[spe][L];

	/****************************************************
                      \int jL(k*r)*RL*r^2 dr 
	****************************************************/

	sum[0] = 0.0;
	sum[1] = 0.0;

	h = (rmax - rmin)/(double)OneD_Grid;
	for (i=0; i<=OneD_Grid; i++){
	  r = rmin + (double)i*h;
          sj = SphB[GL][i];

          for (so=0; so<=VPS_j_dependency[spe]; so++){
  	    if (i==0 || i==OneD_Grid)
	      sum[so] += 0.5*r*r*Nonlocal_RadialF(spe,L-1,so,r)*sj;
	    else
	      sum[so] += r*r*Nonlocal_RadialF(spe,L-1,so,r)*sj;
	  }
	}

        for (so=0; so<=VPS_j_dependency[spe]; so++){
	  Spe_NLRF_Bessel[so][spe][L][kj] = sum[so]*h;
	}

	NormK[kj] = norm_k;

      } /* L */
    } /* kj */

    /* free arrays */

    for(GL=0; GL<(MaxGL+3); GL++){ 
      free(SphB[GL]);
    }
    free(SphB);

    for(GL=0; GL<(MaxGL+3); GL++){ 
      free(SphBp[GL]);
    }
    free(SphBp);

    free(tmp_SphB);
    free(tmp_SphBp);

  } /* Lspe */

  /****************************************************
     Remedy for MSpeciesNum==0
     generate radial grids in the k-space
  ****************************************************/

  dk = PAO_Nkmax/(double)Ngrid_NormK;
  for (i=0; i<Ngrid_NormK; i++){
    NormK[i] = (double)i*dk;
  }

  /***********************************************************
        sending and receiving of Spe_RF_Bessel by MPI
  ***********************************************************/


  for (ID=0; ID<Num_Procs2; ID++){
    NumSpe = Species_End[ID] - Species_Top[ID] + 1;
    for (Lspe=0; Lspe<NumSpe; Lspe++){
      spe = Species_Top[ID] + Lspe;
      for (so=0; so<=VPS_j_dependency[spe]; so++){
	for (L=1; L<=Spe_Num_RVPS[spe]; L++){
	  MPI_Bcast(&Spe_NLRF_Bessel[so][spe][L][0],
		    List_YOUSO[15],MPI_DOUBLE,ID,mpi_comm_level1);
	}
      }
    }
  }

  /***********************************************************
                         elapsed time
  ***********************************************************/

  dtime(&TEtime);
}
