/*
 * Copyright 2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/* @test
   @summary Test SoftSynthesizer implicit open/close using getReceiver. */

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.*;
import javax.sound.midi.MidiDevice.Info;

import com.sun.media.sound.*;

public class ImplicitOpenClose {
			
	public static void main(String[] args) throws Exception {
		Synthesizer synth = new SoftSynthesizer();
				
		ReferenceCountingDevice rcd = (ReferenceCountingDevice)synth;		
					
		// Test single open/close cycle
		
		Receiver recv = rcd.getReceiverReferenceCounting();
		if(!synth.isOpen())
			throw new Exception("Synthesizer not open!");
		recv.close();
		if(synth.isOpen())
			throw new Exception("Synthesizer not closed!");

		// Test using 2 receiver cycle
		
		Receiver recv1 = rcd.getReceiverReferenceCounting();
		if(!synth.isOpen())
			throw new Exception("Synthesizer not open!");		
		Receiver recv2 = rcd.getReceiverReferenceCounting();
		if(!synth.isOpen())
			throw new Exception("Synthesizer not open!");

		recv2.close();
		if(!synth.isOpen())
			throw new Exception("Synthesizer was closed!");
		recv1.close();
		if(synth.isOpen())
			throw new Exception("Synthesizer not closed!");
		
		// Test for explicit,implicit conflict 
		
		synth.open();
		Receiver recv3 = rcd.getReceiverReferenceCounting();
		if(!synth.isOpen())
			throw new Exception("Synthesizer not open!");
		recv3.close();
		if(!synth.isOpen())
			throw new Exception("Synthesizer was closed!");
		synth.close();
		if(synth.isOpen())
			throw new Exception("Synthesizer not closed!");

		// Test for implicit,explicit conflict 
		
		recv3 = rcd.getReceiverReferenceCounting();
		synth.open();
		if(!synth.isOpen())
			throw new Exception("Synthesizer not open!");
		recv3.close();
		if(!synth.isOpen())
			throw new Exception("Synthesizer was closed!");
		synth.close();
		if(synth.isOpen())
			throw new Exception("Synthesizer not closed!");
		
	}
}
