// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _FairCurve_MinimalVariation_HeaderFile
#define _FairCurve_MinimalVariation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _FairCurve_Batten_HeaderFile
#include <FairCurve_Batten.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _FairCurve_AnalysisCode_HeaderFile
#include <FairCurve_AnalysisCode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_NegativeValue;
class Standard_NullValue;
class Standard_DomainError;
class gp_Pnt2d;
class gp_Vec2d;


//! Computes a 2D curve using an algorithm which <br>
//! minimizes tension, sagging, and jerk energy. As in <br>
//! FairCurve_Batten, two reference points are used. <br>
//! Unlike that class, FairCurve_MinimalVariation <br>
//! requires curvature settings at the first and second <br>
//! reference points. These are defined by the rays of <br>
//! curvature desired at each point. <br>
class FairCurve_MinimalVariation  : public FairCurve_Batten {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Constructs the two contact points P1 and P2  and the geometrical <br>
//!          characteristics of the batten (elastic beam) <br>
//!   These include the real number values for height of <br>
//! deformation Height, slope value Slope, and kind of <br>
//! energy PhysicalRatio. The kinds of energy include: <br>
//! -   Jerk (0) <br>
//! -   Sagging (1). <br>
//! Note that the default setting for Physical Ration is in FairCurve_Batten <br>
//!          Other parameters are initialized as follow : <br>
//!           - FreeSliding = False <br>
//!           - ConstraintOrder1 = 1 <br>
//!           - ConstraintOrder2 = 1 <br>
//!           - Angle1 = 0 <br>
//!           - Angle2 = 0 <br>
//!           - Curvature1 = 0 <br>
//!           - Curvature2 = 0 <br>
//!           - SlidingFactor = 1 <br>
//! Warning <br>
//! If PhysicalRatio equals 1, you cannot impose constraints on curvature. <br>
//! Exceptions <br>
//! NegativeValue if Height is less than or equal to 0. <br>
//! NullValue if the distance between P1 and P2 is less <br>
//! than or equal to the tolerance value for distance in <br>
//! Precision::Confusion: P1.IsEqual(P2, <br>
//! Precision::Confusion()). The function <br>
//! gp_Pnt2d::IsEqual tests to see if this is the case. <br>//!  Definition of the geometricals constraints <br>
  Standard_EXPORT   FairCurve_MinimalVariation(const gp_Pnt2d& P1,const gp_Pnt2d& P2,const Standard_Real Heigth,const Standard_Real Slope = 0,const Standard_Real PhysicalRatio = 0);
  //! Allows you to set a new constraint on curvature at the first point. <br>
        void SetCurvature1(const Standard_Real Curvature) ;
  //! Allows you to set a new constraint on curvature at the second point. <br>
//! <br>
        void SetCurvature2(const Standard_Real Curvature) ;
  //!  Allows you to set the physical ratio Ratio. <br>
//! The kinds of energy which you can specify include: <br>
//!          0 is only "Jerk" Energy <br>
//!          1 is only "Sagging" Energy like batten <br>
//!  Warning: if Ratio is 1 it is impossible to impose curvature constraints. <br>
//!  Raises  DomainError if Ratio < 0 or Ratio > 1 <br>
        void SetPhysicalRatio(const Standard_Real Ratio) ;
  //! Computes the curve with respect to the constraints, <br>
//! NbIterations and Tolerance. The tolerance setting <br>
//! allows you to control the precision of computation, and <br>
//! the maximum number of iterations allows you to set a limit on computation time. <br>
  Standard_EXPORT   virtual  Standard_Boolean Compute(FairCurve_AnalysisCode& ACode,const Standard_Integer NbIterations = 50,const Standard_Real Tolerance = 1.0e-3) ;
  //! Returns the first established curvature. <br>
        Standard_Real GetCurvature1() const;
  //! Returns the second established curvature. <br>
        Standard_Real GetCurvature2() const;
  //! Returns the physical ratio, or kind of energy. <br>
        Standard_Real GetPhysicalRatio() const;
  //! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
  Standard_EXPORT   virtual  void Dump(Standard_OStream& o) const;





protected:





private:

  //! compute the curve with respect of the delta-constraints. <br>
  Standard_EXPORT     Standard_Boolean Compute(const gp_Vec2d& DeltaP1,const gp_Vec2d& DeltaP2,const Standard_Real DeltaAngle1,const Standard_Real DeltaAngle2,const Standard_Real DeltaCurvature1,const Standard_Real DeltaCurvature2,FairCurve_AnalysisCode& ACode,const Standard_Integer NbIterations,const Standard_Real Tolerance) ;


Standard_Real OldCurvature1;
Standard_Real OldCurvature2;
Standard_Real OldPhysicalRatio;
Standard_Real NewCurvature1;
Standard_Real NewCurvature2;
Standard_Real NewPhysicalRatio;


};


#include <FairCurve_MinimalVariation.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
