// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepExtrema_DistanceSS_HeaderFile
#define _BRepExtrema_DistanceSS_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BRepExtrema_SeqOfSolution_HeaderFile
#include <BRepExtrema_SeqOfSolution.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;
class Bnd_Box;
class TopoDS_Vertex;
class TopoDS_Edge;
class TopoDS_Face;
class BRepExtrema_SeqOfSolution;


//!  This class allows to compute minimum distance between two shapes <br>
//! (face edge vertex) and is used in DistShapeShape class. <br>
class BRepExtrema_DistanceSS  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! computes the distance between two Shapes <br>
//! ( face edge vertex) <br>
  Standard_EXPORT   BRepExtrema_DistanceSS(const TopoDS_Shape& S1,const TopoDS_Shape& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef);
  //! computes the distance between two Shapes <br>
//! ( face edge vertex). Parameter theDeflection is used <br>
//! to specify a maximum deviation of extreme distances <br>
//! from the minimum one. <br>
//! Default value is Precision::Confusion(). <br>
  Standard_EXPORT   BRepExtrema_DistanceSS(const TopoDS_Shape& S1,const TopoDS_Shape& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef,const Standard_Real aDeflection);
  //! True if the distance has been computed <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! returns the distance value <br>
  Standard_EXPORT     Standard_Real DistValue() const;
  //! returns the list of solutions on the first shape <br>
  Standard_EXPORT    const BRepExtrema_SeqOfSolution& Seq1Value() const;
  //!---Purpose returns the list of solutions on the second shape <br>
  Standard_EXPORT    const BRepExtrema_SeqOfSolution& Seq2Value() const;





protected:





private:

  //! computes the distance between two Shapes <br>
//! ( face edge vertex) <br>
  Standard_EXPORT     void Perform(const TopoDS_Shape& S1,const TopoDS_Shape& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!   computes the distance between two vertices <br>
  Standard_EXPORT     void Perform(const TopoDS_Vertex& S1,const TopoDS_Vertex& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //! computes the minimum distance between a vertex and an edge <br>
  Standard_EXPORT     void Perform(const TopoDS_Vertex& S1,const TopoDS_Edge& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!computes the minimum distance between a vertex and a face <br>
  Standard_EXPORT     void Perform(const TopoDS_Vertex& S1,const TopoDS_Face& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //! computes the minimum distance between an edge and a vertex <br>
  Standard_EXPORT     void Perform(const TopoDS_Edge& S1,const TopoDS_Vertex& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  
  Standard_EXPORT     void Perform(const TopoDS_Edge& S1,const TopoDS_Edge& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!computes the minimum distance an edge and a face <br>
  Standard_EXPORT     void Perform(const TopoDS_Edge& S1,const TopoDS_Face& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!computes the minimum distance betwwen a face and a vertex <br>
  Standard_EXPORT     void Perform(const TopoDS_Face& S1,const TopoDS_Vertex& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!computes the minimum distance between a face and an edge <br>
  Standard_EXPORT     void Perform(const TopoDS_Face& S1,const TopoDS_Edge& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;
  //!computes the minimum distance between a face and a face <br>
  Standard_EXPORT     void Perform(const TopoDS_Face& S1,const TopoDS_Face& S2,const Bnd_Box& B1,const Bnd_Box& B2,const Standard_Real DstRef) ;


BRepExtrema_SeqOfSolution SeqSolShape1;
BRepExtrema_SeqOfSolution SeqSolShape2;
Standard_Real myDstRef;
Standard_Boolean myModif;
Standard_Real myEps;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
