// TopologyBuildingDoc.cpp : implementation of the CTopologyBuildingDoc class
//

#include "stdafx.h"

#include "TopologyBuildingDoc.h"

#include "TopologyBuildingApp.h"
#include "ResultDialog.h"

#include "AIS_ConnectedInteractive.hxx"
#include "Geom_Transformation.hxx"
#include "..\res\resource.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CTopologyBuildingDoc

IMPLEMENT_DYNCREATE(CTopologyBuildingDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyBuildingDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyBuildingDoc)
	ON_COMMAND(ID_VERTEX, OnVertex)
	ON_COMMAND(ID_EDGE, OnEdge)
	ON_COMMAND(ID_WIRE, OnWire)
	ON_COMMAND(ID_FACE, OnFace)
	ON_COMMAND(ID_SHELL, OnShell)
	ON_COMMAND(ID_COMPOUND, OnCompound)
	ON_COMMAND(ID_GEOMETRIE, OnGeometrie)
	ON_COMMAND(ID_SEWING, OnSewing)
	ON_COMMAND(ID_EXPLORER, OnExplorer)
	ON_COMMAND(ID_BUILDER, OnBuilder)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyBuildingDoc construction/destruction

CTopologyBuildingDoc::CTopologyBuildingDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyBuildingDoc::~CTopologyBuildingDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyBuildingDoc diagnostics

#ifdef _DEBUG
void CTopologyBuildingDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyBuildingDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CTopologyBuildingDoc::OnVertex() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Vertex V1,V2,V3;
	
	V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(0,0,0));
	V2 = BRepBuilderAPI_MakeVertex(gp_Pnt(10,7,25));
	
	gp_Pnt P(-12,8,-4);
	BRepBuilderAPI_MakeVertex MV(P);
	V3 = MV.Vertex();

	Handle(AIS_Shape) Point1 = new AIS_Shape(V1);
	myAISContext->Display(Point1,Standard_False);
	Handle(AIS_Shape) Point2 = new AIS_Shape(V2);
	myAISContext->Display(Point2,Standard_False);
	Handle(AIS_Shape) Point3 = new AIS_Shape(V3);
	myAISContext->Display(Point3,Standard_False);

	Fit();

   TCollection_AsciiString Message ("\
		\n\
TopoDS_Vertex V1,V2,V3;	\n\
		\n\
V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(0,0,0));	\n\
	\n\
V2 = BRepBuilderAPI_MakeVertex(gp_Pnt(10,7,25));	\n\
		\n\
gp_Pnt P(-12,8,-4);	\n\
BRepBuilderAPI_MakeVertex MV(P);	\n\
V3 = MV.Vertex();	\n\
	\n\
\n");

	PocessTextInDialog("Make vertex from point ", Message);

}

void CTopologyBuildingDoc::OnEdge() 
{
	
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	
	
	TopoDS_Edge BlueEdge,YellowEdge,WhiteEdge,RedEdge,GreenEdge;
	TopoDS_Vertex V1,V2,V3,V4;
	
/////////////The blue edge

	BlueEdge = BRepBuilderAPI_MakeEdge(gp_Pnt(-80,-50,-20),gp_Pnt(-30,-60,-60));

/////////////The yellow edge
	
	V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-20,10,-30));
	V2 = BRepBuilderAPI_MakeVertex(gp_Pnt(10,7,-25));
	YellowEdge = BRepBuilderAPI_MakeEdge(V1,V2);

/////////////The white edge
	
	gp_Lin line(gp_Ax1(gp_Pnt(10,10,10),gp_Dir(1,0,0)));
	WhiteEdge = BRepBuilderAPI_MakeEdge(line,-20,10);

//////////////The red edge

	gp_Elips Elips(gp_Ax2(gp_Pnt(10,0,0),gp_Dir(1,1,1)),60,30);
	RedEdge = BRepBuilderAPI_MakeEdge(Elips,0,PI/2);

/////////////The green edge and the both extreme vertex

	gp_Pnt P1(-15,200,10);
	gp_Pnt P2(5,204,0);
	gp_Pnt P3(15,200,0);
	gp_Pnt P4(-15,20,15);
	gp_Pnt P5(-5,20,0);
	gp_Pnt P6(15,20,0);
	gp_Pnt P7(24,120,0);
	gp_Pnt P8(-24,120,12.5);
	TColgp_Array1OfPnt array(1,8);
	array.SetValue(1,P1);
	array.SetValue(2,P2);
	array.SetValue(3,P3); 
	array.SetValue(4,P4); 
	array.SetValue(5,P5); 
	array.SetValue(6,P6); 
	array.SetValue(7,P7); 
	array.SetValue(8,P8); 
	Handle (Geom_BezierCurve) curve = new Geom_BezierCurve(array);
	
	BRepBuilderAPI_MakeEdge ME (curve);
	GreenEdge = ME;
	V3 = ME.Vertex1();
	V4 = ME.Vertex2();

//////////////Display
Handle(AIS_Shape) blue = new AIS_Shape(BlueEdge);
myAISContext->SetColor(blue,Quantity_NOC_MATRABLUE,Standard_False); 
myAISContext->Display(blue,Standard_False);

Handle(AIS_Shape) yellow = new AIS_Shape(YellowEdge);
myAISContext->SetColor(yellow,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->Display(yellow,Standard_False);

Handle(AIS_Shape) white = new AIS_Shape(WhiteEdge);
myAISContext->SetColor(white,Quantity_NOC_WHITE,Standard_False); 
myAISContext->Display(white,Standard_False);

Handle(AIS_Shape) red = new AIS_Shape(RedEdge);
myAISContext->SetColor(red,Quantity_NOC_RED,Standard_False); 
myAISContext->Display(red,Standard_False);

Handle(AIS_Shape) green = new AIS_Shape(GreenEdge);
myAISContext->SetColor(green,Quantity_NOC_GREEN,Standard_False); 
myAISContext->Display(green,Standard_False);

Handle(AIS_Shape) Point1 = new AIS_Shape(V3);
myAISContext->Display(Point1,Standard_False);
Handle(AIS_Shape) Point2 = new AIS_Shape(V4);
myAISContext->Display(Point2,Standard_False);

Fit();

   TCollection_AsciiString Message ("\
		\n\
TopoDS_Edge BlueEdge, YellowEdge, WhiteEdge, RedEdge, GreenEdge;	\n\
TopoDS_Vertex V1,V2,V3,V4;	\n\
		\n\
/////////////The blue edge	\n\
	\n\
BlueEdge = BRepBuilderAPI_MakeEdge(gp_Pnt(-80,-50,-20),gp_Pnt(-30,-60,-60));	\n\
	\n\
/////////////The yellow edge	\n\
		\n\
V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-20,10,-30));	\n\
V2 = BRepBuilderAPI_MakeVertex(gp_Pnt(10,7,-25));	\n\
YellowEdge = BRepBuilderAPI_MakeEdge(V1,V2);	\n\
	\n\
/////////////The white edge	\n\
		\n\
gp_Lin line(gp_Ax1(gp_Pnt(10,10,10),gp_Dir(1,0,0)));	\n\
WhiteEdge = BRepBuilderAPI_MakeEdge(line,-20,10);	\n\
	\n\
//////////////The red edge	\n\
	\n\
gp_Elips Elips(gp_Ax2(gp_Pnt(10,0,0),gp_Dir(1,1,1)),60,30);	\n\
RedEdge = BRepBuilderAPI_MakeEdge(Elips,0,PI/2);	\n\
	\n\
/////////////The green edge and the both extreme vertex	\n\
	\n\
gp_Pnt P1(-15,200,10);	\n\
gp_Pnt P2(5,204,0);	\n\
gp_Pnt P3(15,200,0);	\n\
gp_Pnt P4(-15,20,15);	\n\
gp_Pnt P5(-5,20,0);	\n\
gp_Pnt P6(15,20,0);	\n\
gp_Pnt P7(24,120,0);	\n\
gp_Pnt P8(-24,120,12.5);	\n\
TColgp_Array1OfPnt array(1,8);	\n\
array.SetValue(1,P1);	\n\
array.SetValue(2,P2);	\n\
array.SetValue(3,P3); 	\n\
array.SetValue(4,P4); 	\n\
array.SetValue(5,P5); 	\n\
array.SetValue(6,P6); 	\n\
array.SetValue(7,P7); 	\n\
array.SetValue(8,P8); 	\n\
Handle (Geom_BezierCurve) curve = new Geom_BezierCurve(array);	\n\
	\n\
BRepBuilderAPI_MakeEdge ME (curve);	\n\
GreenEdge = ME;	\n\
V3 = ME.Vertex1();	\n\
V4 = ME.Vertex2();	\n\
	\n\
\n");

	PocessTextInDialog("Make edge", Message);
	
}

void CTopologyBuildingDoc::OnWire() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Wire RedWire,YellowWire,WhiteWire,
		ExistingWire, ExistingWire2;

	TopoDS_Edge Edge1,Edge2,Edge3,Edge4,Edge5,Edge6,Edge7,LastEdge;
	TopoDS_Vertex LastVertex;

////////////The red wire is build from a single edge

	gp_Elips Elips(gp_Ax2(gp_Pnt(250,0,0),gp_Dir(1,1,1)),160,90);
	Edge1 = BRepBuilderAPI_MakeEdge(Elips,0,PI/2);

	RedWire = BRepBuilderAPI_MakeWire(Edge1);

///////////the yellow wire is build from an existing wire and an edge
	
	gp_Circ circle(gp_Ax2(gp_Pnt(-300,0,0),gp_Dir(1,0,0)),80);
	Edge2 = BRepBuilderAPI_MakeEdge(circle,0,PI);

	ExistingWire = BRepBuilderAPI_MakeWire(Edge2);

	Edge3 = BRepBuilderAPI_MakeEdge(gp_Pnt(-300,0,-80),gp_Pnt(-90,20,-30));

	BRepBuilderAPI_MakeWire MW1(ExistingWire,Edge3);
	if (MW1.IsDone()) {
			YellowWire = MW1;
	}


//////////the white wire is built with an existing wire and 3 edges.
//////////we use the methods Add, Edge and Vertex from BRepBuilderAPI_MakeWire.

	gp_Circ circle2(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(0,1,0)),200);
	Edge4 = BRepBuilderAPI_MakeEdge(circle2,0,PI);

	ExistingWire2 = BRepBuilderAPI_MakeWire(Edge4);

	gp_Pnt P1(0,0,-200);
	gp_Pnt P2(5,204,0);
	Edge5 = BRepBuilderAPI_MakeEdge(P1,P2);

	gp_Pnt P3(-15,20,15);
	Edge6 = BRepBuilderAPI_MakeEdge(P2,P3);
	gp_Pnt P4(15,20,0);	
	Edge7 = BRepBuilderAPI_MakeEdge(P3,P4);

	BRepBuilderAPI_MakeWire MW;
	MW.Add(ExistingWire2);
	MW.Add(Edge5);
	MW.Add(Edge6);
	MW.Add(Edge7);

	if (MW.IsDone()) {
		WhiteWire = MW.Wire();
		LastEdge = MW.Edge();
		LastVertex = MW.Vertex();
	}


Handle(AIS_Shape) red = new AIS_Shape(RedWire);
myAISContext->SetColor(red,Quantity_NOC_RED,Standard_False); 
myAISContext->Display(red,Standard_False);

Handle(AIS_Shape) yellow = new AIS_Shape(YellowWire);
myAISContext->SetColor(yellow,Quantity_NOC_YELLOW,Standard_False); 
myAISContext->Display(yellow,Standard_False);

Handle(AIS_Shape) white = new AIS_Shape(WhiteWire);
myAISContext->SetColor(white,Quantity_NOC_WHITE,Standard_False); 
myAISContext->Display(white,Standard_False);

Handle(AIS_Shape) lastE = new AIS_Shape(LastEdge);
myAISContext->SetWidth(lastE,3,Standard_False);
myAISContext->SetColor(lastE,Quantity_NOC_RED,Standard_False); 
myAISContext->Display(lastE,Standard_False);

Handle(AIS_Shape) lastV = new AIS_Shape(LastVertex);
myAISContext->Display(lastV,Standard_False);

Fit();

   TCollection_AsciiString Message ("\
	\n\
TopoDS_Wire RedWire,YellowWire,WhiteWire,	\n\
ExistingWire, ExistingWire2;	\n\
	\n\
TopoDS_Edge Edge1,Edge2,Edge3,Edge4,Edge5,Edge6,Edge7,LastEdge;	\n\
TopoDS_Vertex LastVertex;	\n\
	\n\
////////////The red wire is build from a single edge	\n\
	\n\
gp_Elips Elips(gp_Ax2(gp_Pnt(10,0,0),gp_Dir(1,1,1)),160,90);	\n\
Edge1 = BRepBuilderAPI_MakeEdge(Elips,0,PI/2);	\n\
	\n\
RedWire = BRepBuilderAPI_MakeWire(Edge1);	\n\
	\n\
///////////the yellow wire is build from an existing wire and an edge	\n\
		\n\
gp_Circ circle(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(1,0,0)),80);	\n\
Edge2 = BRepBuilderAPI_MakeEdge(circle,0,PI);	\n\
	\n\
ExistingWire = BRepBuilderAPI_MakeWire(Edge2);	\n\
	\n\
Edge3 = BRepBuilderAPI_MakeEdge(gp_Pnt(0,0,-80),gp_Pnt(90,20,30));	\n\
	\n\
BRepBuilderAPI_MakeWire MW1(ExistingWire,Edge3);	\n\
if (MW1.IsDone()) {	\n\
		YellowWire = MW1;	\n\
}	\n\
	\n\
///the white wire is built with an existing wire and 3 edges.	\n\
///we use the methods Add, Edge and Vertex from BRepBuilderAPI_MakeWire	\n\
///in order to display the last edge and the last vertices we	\n\
///add to the wire. 	\n\
	\n\
gp_Circ circle2(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(0,1,0)),200);	\n\
Edge4 = BRepBuilderAPI_MakeEdge(circle2,0,PI);	\n\
	\n\
ExistingWire2 = BRepBuilderAPI_MakeWire(Edge4);	\n\
	\n\
gp_Pnt P1(0,0,-200);	\n\
gp_Pnt P2(5,204,0);	\n\
Edge5 = BRepBuilderAPI_MakeEdge(P1,P2);	\n\
	\n\
gp_Pnt P3(-15,20,15);	\n\
Edge6 = BRepBuilderAPI_MakeEdge(P2,P3);	\n\
gp_Pnt P4(15,20,0);		\n\
Edge7 = BRepBuilderAPI_MakeEdge(P3,P4);	\n\
	\n\
BRepBuilderAPI_MakeWire MW;	\n\
MW.Add(ExistingWire2);	\n\
MW.Add(Edge5);	\n\
MW.Add(Edge6);	\n\
MW.Add(Edge7);	\n\
	\n\
if (MW.IsDone()) {	\n\
	WhiteWire = MW.Wire();	\n\
	LastEdge = MW.Edge();	\n\
	LastVertex = MW.Vertex();	\n\
}	\n\
	\n\
\n");

	PocessTextInDialog("Make wire ", Message);
}

void CTopologyBuildingDoc::OnFace() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}



	TopoDS_Face WhiteFace, BrownFace, RedFace, PinkFace;
	TopoDS_Edge Edge1, Edge2, Edge3, Edge4, Edge5, Edge6, Edge7;
	TopoDS_Wire Wire1;
	gp_Pnt P1, P2, P3, P4, P5, P6, P7;

	gp_Sphere sphere (gp_Ax3(gp_Pnt(0,0,0),gp_Dir(1,0,0)),150);

	WhiteFace = BRepBuilderAPI_MakeFace(sphere,0.1,0.7,0.2,0.9);

//////////////////////////////////

	P1.SetCoord(-15,200,10);
	P2.SetCoord(5,204,0);
	P3.SetCoord(15,200,0);
	P4.SetCoord(-15,20,15);
	P5.SetCoord(-5,20,0);
	P6.SetCoord(15,20,35);
	TColgp_Array2OfPnt array(1,3,1,2);
	array.SetValue(1,1,P1);
	array.SetValue(2,1,P2);
	array.SetValue(3,1,P3); 
	array.SetValue(1,2,P4); 
	array.SetValue(2,2,P5); 
	array.SetValue(3,2,P6);
	Handle (Geom_BSplineSurface) curve = GeomAPI_PointsToBSplineSurface(array,3,8,GeomAbs_C2,0.001);

	RedFace = BRepBuilderAPI_MakeFace(curve);

////////////////////

	gp_Circ circle(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(1,0,0)),80);
	Edge1 = BRepBuilderAPI_MakeEdge(circle,0,PI);

	Edge2 = BRepBuilderAPI_MakeEdge(gp_Pnt(0,0,-80),gp_Pnt(0,-10,40));
	Edge3 = BRepBuilderAPI_MakeEdge(gp_Pnt(0,-10,40),gp_Pnt(0,0,80));

	TopoDS_Wire YellowWire;
	BRepBuilderAPI_MakeWire MW1(Edge1,Edge2,Edge3);
	if (MW1.IsDone()) {
			YellowWire = MW1;
	}

	BrownFace = BRepBuilderAPI_MakeFace(YellowWire);


/////////////

	P1.SetCoord(35,-200,40);
	P2.SetCoord(50,-204,30);
	P3.SetCoord(65,-200,30);
	P4.SetCoord(35,-20,45);
	P5.SetCoord(45,-20,30);
	P6.SetCoord(65,-20,65);
	TColgp_Array2OfPnt array2(1,3,1,2);
	array2.SetValue(1,1,P1);
	array2.SetValue(2,1,P2);
	array2.SetValue(3,1,P3); 
	array2.SetValue(1,2,P4); 
	array2.SetValue(2,2,P5); 
	array2.SetValue(3,2,P6);
	
	Handle (Geom_BSplineSurface) BSplineSurf = GeomAPI_PointsToBSplineSurface(array2,3,8,GeomAbs_C2,0.001);
	
	TopoDS_Face aFace = BRepBuilderAPI_MakeFace(BSplineSurf);

	//2d lines
	gp_Pnt2d P12d(0.9,0.1);
	gp_Pnt2d P22d(0.2,0.7);
	gp_Pnt2d P32d(0.02,0.1);

	Handle (Geom2d_Line) line1 = new Geom2d_Line(P12d,gp_Dir2d((0.2-0.9),(0.7-0.1)));
	Handle (Geom2d_Line) line2 = new Geom2d_Line(P22d,gp_Dir2d((0.02-0.2),(0.1-0.7)));
	Handle (Geom2d_Line) line3 = new Geom2d_Line(P32d,gp_Dir2d((0.9-0.02),(0.1-0.1)));


	//Edges are on the BSpline surface
	Edge1 = BRepBuilderAPI_MakeEdge(line1,BSplineSurf,0,P12d.Distance(P22d));
	Edge2 = BRepBuilderAPI_MakeEdge(line2,BSplineSurf,0,P22d.Distance(P32d));
	Edge3 = BRepBuilderAPI_MakeEdge(line3,BSplineSurf,0,P32d.Distance(P12d));

	Wire1 = BRepBuilderAPI_MakeWire(Edge1,Edge2,Edge3);
	Wire1.Reverse();
	PinkFace = BRepBuilderAPI_MakeFace(aFace,Wire1);
	BRepLib::BuildCurves3d(PinkFace);

	BRepTools::Write(PinkFace,"E:\\temp\\PinkFace.rle");


/////////////Display
	Handle(AIS_Shape) white = new AIS_Shape(WhiteFace);
	myAISContext->SetColor(white,Quantity_NOC_WHITE,Standard_False);
	myAISContext->SetMaterial(white,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(white,Standard_False);
	
	Handle(AIS_Shape) red = new AIS_Shape(RedFace);
	myAISContext->SetColor(red,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(red,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(red,Standard_False);
	
	Handle(AIS_Shape) brown = new AIS_Shape(BrownFace);
	myAISContext->SetColor(brown,Quantity_NOC_BROWN,Standard_False);
	myAISContext->SetMaterial(brown,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(brown,Standard_False);
	
	Handle(AIS_Shape) pink = new AIS_Shape(PinkFace);
	myAISContext->SetColor(pink,Quantity_NOC_HOTPINK,Standard_False);
	myAISContext->SetMaterial(pink,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(pink,Standard_False);

	Fit();


  TCollection_AsciiString Message ("\
 	\n\
TopoDS_Face WhiteFace, BrownFace, RedFace, PinkFace;	\n\
TopoDS_Edge Edge1, Edge2, Edge3, Edge4, Edge5, Edge6, Edge7;	\n\
TopoDS_Wire Wire1;	\n\
gp_Pnt P1, P2, P3, P4, P5, P6, P7;	\n\
\n\
////////The white Face \n\
\n\
gp_Sphere sphere (gp_Ax3(gp_Pnt(0,0,0),gp_Dir(1,0,0)),150);	\n\
\n\
WhiteFace = BRepBuilderAPI_MakeFace(sphere,0.1,0.7,0.2,0.9);	\n\
\n\
////////The red face	\n\
\n\
P1.SetCoord(-15,200,10);	\n\
P2.SetCoord(5,204,0);	\n\
P3.SetCoord(15,200,0);	\n\
P4.SetCoord(-15,20,15);	\n\
P5.SetCoord(-5,20,0);	\n\
P6.SetCoord(15,20,35);	\n\
TColgp_Array2OfPnt array(1,3,1,2);	\n\
array.SetValue(1,1,P1);	\n\
array.SetValue(2,1,P2);	\n\
array.SetValue(3,1,P3); 	\n\
array.SetValue(1,2,P4); 	\n\
array.SetValue(2,2,P5); 	\n\
array.SetValue(3,2,P6);	\n\
Handle (Geom_BSplineSurface) curve = GeomAPI_PointsToBSplineSurface(array,3,8,GeomAbs_C2,0.001);	\n\
\n\
RedFace = BRepBuilderAPI_MakeFace(curve);	\n\
\n\
////////The brown face	\n\
\n\
gp_Circ circle(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(1,0,0)),80);	\n\
Edge1 = BRepBuilderAPI_MakeEdge(circle,0,PI);	\n\
\n\
Edge2 = BRepBuilderAPI_MakeEdge(gp_Pnt(0,0,-80),gp_Pnt(0,-10,40));	\n\
Edge3 = BRepBuilderAPI_MakeEdge(gp_Pnt(0,-10,40),gp_Pnt(0,0,80));	\n\
\n\
TopoDS_Wire YellowWire;	\n\
BRepBuilderAPI_MakeWire MW1(Edge1,Edge2,Edge3);	\n\
if (MW1.IsDone()) {	\n\
		YellowWire = MW1;	\n\
}	\n\
\n\
BrownFace = BRepBuilderAPI_MakeFace(YellowWire);	\n\
\n");
Message +=("\
////////The pink face	\n\
\n\
P1.SetCoord(35,-200,40);	\n\
P2.SetCoord(50,-204,30);	\n\
P3.SetCoord(65,-200,30);	\n\
P4.SetCoord(35,-20,45);	\n\
P5.SetCoord(45,-20,30);	\n\
P6.SetCoord(65,-20,65);	\n\
TColgp_Array2OfPnt array2(1,3,1,2);	\n\
array2.SetValue(1,1,P1);	\n\
array2.SetValue(2,1,P2);	\n\
array2.SetValue(3,1,P3); 	\n\
array2.SetValue(1,2,P4); 	\n\
array2.SetValue(2,2,P5); 	\n\
array2.SetValue(3,2,P6);	\n\
	\n\
Handle (Geom_BSplineSurface) BSplineSurf = GeomAPI_PointsToBSplineSurface(array2,3,8,GeomAbs_C2,0.001);	\n\
	\n\
TopoDS_Face aFace = BRepBuilderAPI_MakeFace(BSplineSurf);	\n\
\n\
//2d lines	\n\
gp_Pnt2d P12d(0.9,0.1);	\n\
gp_Pnt2d P22d(0.2,0.7);	\n\
gp_Pnt2d P32d(0.02,0.1);	\n\
\n\
Handle (Geom2d_Line) line1=		\n\
	new Geom2d_Line(P12d,gp_Dir2d((0.2-0.9),(0.7-0.1)));	\n\
Handle (Geom2d_Line) line2=		\n\
	new Geom2d_Line(P22d,gp_Dir2d((0.02-0.2),(0.1-0.7)));   \n\
Handle (Geom2d_Line) line3=		\n\
	new Geom2d_Line(P32d,gp_Dir2d((0.9-0.02),(0.1-0.1)));	\n\
		\n\
//Edges are on the BSpline surface	\n\
Edge1 = BRepBuilderAPI_MakeEdge(line1,BSplineSurf,0,P12d.Distance(P22d));	\n\
Edge2 = BRepBuilderAPI_MakeEdge(line2,BSplineSurf,0,P22d.Distance(P32d));	\n\
Edge3 = BRepBuilderAPI_MakeEdge(line3,BSplineSurf,0,P32d.Distance(P12d));	\n\
\n\
Wire1 = BRepBuilderAPI_MakeWire(Edge1,Edge2,Edge3);	\n\
Wire1.Reverse();	\n\
PinkFace = BRepBuilderAPI_MakeFace(aFace,Wire1);	\n\
BRepLib::BuildCurves3d(PinkFace);	\n\
\n\
\n");

	PocessTextInDialog("Make face ", Message);
}






#include "TColStd_Array2OfReal.hxx"



void CTopologyBuildingDoc::OnShell() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TColgp_Array2OfPnt Poles(1,2,1,4);
	Poles.SetValue(1,1,gp_Pnt(0,0,0));
	Poles.SetValue(1,2,gp_Pnt(0,10,2));
	Poles.SetValue(1,3,gp_Pnt(0,20,10)); 
	Poles.SetValue(1,4,gp_Pnt(0,30,0)); 
	Poles.SetValue(2,1,gp_Pnt(10,0,5));
	Poles.SetValue(2,2,gp_Pnt(10,10,3));
	Poles.SetValue(2,3,gp_Pnt(10,20,20));
	Poles.SetValue(2,4,gp_Pnt(10,30,0));

	TColStd_Array1OfReal UKnots(1,2);
	UKnots.SetValue(1,0);
	UKnots.SetValue(2,1);

	TColStd_Array1OfInteger UMults(1,2);
	UMults.SetValue(1,2);
	UMults.SetValue(2,2);

	TColStd_Array1OfReal VKnots(1,3);
	VKnots.SetValue(1,0);
	VKnots.SetValue(2,1);
	VKnots.SetValue(3,2);

	TColStd_Array1OfInteger VMults(1,3);
	VMults.SetValue(1,3);
	VMults.SetValue(2,1);
	VMults.SetValue(3,3);

	Standard_Integer UDegree(1);
	Standard_Integer VDegree(2);
	
	Handle (Geom_BSplineSurface) BSpline = new Geom_BSplineSurface(Poles,UKnots,VKnots,UMults,VMults,UDegree,VDegree);
	
	TopoDS_Face WhiteFace = BRepBuilderAPI_MakeFace(BSpline);

	
	Handle(AIS_Shape) white = new AIS_Shape(WhiteFace);
	myAISContext->SetColor(white,Quantity_NOC_WHITE);
	myAISContext->SetMaterial(white,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetTransparency(white,0.7);
	myAISContext->Display(white,Standard_False);
	

	TopoDS_Shell aShell = BRepBuilderAPI_MakeShell(BSpline);
	Handle(AIS_Shape) anAISShell = new AIS_Shape(aShell);
	myAISContext->SetDisplayMode(anAISShell,0);
	myAISContext->Display(anAISShell,Standard_False);
	//myAISContext->SetCurrentObject(anAISShell);

	Fit();
  
	TCollection_AsciiString Message ("\
	\n\
TColgp_Array2OfPnt Poles(1,2,1,4);	\n\
Poles.SetValue(1,1,gp_Pnt(0,0,0));	\n\
Poles.SetValue(1,2,gp_Pnt(0,10,2));	\n\
Poles.SetValue(1,3,gp_Pnt(0,20,10)); 	\n\
Poles.SetValue(1,4,gp_Pnt(0,30,0)); 	\n\
Poles.SetValue(2,1,gp_Pnt(10,0,5));	\n\
Poles.SetValue(2,2,gp_Pnt(10,10,3));	\n\
Poles.SetValue(2,3,gp_Pnt(10,20,20));	\n\
Poles.SetValue(2,4,gp_Pnt(10,30,0));	\n\
\n\
TColStd_Array1OfReal UKnots(1,2);	\n\
UKnots.SetValue(1,0);	\n\
UKnots.SetValue(2,1);	\n\
\n\
TColStd_Array1OfInteger UMults(1,2);	\n\
UMults.SetValue(1,2);	\n\
UMults.SetValue(2,2);	\n\
\n\
TColStd_Array1OfReal VKnots(1,3);	\n\
VKnots.SetValue(1,0);	\n\
VKnots.SetValue(2,1);	\n\
VKnots.SetValue(3,2);	\n\
\n\
TColStd_Array1OfInteger VMults(1,3);	\n\
VMults.SetValue(1,3);	\n\
VMults.SetValue(2,1);	\n\
VMults.SetValue(3,3);	\n\
\n\
Standard_Integer UDegree(1);	\n\
Standard_Integer VDegree(2);	\n\
	\n\
Handle (Geom_BSplineSurface) BSpline = new Geom_BSplineSurface(Poles,UKnots,VKnots,UMults,VMults,UDegree,VDegree);	\n\
	\n\
TopoDS_Shell aShell = BRepBuilderAPI_MakeShell(BSpline);	\n\
\n\
\n");

	PocessTextInDialog("Make shell", Message);
	
}

void CTopologyBuildingDoc::OnCompound() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	BRep_Builder builder;
	TopoDS_Compound Comp;
	builder.MakeCompound(Comp);

	TopoDS_Vertex aVertex = BRepBuilderAPI_MakeVertex(gp_Pnt(-20,10,-30));
	builder.Add(Comp,aVertex);
	
	gp_Lin line(gp_Ax1(gp_Pnt(10,10,10),gp_Dir(1,0,0)));
	TopoDS_Edge anEdge = BRepBuilderAPI_MakeEdge(line,-20,10);
	builder.Add(Comp,anEdge);

	gp_Sphere sphere (gp_Ax3(gp_Pnt(-80,0,0),gp_Dir(1,0,0)),150);
	TopoDS_Face aFace = BRepBuilderAPI_MakeFace(sphere,0.1,0.7,0.2,0.9);
	builder.Add(Comp,aFace);

	TopoDS_Shape aBox = BRepPrimAPI_MakeBox(gp_Pnt(-60,0,0),30,60,40);
	builder.Add(Comp,aBox);

	Handle(AIS_Shape) white = new AIS_Shape(Comp);
	myAISContext->SetDisplayMode(white,0);
	myAISContext->Display(white,Standard_False);

	Fit();


   TCollection_AsciiString Message ("\
		\n\
BRep_Builder builder;	\n\
TopoDS_Compound Comp;	\n\
builder.MakeCompound(Comp);	\n\
\n\
TopoDS_Vertex aVertex = BRepBuilderAPI_MakeVertex(gp_Pnt(-20,10,-30));	\n\
builder.Add(Comp,aVertex);	\n\
	\n\
gp_Lin line(gp_Ax1(gp_Pnt(10,10,10),gp_Dir(1,0,0)));	\n\
TopoDS_Edge anEdge = BRepBuilderAPI_MakeEdge(line,-20,10);	\n\
builder.Add(Comp,anEdge);	\n\
	\n\
gp_Sphere sphere (gp_Ax3(gp_Pnt(-80,0,0),gp_Dir(1,0,0)),150);	\n\
TopoDS_Face aFace = BRepBuilderAPI_MakeFace(sphere,0.1,0.7,0.2,0.9);	\n\
builder.Add(Comp,aFace);	\n\
	\n\
TopoDS_Shape aBox = BRepPrimAPI_MakeBox(gp_Pnt(-60,0,0),30,60,40);	\n\
builder.Add(Comp,aBox);	\n\
	\n\
\n");

	PocessTextInDialog("Make compound ", Message);

}





void CTopologyBuildingDoc::OnSewing() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	gp_Pnt P(0,0,0);
	gp_Vec V(0,0,1);
	Handle(Geom_Plane) Pi=new Geom_Plane(P,V);
	Handle(Geom_RectangularTrimmedSurface) GeometricSurface=new Geom_RectangularTrimmedSurface(Pi,0.,100.,0.,100.);
	TopoDS_Shape FirstShape = BRepBuilderAPI_MakeFace(GeometricSurface);
	
	Handle(AIS_Shape) white1 = new AIS_Shape(FirstShape);
	
	myAISContext->SetColor(white1,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(white1,Graphic3d_NOM_PLASTIC,Standard_False); 
	myAISContext->SetTransparency(white1,0.4,Standard_False);
	myAISContext->Display(white1,Standard_False);
	//Sleep(1000);
	
	gp_Pnt P1(0,0,0);
	gp_Pnt P2(50,0,0);
	gp_Pnt P3(100,0,0);
	gp_Pnt P4(25,12,85);
	gp_Pnt P5(100,0,80);
	gp_Pnt P6(135,-12,85);

	TColgp_Array2OfPnt Array(1,3,1,2);
	Array.SetValue(1,1,P1);
	Array.SetValue(2,1,P2);
	Array.SetValue(3,1,P3);
	Array.SetValue(1,2,P4);
	Array.SetValue(2,2,P5);
	Array.SetValue(3,2,P6);

	Handle (Geom_BSplineSurface) aSurf = GeomAPI_PointsToBSplineSurface(Array,3,8,GeomAbs_C2,0.00001);
	TopoDS_Shape SecondShape = BRepBuilderAPI_MakeFace(aSurf);
	
	Handle(AIS_Shape) white2 = new AIS_Shape(SecondShape);
	
	myAISContext->SetColor(white2,Quantity_NOC_YELLOW,Standard_False);
	myAISContext->SetMaterial(white2,Graphic3d_NOM_PLASTIC,Standard_False);  
	myAISContext->SetTransparency(white2,0.4,Standard_False);
	myAISContext->Display(white2,Standard_False);

	//Sleep(1000);
	
	BRepOffsetAPI_Sewing aMethod;
	aMethod.Add(FirstShape);	
	aMethod.Add(SecondShape);

	aMethod.Perform();

	TopoDS_Shape sewedShape = aMethod.SewedShape();

	Handle(AIS_Shape) result = new AIS_Shape(sewedShape);
	myAISContext->SetDisplayMode(result,0,Standard_False);
	myAISContext->Display(result,Standard_False);

	Fit();

   TCollection_AsciiString Message ("\
	\n\
///////The first shape \n\
 \n\
gp_Pnt P(0,0,0);	\n\
gp_Vec V(0,0,1);	\n\
Handle(Geom_Plane) Pi=new Geom_Plane(P,V);	\n\
Handle(Geom_RectangularTrimmedSurface) GeometricSurface=new Geom_RectangularTrimmedSurface(Pi,0.,100.,0.,100.);	\n\
TopoDS_Shape FirstShape = BRepBuilderAPI_MakeFace(GeometricSurface);	\n\
	\n\
///////The second shape \n\
 \n\
gp_Pnt P1(0,0,0);	\n\
gp_Pnt P2(50,0,0);	\n\
gp_Pnt P3(100,0,0);	\n\
gp_Pnt P4(25,12,85);	\n\
gp_Pnt P5(100,0,80);	\n\
gp_Pnt P6(135,-12,85);	\n\
\n\
TColgp_Array2OfPnt Array(1,3,1,2);	\n\
Array.SetValue(1,1,P1);	\n\
Array.SetValue(2,1,P2);	\n\
Array.SetValue(3,1,P3);	\n\
Array.SetValue(1,2,P4);	\n\
Array.SetValue(2,2,P5);	\n\
Array.SetValue(3,2,P6);	\n\
\n\
Handle (Geom_BSplineSurface) aSurf = GeomAPI_PointsToBSplineSurface(Array,3,8,GeomAbs_C2,0.00001);	\n\
TopoDS_Shape SecondShape = BRepBuilderAPI_MakeFace(aSurf);	\n\
	\n\
BRepOffsetAPI_Sewing aMethod;	\n\
aMethod.Add(FirstShape);		\n\
aMethod.Add(SecondShape);	\n\
\n\
aMethod.Perform();	\n\
\n\
TopoDS_Shape sewedShape = aMethod.SewedShape();	\n\
	\n\
\n");

	PocessTextInDialog("Sew faces ", Message);

}







void CTopologyBuildingDoc::OnBuilder() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	//The tolerance is the tolerance of confusion
	Standard_Real precision = Precision::Confusion();

	//The builder
	BRep_Builder B;

	//Build the vertices
	TopoDS_Vertex V000, V001, V010, V011, V100, V101, V110, V111;
	B.MakeVertex(V000,gp_Pnt(0,0,0),precision);
	B.MakeVertex(V001,gp_Pnt(0,0,100),precision);
	B.MakeVertex(V010,gp_Pnt(0,150,0),precision);
	B.MakeVertex(V011,gp_Pnt(0,150,100),precision);
	B.MakeVertex(V100,gp_Pnt(200,0,0),precision);
	B.MakeVertex(V101,gp_Pnt(200,0,100),precision);
	B.MakeVertex(V110,gp_Pnt(200,150,0),precision);
	B.MakeVertex(V111,gp_Pnt(200,150,100),precision);

	//Build the edges
	//the edges are oriented as the axis X,Y,Z
	TopoDS_Edge EX00, EX01, EX10, EX11;
	TopoDS_Edge EY00, EY01, EY10, EY11;
	TopoDS_Edge EZ00, EZ01, EZ10, EZ11;
	Handle (Geom_Line) L;

	//Edge X00
	L = new Geom_Line(gp_Pnt(0,0,0),gp_Dir(1,0,0));
	B.MakeEdge(EX00,L,precision);
	V000.Orientation(TopAbs_FORWARD);
	V100.Orientation(TopAbs_REVERSED);
	B.Add(EX00,V000);
	B.Add(EX00,V100);
	//Parameters
	B.UpdateVertex(V000,0,EX00,precision);
	B.UpdateVertex(V100,200,EX00,precision);

	//Edge X10
	L = new Geom_Line(gp_Pnt(0,150,0),gp_Dir(1,0,0));
	B.MakeEdge(EX10,L,precision);
	V010.Orientation(TopAbs_FORWARD);
	V110.Orientation(TopAbs_REVERSED);
	B.Add(EX10,V010);
	B.Add(EX10,V110);
	//Parameters
	B.UpdateVertex(V010,0,EX10,precision);
	B.UpdateVertex(V110,200,EX10,precision);

	//Edge Y00
	L = new Geom_Line(gp_Pnt(0,0,0),gp_Dir(0,1,0));
	B.MakeEdge(EY00,L,precision);
	V000.Orientation(TopAbs_FORWARD);
	V010.Orientation(TopAbs_REVERSED);
	B.Add(EY00,V000);
	B.Add(EY00,V010);
	//Parameters
	B.UpdateVertex(V000,0,EY00,precision);
	B.UpdateVertex(V010,150,EY00,precision);

	//Edge Y10
	L = new Geom_Line(gp_Pnt(200,0,0),gp_Dir(0,1,0));
	B.MakeEdge(EY10,L,precision);
	V100.Orientation(TopAbs_FORWARD);
	V110.Orientation(TopAbs_REVERSED);
	B.Add(EY10,V100);
	B.Add(EY10,V110);
	//Parameters
	B.UpdateVertex(V100,0,EY10,precision);
	B.UpdateVertex(V110,150,EY10,precision);

	//Edge Y01
	L = new Geom_Line(gp_Pnt(0,0,100),gp_Dir(0,1,0));
	B.MakeEdge(EY01,L,precision);
	V001.Orientation(TopAbs_FORWARD);
	V011.Orientation(TopAbs_REVERSED);
	B.Add(EY01,V001);
	B.Add(EY01,V011);
	//Parameters
	B.UpdateVertex(V001,0,EY01,precision);
	B.UpdateVertex(V011,150,EY01,precision);

	//Edge Y11
	L = new Geom_Line(gp_Pnt(200,0,100),gp_Dir(0,1,0));
	B.MakeEdge(EY11,L,precision);
	V101.Orientation(TopAbs_FORWARD);
	V111.Orientation(TopAbs_REVERSED);
	B.Add(EY11,V101);
	B.Add(EY11,V111);
	//Parameters
	B.UpdateVertex(V101,0,EY11,precision);
	B.UpdateVertex(V111,150,EY11,precision);

	//Edge Z00
	L = new Geom_Line(gp_Pnt(0,0,0),gp_Dir(0,0,1));
	B.MakeEdge(EZ00,L,precision);
	V000.Orientation(TopAbs_FORWARD);
	V001.Orientation(TopAbs_REVERSED);
	B.Add(EZ00,V000);
	B.Add(EZ00,V001);
	//Parameters
	B.UpdateVertex(V000,0,EZ00,precision);
	B.UpdateVertex(V001,100,EZ00,precision);

	//Edge Z01
	L = new Geom_Line(gp_Pnt(0,150,0),gp_Dir(0,0,1));
	B.MakeEdge(EZ01,L,precision);
	V010.Orientation(TopAbs_FORWARD);
	V011.Orientation(TopAbs_REVERSED);
	B.Add(EZ01,V010);
	B.Add(EZ01,V011);
	//Parameters
	B.UpdateVertex(V010,0,EZ01,precision);
	B.UpdateVertex(V011,100,EZ01,precision);

	//Edge Z10
	L = new Geom_Line(gp_Pnt(200,0,0),gp_Dir(0,0,1));
	B.MakeEdge(EZ10,L,precision);
	V100.Orientation(TopAbs_FORWARD);
	V101.Orientation(TopAbs_REVERSED);
	B.Add(EZ10,V100);
	B.Add(EZ10,V101);
	//Parameters
	B.UpdateVertex(V100,0,EZ10,precision);
	B.UpdateVertex(V101,100,EZ10,precision);

	//Edge Z11
	L = new Geom_Line(gp_Pnt(200,150,0),gp_Dir(0,0,1));
	B.MakeEdge(EZ11,L,precision);
	V110.Orientation(TopAbs_FORWARD);
	V111.Orientation(TopAbs_REVERSED);
	B.Add(EZ11,V110);
	B.Add(EZ11,V111);
	//Parameters
	B.UpdateVertex(V110,0,EZ11,precision);
	B.UpdateVertex(V111,100,EZ11,precision);


	//Circular Edges
	Handle (Geom_Circle) C;
	Standard_Real R = 100;

	//Edge EX01
	C = new Geom_Circle(gp_Ax2(gp_Pnt(100,0,100),gp_Dir(0,1,0),gp_Dir(-1,0,0)),100);
	B.MakeEdge(EX01,C,precision);
	V001.Orientation(TopAbs_FORWARD);
	V101.Orientation(TopAbs_REVERSED);
	B.Add(EX01,V001);
	B.Add(EX01,V101);
	//Parameters
	B.UpdateVertex(V001,0,EX01,precision);
	B.UpdateVertex(V101,PI,EX01,precision);

	//Edge EX11
	C = new Geom_Circle(gp_Ax2(gp_Pnt(100,150,100),gp_Dir(0,1,0),gp_Dir(-1,0,0)),100);
	B.MakeEdge(EX11,C,precision);
	V011.Orientation(TopAbs_FORWARD);
	V111.Orientation(TopAbs_REVERSED);
	B.Add(EX11,V011);
	B.Add(EX11,V111);
	//Parameters
	B.UpdateVertex(V011,0,EX11,precision);
	B.UpdateVertex(V111,PI,EX11,precision);

	//Build wire and faces
	//Faces normals are along the axis X,Y,Z
	TopoDS_Face FXMIN, FXMAX, FYMIN, FYMAX, FZMIN, FZMAX;
	TopoDS_Wire W;
	Handle (Geom_Plane) P;
	Handle (Geom2d_Line) L2d;
	Handle (Geom2d_Circle) C2d;
	Handle (Geom_CylindricalSurface) S;

	//Face FXMAX
	P = new Geom_Plane(gp_Ax2(gp_Pnt(200,0,0),gp_Dir(1,0,0),gp_Dir(0,1,0)));
	B.MakeFace(FXMAX,P,precision);
	//the wire and the edges
	B.MakeWire (W);

	EY10.Orientation(TopAbs_FORWARD);
	B.Add(W,EY10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));
	B.UpdateEdge(EY10,L2d,FXMAX,precision);

	EZ11.Orientation(TopAbs_FORWARD);
	B.Add(W,EZ11);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(150,0),gp_Dir2d(0,1));
	B.UpdateEdge(EZ11,L2d,FXMAX,precision);

	EY11.Orientation(TopAbs_REVERSED);
	B.Add(W,EY11);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,100),gp_Dir2d(1,0));
	B.UpdateEdge(EY11,L2d,FXMAX,precision);

	EZ10.Orientation(TopAbs_REVERSED);
	B.Add(W,EZ10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EZ10,L2d,FXMAX,precision);

	B.Add(FXMAX,W);

	BRepTools::Write(FXMAX,"E:\\temp\\f1.rle");

	//Face FXMIN
	P = new Geom_Plane(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(-1,0,0),gp_Dir(0,0,1)));
	B.MakeFace(FXMIN,P,precision);
	//the wire and the edges
	B.MakeWire (W);

	EZ00.Orientation(TopAbs_FORWARD);
	B.Add(W,EZ00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));
	B.UpdateEdge(EZ00,L2d,FXMIN,precision);

	EY01.Orientation(TopAbs_FORWARD);
	B.Add(W,EY01);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(100,0),gp_Dir2d(0,1));
	B.UpdateEdge(EY01,L2d,FXMIN,precision);

	EZ01.Orientation(TopAbs_REVERSED);
	B.Add(W,EZ01);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,150),gp_Dir2d(1,0));
	B.UpdateEdge(EZ01,L2d,FXMIN,precision);

	EY00.Orientation(TopAbs_REVERSED);
	B.Add(W,EY00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EY00,L2d,FXMIN,precision);


	B.Add(FXMIN,W);
	
	//Face FYMAX

	P = new Geom_Plane(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(0,1,0),gp_Dir(0,0,1)));
	B.MakeFace(FYMAX,P,precision);
	//the wire and the edges
	B.MakeWire (W);

	EZ00.Orientation(TopAbs_FORWARD);
	B.Add(W,EZ00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));
	B.UpdateEdge(EZ00,L2d,FYMAX,precision);

	EX01.Orientation(TopAbs_FORWARD);
	B.Add(W,EX01);
	//pcurve
	C2d = new Geom2d_Circle(gp_Ax2d(gp_Pnt2d(100,100),gp_Dir2d(0,-1)),100);
	B.UpdateEdge(EX01,C2d,FYMAX,precision);
	B.UpdateVertex(V001,0,EX01,FYMAX,precision);
	B.UpdateVertex(V101,PI,EX01,FYMAX,precision);

	EZ10.Orientation(TopAbs_REVERSED);
	B.Add(W,EZ10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,200),gp_Dir2d(1,0));
	B.UpdateEdge(EZ10,L2d,FYMAX,precision);

	EX00.Orientation(TopAbs_REVERSED);
	B.Add(W,EX00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EX00,L2d,FYMAX,precision);


	B.Add(FYMAX,W);



	//Face FYMIN
	P = new Geom_Plane(gp_Ax2(gp_Pnt(0,150,0),gp_Dir(0,1,0),gp_Dir(0,0,1)));
	B.MakeFace(FYMIN,P,precision);
	//the wire and the edges
	B.MakeWire (W);

	EZ01.Orientation(TopAbs_FORWARD);
	B.Add(W,EZ01);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));
	B.UpdateEdge(EZ01,L2d,FYMIN,precision);

	EX11.Orientation(TopAbs_FORWARD);
	B.Add(W,EX11);
	//pcurve
	C2d = new Geom2d_Circle(gp_Ax2d(gp_Pnt2d(100,100),gp_Dir2d(0,-1)),100);
	B.UpdateEdge(EX11,C2d,FYMIN,precision);
	B.UpdateVertex(V011,0,EX11,FYMIN,precision);
	B.UpdateVertex(V111,PI,EX11,FYMIN,precision);

	EZ11.Orientation(TopAbs_REVERSED);
	B.Add(W,EZ11);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,200),gp_Dir2d(1,0));
	B.UpdateEdge(EZ11,L2d,FYMIN,precision);

	EX10.Orientation(TopAbs_REVERSED);
	B.Add(W,EX10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EX10,L2d,FYMIN,precision);

	B.Add(FYMIN,W);

	//Face FZMAX
	P = new Geom_Plane(gp_Ax2(gp_Pnt(0,0,0),gp_Dir(0,0,-1),gp_Dir(0,1,0)));
	B.MakeFace(FZMAX,P,precision);
	//the wire and the edges
	B.MakeWire (W);

	EY00.Orientation(TopAbs_FORWARD);
	B.Add(W,EY00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));
	B.UpdateEdge(EY00,L2d,FZMAX,precision);

	EX10.Orientation(TopAbs_FORWARD);
	B.Add(W,EX10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(150,0),gp_Dir2d(0,1));
	B.UpdateEdge(EX10,L2d,FZMAX,precision);

	EY10.Orientation(TopAbs_REVERSED);
	B.Add(W,EY10);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,200),gp_Dir2d(1,0));
	B.UpdateEdge(EY10,L2d,FZMAX,precision);

	EX00.Orientation(TopAbs_REVERSED);
	B.Add(W,EX00);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EX00,L2d,FZMAX,precision);


	B.Add(FZMAX,W);
		
	//Face FZMIN
	S = new Geom_CylindricalSurface(gp_Ax3(gp_Pnt(100,0,100),gp_Dir(0,1,0),gp_Dir(-1,0,0)),100);
	B.MakeFace(FZMIN,S,precision);

	//the wire and the edges
	B.MakeWire (W);

	EX01.Orientation(TopAbs_FORWARD);
	B.Add(W,EX01);
	//pcurve
	L2d = new Geom2d_Line(gp_Ax2d(gp_Pnt2d(0,0),gp_Dir2d(1,0)));
	B.UpdateEdge(EX01,L2d,FZMIN,precision);
	B.UpdateVertex(V001,0,EX01,FZMIN,precision);
	B.UpdateVertex(V101,PI,EX01,FZMIN,precision);

	EY11.Orientation(TopAbs_FORWARD);
	B.Add(W,EY11);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(PI,0),gp_Dir2d(0,1));
	B.UpdateEdge(EY11,L2d,FZMIN,precision);

	EX11.Orientation(TopAbs_REVERSED);
	B.Add(W,EX11);
	//pcurve
	L2d = new Geom2d_Line(gp_Ax2d(gp_Pnt2d(0,150),gp_Dir2d(1,0)));
	B.UpdateEdge(EX11,L2d,FZMIN,precision);
	B.UpdateVertex(V111,PI,EX11,FZMIN,precision);
	B.UpdateVertex(V011,0,EX11,FZMIN,precision);

	EY01.Orientation(TopAbs_REVERSED);
	B.Add(W,EY01);
	//pcurve
	L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));
	B.UpdateEdge(EY01,L2d,FZMIN,precision);

	B.Add(FZMIN,W);

	FYMAX.Orientation(TopAbs_REVERSED);

	BRepTools::Write(FZMIN,"E:\\temp\\f3.rle");
	BRepTools::Write(FYMAX,"E:\\temp\\f2.rle");

	//Shell
	TopoDS_Shell Sh;
	B.MakeShell(Sh);
	B.Add(Sh,FXMAX);
	B.Add(Sh,FXMIN);
	B.Add(Sh,FYMAX);
	B.Add(Sh,FYMIN);
	B.Add(Sh,FZMAX);
	B.Add(Sh,FZMIN);

	// Solid
	TopoDS_Solid Sol;
	B.MakeSolid(Sol);
	B.Add(Sol,Sh);

	BRepTools::Write(Sol,"e://temp//solid");
	Handle(AIS_Shape) borne = new AIS_Shape(Sol);
	myAISContext->SetDisplayMode(borne,1);
	myAISContext->SetColor(borne,Quantity_NOC_RED);
	myAISContext->SetMaterial(borne,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(borne,Standard_False);


	Fit();
   TCollection_AsciiString Message ("\
		\n\
//The tolerance is 0.01 	\n\
Standard_Real precision(0.01);	\n\
\n\
//The builder	\n\
BRep_Builder B;	\n\
\n\
//Build the vertices	\n\
TopoDS_Vertex V000, V001, V010, V011, V100, V101, V110, V111;	\n\
B.MakeVertex(V000,gp_Pnt(0,0,0),precision);	\n\
B.MakeVertex(V001,gp_Pnt(0,0,100),precision);	\n\
B.MakeVertex(V010,gp_Pnt(0,150,0),precision);	\n\
B.MakeVertex(V011,gp_Pnt(0,150,100),precision);	\n\
B.MakeVertex(V100,gp_Pnt(200,0,0),precision);	\n\
B.MakeVertex(V101,gp_Pnt(200,0,100),precision);	\n\
B.MakeVertex(V110,gp_Pnt(200,150,0),precision);	\n\
B.MakeVertex(V111,gp_Pnt(200,150,100),precision);	\n\
\n\
//Build the edges	\n\
//the edges are oriented as the axis X,Y,Z	\n\
TopoDS_Edge EX00, EX01, EX10, EX11;	\n\
TopoDS_Edge EY00, EY01, EY10, EY11;	\n\
TopoDS_Edge EZ00, EZ01, EZ10, EZ11;	\n\
Handle (Geom_Line) L;	\n\
\n\
//Edge X00	\n\
L = new Geom_Line(gp_Pnt(0,0,0),gp_Dir(1,0,0));	\n\
B.MakeEdge(EX00,L,precision);	\n\
V000.Orientation(TopAbs_FORWARD);	\n\
V100.Orientation(TopAbs_REVERSED);	\n\
B.Add(EX00,V000);	\n\
B.Add(EX00,V100);	\n\
//Parameters	\n\
B.UpdateVertex(V000,0,EX00,precision);	\n\
B.UpdateVertex(V100,200,EX00,precision);	\n\
\n\
//Idem for all the linear edges...	\n\
\n\
//Circular Edges	\n\
Handle (Geom_Circle) C;	\n\
Standard_Real R = 100;	\n\
\n\
//Edge EX01	\n\
C = new Geom_Circle(gp_Ax2(gp_Pnt(100,0,100),gp_Dir(0,1,0),gp_Dir(-1,0,0)),100);	\n\
B.MakeEdge(EX01,C,precision);	\n\
V001.Orientation(TopAbs_FORWARD);	\n\
V101.Orientation(TopAbs_REVERSED);	\n\
B.Add(EX01,V001);	\n\
B.Add(EX01,V101);	\n\
//Parameters	\n\
B.UpdateVertex(V001,0,EX01,precision);	\n\
B.UpdateVertex(V101,PI,EX01,precision);	\n\
\n\
//Idem for EX11	\n\
\n\
//Build wire and faces	\n\
//Faces normals are along the axis X,Y,Z	\n\
TopoDS_Face FXMIN, FXMAX, FYMIN, FYMAX, FZMIN, FZMAX;	\n\
TopoDS_Wire W;	\n\
Handle (Geom_Plane) P;	\n\
Handle (Geom2d_Line) L2d;	\n\
Handle (Geom2d_Circle) C2d;	\n\
Handle (Geom_CylindricalSurface) S;	\n\
\n\
//Face FXMAX	\n\
P = new Geom_Plane(gp_Ax2(gp_Pnt(200,0,0),gp_Dir(1,0,0),gp_Dir(0,1,0)));	\n\
B.MakeFace(FXMAX,P,precision);	\n\
//the wire and the edges	\n\
B.MakeWire (W);	\n");
Message += ("\
\n\
EY10.Orientation(TopAbs_FORWARD);	\n\
B.Add(W,EY10);	\n\
//pcurve	\n\
L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(1,0));	\n\
B.UpdateEdge(EY10,L2d,FXMAX,precision);	\n\
	\n\
EZ11.Orientation(TopAbs_FORWARD);	\n\
B.Add(W,EZ11);	\n\
//pcurve	\n\
L2d = new Geom2d_Line(gp_Pnt2d(150,0),gp_Dir2d(0,1));	\n\
B.UpdateEdge(EZ11,L2d,FXMAX,precision);	\n\
	\n\
EY11.Orientation(TopAbs_REVERSED);	\n\
B.Add(W,EY11);	\n\
//pcurve	\n\
L2d = new Geom2d_Line(gp_Pnt2d(0,100),gp_Dir2d(1,0));	\n\
B.UpdateEdge(EY11,L2d,FXMAX,precision);	\n\
	\n\
EZ10.Orientation(TopAbs_REVERSED);	\n\
B.Add(W,EZ10);	\n\
//pcurve	\n\
L2d = new Geom2d_Line(gp_Pnt2d(0,0),gp_Dir2d(0,1));	\n\
B.UpdateEdge(EZ10,L2d,FXMAX,precision);	\n\
\n\
B.Add(FXMAX,W);	\n\
\n\
//Idem for other faces...	\n\
\n\
//Shell	\n\
TopoDS_Shell Sh;	\n\
B.MakeShell(Sh);	\n\
B.Add(Sh,FXMAX);	\n\
B.Add(Sh,FXMIN);	\n\
B.Add(Sh,FYMAX);	\n\
B.Add(Sh,FYMIN);	\n\
B.Add(Sh,FZMAX);	\n\
B.Add(Sh,FZMIN);	\n\
\n\
// Solid	\n\
TopoDS_Solid Sol;	\n\
B.MakeSolid(Sol);	\n\
B.Add(Sol,Sh);	\n\
\n\
\n");

PocessTextInDialog("Make a shape with a builder", Message);

}

void CTopologyBuildingDoc::OnGeometrie() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	//geometrie of a vertex
	TopoDS_Vertex aVertex = BRepBuilderAPI_MakeVertex(gp_Pnt(0,120,70));
	gp_Pnt GeometricPoint = BRep_Tool::Pnt(aVertex);

	Handle(AIS_Shape) vert = new AIS_Shape(aVertex);
	myAISContext->Display(vert,Standard_False);
	Fit();
	Sleep (500);

	//geometrie of an edge
	TopoDS_Edge anEdge = BRepBuilderAPI_MakeEdge(gp_Pnt(100,50,250),gp_Pnt(-30,-100,-50));
	Handle(AIS_Shape) yellow = new AIS_Shape(anEdge);
	myAISContext->SetWidth(yellow,2,Standard_False);
	myAISContext->Display(yellow,Standard_False);
	Fit();
	Sleep (500);

	TopLoc_Location location;
	Standard_Real first, last;
	Handle (Geom_Curve) aCurve = BRep_Tool::Curve(anEdge,location,first,last);
	TopoDS_Edge anEdgeDS = BRepBuilderAPI_MakeEdge(aCurve);

	Handle (Geom_Line) aLine = Handle (Geom_Line)::DownCast(aCurve);
	if (!aLine.IsNull()) {
		Handle (AIS_Line) DispLine = new AIS_Line(aLine);
		myAISContext->Display(DispLine,Standard_False);
		Fit();
		Sleep (500);
	}
		
	//geometrie of a face
	gp_Pnt P(-20,-20,-20);
	gp_Vec V(0,0,1);
	Handle(Geom_Plane) Pi=new Geom_Plane(P,V);
	Handle(Geom_RectangularTrimmedSurface) Surface=new Geom_RectangularTrimmedSurface(Pi,0.,100.,0.,100.);
	TopoDS_Face RedFace = BRepBuilderAPI_MakeFace(Surface);

	Handle(AIS_Shape) red = new AIS_Shape(RedFace);
	myAISContext->SetColor(red,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(red,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(red,Standard_False);
	Fit();
	Sleep (500);

	TopLoc_Location location2;
	Handle (Geom_Surface) aGeometricSurface = BRep_Tool::Surface(RedFace,location2);

	Handle (Geom_Plane) aPlane = Handle (Geom_Plane)::DownCast(aGeometricSurface);
	if (!aPlane.IsNull()) {
		Handle (AIS_Plane) DispPlane = new AIS_Plane(aPlane);
		myAISContext->Display(DispPlane,Standard_False);

	}


	Fit();
	Sleep (500);


   TCollection_AsciiString Message ("\
	\n\
///////geometrie of a vertex	\n\
TopoDS_Vertex aVertex = BRepBuilderAPI_MakeVertex(gp_Pnt(0,120,70));	\n\
gp_Pnt GeometricPoint = BRep_Tool::Pnt(aVertex);	\n\
\n\
///////geometrie of an edge	\n\
TopoDS_Edge anEdge = BRepBuilderAPI_MakeEdge(gp_Pnt(100,50,250),gp_Pnt(-30,-100,-50));	\n\
\n\
TopLoc_Location location;	\n\
Standard_Real first, last;	\n\
Handle (Geom_Curve) aCurve = BRep_Tool::Curve(anEdge,location,first,last);	\n\
TopoDS_Edge anEdgeDS = BRepBuilderAPI_MakeEdge(aCurve);	\n\
\n\
Handle (Geom_Line) aLine = Handle (Geom_Line)::DownCast(aCurve);	\n\
if (!aLine.IsNull()) {	\n\
	Handle (AIS_Line) DispLine = new AIS_Line(aLine);	\n\
}	\n\
		\n\
///////geometrie of a face	\n\
gp_Pnt P(-20,-20,-20);	\n\
gp_Vec V(0,0,1);	\n\
Handle(Geom_Plane) Pi=new Geom_Plane(P,V);	\n\
Handle(Geom_RectangularTrimmedSurface) Surface=new Geom_RectangularTrimmedSurface(Pi,0.,100.,0.,100.);	\n\
TopoDS_Face RedFace = BRepBuilderAPI_MakeFace(Surface);	\n\
\n\
TopLoc_Location location2;	\n\
Handle (Geom_Surface) aGeometricSurface = BRep_Tool::Surface(RedFace,location2);	\n\
\n\
Handle (Geom_Plane) aPlane = Handle (Geom_Plane)::DownCast(aGeometricSurface);	\n\
if (!aPlane.IsNull()) {	\n\
	Handle (AIS_Plane) DispPlane = new AIS_Plane(aPlane);	\n\
}	\n\
\n\
\n");

	PocessTextInDialog("Recover the geometrie of vertex, edge and face ", Message);


}

void CTopologyBuildingDoc::OnExplorer() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	
	TopoDS_Shape aBox = BRepPrimAPI_MakeBox(100,100,100);
	Standard_Integer j(8);
	Handle(AIS_Shape) theBox = new AIS_Shape(aBox);
	myAISContext->SetColor(theBox,Quantity_NOC_RED,Standard_False);
	myAISContext->SetMaterial(theBox,Graphic3d_NOM_PLASTIC,Standard_False);  
	myAISContext->Display(theBox,Standard_False);
	Fit();
	Sleep(500);

	for (TopExp_Explorer exp (aBox,TopAbs_FACE);exp.More();exp.Next()) {
		TopoDS_Face aCurrentFace = TopoDS::Face(exp.Current());

		//test the orientation of the current face
		TopAbs_Orientation orient = aCurrentFace.Orientation();

		//Recover the geometric plane
		TopLoc_Location location;
		Handle (Geom_Surface) aGeometricSurface = BRep_Tool::Surface(aCurrentFace,location);

		Handle (Geom_Plane) aPlane = Handle (Geom_Plane)::DownCast(aGeometricSurface);

		//Build an AIS_Shape with a new color
		Handle(AIS_Shape) theMovingFace = new AIS_Shape(aCurrentFace);
		Quantity_NameOfColor aCurrentColor = (Quantity_NameOfColor)j;
		myAISContext->SetColor(theMovingFace,aCurrentColor,Standard_False);
		myAISContext->SetMaterial(theMovingFace,Graphic3d_NOM_PLASTIC,Standard_False);  
		//Find the normal vector of each face
		gp_Pln agpPlane = aPlane->Pln();
		gp_Ax1 norm = agpPlane.Axis();
		gp_Dir dir = norm.Direction();
		gp_Vec move(dir);
		//Connect
// new in 2.0 ... AIS_ConnectedInteractive wants a TopLoc_Location instead of a Geom_Transformation
//		TopLoc_Location aLocation;
//		Handle (AIS_ConnectedInteractive) theTransformedDisplay = new AIS_ConnectedInteractive();
//		theTransformedDisplay->Connect(theMovingFace,theMove);
//		theTransformedDisplay->Connect(theMovingFace, aLocation);
//		Handle (Geom_Transformation) theMove = new Geom_Transformation(aLocation->Transformation());
// new in 2.0
//		myAISContext->Display(theTransformedDisplay);

		TopLoc_Location aLocation;
		Handle (AIS_ConnectedInteractive) theTransformedDisplay = new AIS_ConnectedInteractive();
		theTransformedDisplay->Connect(theMovingFace, aLocation);


		// = myAISContext->Location(theMovingFace);
		Handle (Geom_Transformation) theMove = new Geom_Transformation(aLocation.Transformation());
        myAISContext->Display(theTransformedDisplay,Standard_False);
		Fit();
		Sleep (500);

		for (Standard_Integer i=1;i<=30;i++) {

		//Build a transformation on the display
//			theMove->SetTranslation(move*i);

//			if (orient==TopAbs_FORWARD) theTransformedDisplay->SetTransformation(theMove);
//			else theTransformedDisplay->SetTransformation(theMove->Inverted());

//			myAISContext->Redisplay(theTransformedDisplay);

// new in 2.0			
			theMove->SetTranslation(move*i);
			if (orient==TopAbs_FORWARD) myAISContext->SetLocation(theTransformedDisplay,TopLoc_Location(theMove->Trsf()));
			else myAISContext->SetLocation(theTransformedDisplay,TopLoc_Location(theMove->Inverted()->Trsf()));

			myAISContext->Redisplay(theTransformedDisplay,Standard_False);
		}
		j+=15;
	}
	//myAISContext->Erase(theBox,Standard_True,Standard_False);	
	myAISContext->Remove(theBox);	
	Fit();
	Sleep (500);

	   TCollection_AsciiString Message ("\
\n\
TopoDS_Shape aBox = BRepPrimAPI_MakeBox(100,100,100);	\n\
\n\
for (TopExp_Explorer exp (aBox,TopAbs_FACE);exp.More();exp.Next()) {	\n\
	TopoDS_Face aCurrentFace = TopoDS::Face(exp.Current());	\n\
\n\
	//Recover the geometric plane	\n\
	TopLoc_Location location;	\n\
	Handle (Geom_Surface) aGeometricSurface = BRep_Tool::Surface(aCurrentFace,location);	\n\
\n\
	Handle (Geom_Plane) aPlane = Handle (Geom_Plane)::DownCast(aGeometricSurface);	\n\
	\n\
\n");
	PocessTextInDialog("Explode a shape in faces ", Message);

}

