// File:	StepToGeom_MakeCircle.cxx
// Created:	Fri Jul  2 16:37:06 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeCircle.ixx>
#include <StepGeom_Circle.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <Geom_Axis2Placement.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un Circle de Geom a partir d' un Circle de Step
//=============================================================================

StepToGeom_MakeCircle::StepToGeom_MakeCircle
  ( const Handle(StepGeom_Circle)& C)
{
  StepGeom_Axis2Placement   AxisSelect;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)    A1;
  gp_Ax2                         A2;
  Standard_Real                  R;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 2) {
    StepToGeom_MakeAxis2Placement 
      MkAxis2(Handle(StepGeom_Axis2Placement3d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis2.Value();
    A2 = A1->Ax2();
    R  = C->Radius() * UnitsMethods::LengthFactor(); 
    theCircle = new Geom_Circle(A2, R);
    done = Standard_True;
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Circle) &
      StepToGeom_MakeCircle::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCircle;
}
