// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gce_MakeHypr2d_HeaderFile
#define _gce_MakeHypr2d_HeaderFile

#ifndef _gp_Hypr2d_HeaderFile
#include <gp_Hypr2d.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class gp_Pnt2d;
class gp_Ax2d;
class gp_Ax22d;
class gp_Hypr2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!This class implements the following algorithms used to <br>
//!          create a 2d Hyperbola from gp. <br>
//!          * Create a 2d Hyperbola from its center and two points: <br>
//!            one on its axis of symmetry giving the major radius, the <br>
//!            other giving the value of the small radius. <br>
//!          * Create a 2d Hyperbola from its major axis and its major <br>
//!            radius and its minor radius. <br>
//! <br>
class gce_MakeHypr2d  : public gce_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a hyperbola <br>
//!   centered on the point Center, where: <br>
//!   -   the major axis of the hyperbola is defined by Center and point S1, <br>
//!   -   the major radius is the distance between Center and S1, and <br>
//!   -   the minor radius is the distance between point S2 and the major axis. <br>
Standard_EXPORT gce_MakeHypr2d(const gp_Pnt2d& S1,const gp_Pnt2d& S2,const gp_Pnt2d& Center);

//! Constructs a hyperbola with major and minor radii MajorRadius and <br>
//!   MinorRadius, where: <br>
//!   -   the center of the hyperbola is the origin of the axis MajorAxis, and <br>
//!   -   the major axis is defined by MajorAxis if Sense <br>
//! is true, or the opposite axis to MajorAxis if Sense is false; or <br>
//! -   centered on the origin of the coordinate system <br>
//!   A, with major and minor radii MajorRadius and <br>
//!   MinorRadius, where its major axis is the "X Axis" <br>
//!   of A (A is the local coordinate system of the hyperbola). <br>
Standard_EXPORT gce_MakeHypr2d(const gp_Ax2d& MajorAxis,const Standard_Real MajorRadius,const Standard_Real MinorRadius,const Standard_Boolean Sense);

//!Creates a Hypr2d centered on the origin of the coordinate system <br>
//!  A, with major and minor radii MajorRadius and <br>
//!  MinorRadius, where its major axis is the "X Axis" <br>
//!  of A (A is the local coordinate system of the hyperbola). <br>
Standard_EXPORT gce_MakeHypr2d(const gp_Ax22d& A,const Standard_Real MajorRadius,const Standard_Real MinorRadius);

//! Returns the constructed hyperbola. <br>
//! Exceptions StdFail_NotDone if no hyperbola is constructed. <br>
Standard_EXPORT  const gp_Hypr2d& Value() const;


Standard_EXPORT  const gp_Hypr2d& Operator() const;
Standard_EXPORT operator gp_Hypr2d() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Hypr2d TheHypr2d;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
