// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gce_MakeDir_HeaderFile
#define _gce_MakeDir_HeaderFile

#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class gp_Vec;
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the following algorithms used <br>
//!           to create a Dir from gp. <br>
//!           * Create a Dir parallel to another and passing <br>
//!             through a point. <br>
//!           * Create a Dir passing through 2 points. <br>
//!           * Create a Dir from its axis (Ax1 from gp). <br>
//!           * Create a Dir from a point and a direction. <br>
class gce_MakeDir  : public gce_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Normalizes the vector V and creates a direction. <br>
//!            Status is "NullVector" if V.Magnitude() <= Resolution. <br>
Standard_EXPORT gce_MakeDir(const gp_Vec& V);

//! Creates a direction from a triplet of coordinates. <br>
//!            Status is "NullVector" if Coord.Modulus() <= <br>
//!            Resolution from gp. <br>
Standard_EXPORT gce_MakeDir(const gp_XYZ& Coord);

//! Creates a direction with its 3 cartesian coordinates. <br>
//!            Status is "NullVector" if Sqrt(Xv*Xv + Yv*Yv + Zv*Zv) <br>
//!            <= Resolution <br>
Standard_EXPORT gce_MakeDir(const Standard_Real Xv,const Standard_Real Yv,const Standard_Real Zv);

//! Make a Dir from gp <TheDir> passing through 2 <br>
//!           Pnt <P1>,<P2>. <br>
//!           Status is "ConfusedPoints" if <p1> and <P2> are confused. <br>
//! Warning <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_ConfusedPoints if points P1 and P2 are coincident, or <br>
//! -   gce_NullVector if one of the following is less <br>
//!   than or equal to gp::Resolution(): <br>
//!   -   the magnitude of vector V, <br>
//!   -   the modulus of Coord, <br>
//!   -   Sqrt(Xv*Xv + Yv*Yv + Zv*Zv). <br>
Standard_EXPORT gce_MakeDir(const gp_Pnt& P1,const gp_Pnt& P2);

//! Returns the constructed unit vector. <br>
//! Exceptions StdFail_NotDone if no unit vector is constructed. <br>
Standard_EXPORT  const gp_Dir& Value() const;


Standard_EXPORT  const gp_Dir& Operator() const;
Standard_EXPORT operator gp_Dir() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Dir TheDir;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
