// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WNT_GraphicDevice_HeaderFile
#define _WNT_GraphicDevice_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_WNT_GraphicDevice_HeaderFile
#include <Handle_WNT_GraphicDevice.hxx>
#endif

#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_Handle_HeaderFile
#include <Aspect_Handle.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _WNT_ColorRef_HeaderFile
#include <WNT_ColorRef.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_GraphicDevice_HeaderFile
#include <Aspect_GraphicDevice.hxx>
#endif
#ifndef _WNT_Long_HeaderFile
#include <WNT_Long.hxx>
#endif
#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
#ifndef _Handle_WNT_HColorTable_HeaderFile
#include <Handle_WNT_HColorTable.hxx>
#endif
#ifndef _Handle_Aspect_GraphicDriver_HeaderFile
#include <Handle_Aspect_GraphicDriver.hxx>
#endif
class Aspect_GraphicDeviceDefinitionError;
class Aspect_BadAccess;
class WNT_Window;
class Quantity_Color;
class Aspect_ColorMap;
class WNT_HColorTable;
class Aspect_GraphicDriver;


//! This class defines Windows NT display device. <br>
//!          A Graphic Device defines color management. Windows can run in three <br>
//!          different color modes depending of the installed graphic board: <br>
//!           - Low color resolution which allows us to use 16 predefined pure <br>
//!             colors for drawing lines and unlimited number of dithered colors <br>
//!             for window's background, solid filled areas etc. Here Graphic Device <br>
//!             will approximate requested colors by existing ones for line colors <br>
//!             ( really this approximation is doing by Windows ). A dithering <br>
//!             technique will be used for window's backgrounds, solid fills etc. <br>
//!             ( this is doing by WIndows also ). A dithering techique will be use <br>
//!             for solid fill. <br>
//!           - Medium color resolution which requires a Windows palette manager. <br>
//!             This mode takes after X window system's PseudoColor Visual. The <br>
//!             application can create a LOGICAL PALETTE to represent 20 reserved <br>
//!             by Windows colors and 236 programmable ones. It's possible to reserve <br>
//!             odd entries in the palette for highlighting purposes ( but real <br>
//!             technique is not the same as in X window system - see Windows manual ). <br>
//!             It's possible to create several logical palettes. To do it create <br>
//!             other GraphicDevice but in this case color "flicking" is possible. <br>
//!           - High color resolution. Here 65 536 or 16 777 216 colors are available. <br>
//!             Any color we like will be exactly displayed on the screen, but <br>
//!             highlighting technique is not available. This mode often called <br>
//!             TrueColor but it's not the same as X window TrueColor. <br>
//!          A Graphic Device also defines physical dimensions of the screen. <br>
class WNT_GraphicDevice : public Aspect_GraphicDevice {

public:
 // Methods PUBLIC
 // 

//! Creates a GraphicDevice and logical palette. <br>
//!          Builds an OpenGL colorcube on that palette depending <br>
//!          of the aColorCube flag and hardware. <br>
//!  Warning: Raises if createion of the logical palette failed. <br>
Standard_EXPORT WNT_GraphicDevice(const Standard_Boolean aColorCube = Standard_False,const Aspect_Handle aDevContext = 0);

//! same as previous one (to provide access form CCL) <br>
Standard_EXPORT WNT_GraphicDevice(const Standard_Boolean aColorCube,const Standard_Integer aDevContext);

//! Destroies all ressources attached to the GraphicDevice. <br>
Standard_EXPORT virtual  void Destroy() ;
~WNT_GraphicDevice()
{
  Destroy();
}


//! Returns the color value in form specific to Windows NT. <br>
//!          Sets the color values in the logical palette if the <br>
//!          hardware supports it. If in this case there are not <br>
//!          free cell in the logical palette then this method will <br>
//!          search for nearest color in the palette. <br>
//!          If <aHighlight> is True then sets a highlight color. <br>
Standard_EXPORT   WNT_ColorRef SetColor(const Quantity_Color& aColor,const Standard_Boolean aHighlight = Standard_False) ;

//! See above <br>
Standard_EXPORT virtual  WNT_ColorRef SetColor(const Standard_Integer aRed,const Standard_Integer aGreen,const Standard_Integer aBlue,const Standard_Boolean aHighlight = Standard_False) ;

//! Color allocation for images. <br>
Standard_EXPORT virtual  void SetColor(const WNT_Long& aPixel) ;

//! Returns the color value in form specific to WIndows NT <br>
//!          in the <aColorTable>. See SetColor method. <br>
//!  Warning: The dimensions and index ranges of the <aColorMap> and <br>
//!          <aColorTable> must be the same; <br>
Standard_EXPORT   void MapColors(const Handle(Aspect_ColorMap)& aColorMap,Handle(WNT_HColorTable)& aColorTable) ;
//! Returns logical palette handle attached to the <br>
//!          GraphicDevice. <br>
  Aspect_Handle HPalette() const;
//! Returns the Display size in PIXEL <br>
  void DisplaySize(Standard_Integer& aWidth,Standard_Integer& aHeight) const;
//! Returns the Display size in working units units <br>
  void DisplaySize(Quantity_Length& aWidth,Quantity_Length& aHeight) const;
//! Returns True if hardware is palette-compatible. <br>
  Standard_Boolean IsPaletteDevice() const;
//! Returns number of available colors. <br>
  Standard_Integer NumColors() const;
//! Returns highlight color. <br>
  WNT_ColorRef HighlightColor() const;

//! Dummy method <br>
Standard_EXPORT virtual  Handle_Aspect_GraphicDriver GraphicDriver() const;


friend class WNT_Window;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void Init(const Standard_Boolean aColorCube,const Aspect_Handle aDevContext) ;


 // Fields PROTECTED
 //
Quantity_Length myMWidth;
Quantity_Length myMHeight;
Standard_Integer myWidth;
Standard_Integer myHeight;
Standard_Integer myNumColors;
Standard_Integer myFreeIndex;
Aspect_Handle myPalette;
Standard_Address myLogPal;
WNT_ColorRef myHighlightColor;
Standard_Boolean myOpenGLPalette;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <WNT_GraphicDevice.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
