// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_NormalBinding_HeaderFile
#define _Vrml_NormalBinding_HeaderFile

#ifndef _Vrml_MaterialBindingAndNormalBinding_HeaderFile
#include <Vrml_MaterialBindingAndNormalBinding.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a NormalBinding node of VRML specifying properties of geometry <br>
//!          and its appearance. <br>
//!  This node specifies how the current normals are bound to shapes that follow in the scene <br>
//!  graph. Each shape node may interpret bindings differently. <br>
//!  The bindings for faces and vertices are meaningful only for shapes that are made from <br>
//!  faces and vertices. Similarly, the indexed bindings are only used by the shapes that allow <br>
//!  indexing. For bindings that require multiple normals, be sure to have at least as many <br>
//!  normals defined as are necessary; otherwise, errors will occur. <br>
class Vrml_NormalBinding  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_NormalBinding(const Vrml_MaterialBindingAndNormalBinding aValue);


Standard_EXPORT Vrml_NormalBinding();


Standard_EXPORT   void SetValue(const Vrml_MaterialBindingAndNormalBinding aValue) ;


Standard_EXPORT   Vrml_MaterialBindingAndNormalBinding Value() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Vrml_MaterialBindingAndNormalBinding myValue;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
