// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Voxel_Selector_HeaderFile
#define _Voxel_Selector_HeaderFile

#ifndef _Handle_V3d_View_HeaderFile
#include <Handle_V3d_View.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class V3d_View;
class Voxel_BoolDS;
class Voxel_ColorDS;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Detects voxels in the viewer 3d under the mouse cursor. <br>
class Voxel_Selector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! An empty constructor. <br>
Standard_EXPORT Voxel_Selector();

//! A constructor of the selector, <br>
//!          which initializes the classes <br>
//!          by a view, where the user selects the voxels. <br>
Standard_EXPORT Voxel_Selector(const Handle(V3d_View)& view);

//! Initializes the selector by a view, <br>
//!          where the user selects the voxels. <br>
Standard_EXPORT   void Init(const Handle(V3d_View)& view) ;

//! Defines the voxels (1bit). <br>
Standard_EXPORT   void SetVoxels(const Voxel_BoolDS& voxels) ;

//! Defines the voxels (4bit). <br>
Standard_EXPORT   void SetVoxels(const Voxel_ColorDS& voxels) ;

//! Detects a voxel under the mouse cursor. <br>
Standard_EXPORT   Standard_Boolean Detect(const Standard_Integer winx,const Standard_Integer winy,Standard_Integer& ix,Standard_Integer& iy,Standard_Integer& iz) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_V3d_View myView;
Standard_Address myVoxels;
Standard_Boolean myIsBool;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
