// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Standard_ErrorHandlerCallback_HeaderFile
#define _Standard_ErrorHandlerCallback_HeaderFile

#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class Standard_ErrorHandler;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Defines a base class for callback objects that can be registered <br>
//!          in the OCC error handler (the class simulating C++ exceptions) <br>
//!          so as to be correctly destroyed when error handler is activated. <br>
class Standard_ErrorHandlerCallback  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Registers this callback object in the current error handler <br>
//!          (if found). <br>
  void RegisterCallback() ;
//! Unregisters this callback object from the error handler. <br>
  void UnregisterCallback() ;
virtual Standard_EXPORT ~Standard_ErrorHandlerCallback ();

//! The callback function to perform necessary callback action. <br>
//!          Called by the exception handler when it is being destroyed but <br>
//!          still has this callback registered. <br>
Standard_EXPORT virtual  void DestroyCallback()  = 0;


friend class Standard_ErrorHandler;



protected:

 // Methods PROTECTED
 // 
//! Empty constructor <br>
Standard_ErrorHandlerCallback();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Address myHandler;
Standard_Address myPrev;
Standard_Address myNext;


};


#include <Standard_ErrorHandlerCallback.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
