// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_Shape_HeaderFile
#define _ShapeFix_Shape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_Shape_HeaderFile
#include <Handle_ShapeFix_Shape.hxx>
#endif

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Handle_ShapeFix_Solid_HeaderFile
#include <Handle_ShapeFix_Solid.hxx>
#endif
#ifndef _TopTools_MapOfShape_HeaderFile
#include <TopTools_MapOfShape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _ShapeFix_Root_HeaderFile
#include <ShapeFix_Root.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_ShapeFix_Shell_HeaderFile
#include <Handle_ShapeFix_Shell.hxx>
#endif
#ifndef _Handle_ShapeFix_Face_HeaderFile
#include <Handle_ShapeFix_Face.hxx>
#endif
#ifndef _Handle_ShapeFix_Wire_HeaderFile
#include <Handle_ShapeFix_Wire.hxx>
#endif
#ifndef _Handle_ShapeFix_Edge_HeaderFile
#include <Handle_ShapeFix_Edge.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
#ifndef _Handle_ShapeExtend_BasicMsgRegistrator_HeaderFile
#include <Handle_ShapeExtend_BasicMsgRegistrator.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class ShapeFix_Solid;
class TopoDS_Shape;
class ShapeFix_Shell;
class ShapeFix_Face;
class ShapeFix_Wire;
class ShapeFix_Edge;
class ShapeExtend_BasicMsgRegistrator;


//! Fixing shape in general <br>
class ShapeFix_Shape : public ShapeFix_Root {

public:
 // Methods PUBLIC
 // 

//! Empty Constructor <br>
Standard_EXPORT ShapeFix_Shape();

//! Initislises by shape. <br>
Standard_EXPORT ShapeFix_Shape(const TopoDS_Shape& shape);

//! Initislises by shape. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& shape) ;

//! Iterates on sub- shape and performs fixes <br>
Standard_EXPORT   Standard_Boolean Perform() ;

//! Returns resulting shape <br>
Standard_EXPORT   TopoDS_Shape Shape() const;
//! Returns tool for fixing solids. <br>
  Handle_ShapeFix_Solid FixSolidTool() const;
//! Returns tool for fixing shells. <br>
  Handle_ShapeFix_Shell FixShellTool() const;
//! Returns tool for fixing faces. <br>
  Handle_ShapeFix_Face FixFaceTool() const;
//! Returns tool for fixing wires. <br>
  Handle_ShapeFix_Wire FixWireTool() const;
//! Returns tool for fixing edges. <br>
  Handle_ShapeFix_Edge FixEdgeTool() const;

//! Returns the status of the last Fix. <br>
//!          This can be a combination of the following flags: <br>
//!          ShapeExtend_DONE1: some free edges were fixed <br>
//!          ShapeExtend_DONE2: some free wires were fixed <br>
//!          ShapeExtend_DONE3: some free faces were fixed <br>
//!          ShapeExtend_DONE4: some free shells were fixed <br>
//!          ShapeExtend_DONE5: some free solids were fixed <br>
//!          ShapeExtend_DONE6: shapes in compound(s) were fixed <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;

//! Sets message registrator <br>
Standard_EXPORT virtual  void SetMsgRegistrator(const Handle(ShapeExtend_BasicMsgRegistrator)& msgreg) ;

//! Sets basic precision value (also to FixSolidTool) <br>
Standard_EXPORT virtual  void SetPrecision(const Standard_Real preci) ;

//! Sets minimal allowed tolerance (also to FixSolidTool) <br>
Standard_EXPORT virtual  void SetMinTolerance(const Standard_Real mintol) ;

//! Sets maximal allowed tolerance (also to FixSolidTool) <br>
Standard_EXPORT virtual  void SetMaxTolerance(const Standard_Real maxtol) ;
//! Returns (modifiable) the mode for applying fixes of <br>
//!          ShapeFix_Solid, by default True. <br>
  Standard_Integer& FixSolidMode() ;
//! Returns (modifiable) the mode for applying fixes of <br>
//!          ShapeFix_Shell, by default True. <br>
  Standard_Integer& FixFreeShellMode() ;
//! Returns (modifiable) the mode for applying fixes of <br>
//!          ShapeFix_Face, by default True. <br>
  Standard_Integer& FixFreeFaceMode() ;
//! Returns (modifiable) the mode for applying fixes of <br>
//!          ShapeFix_Wire, by default True. <br>
  Standard_Integer& FixFreeWireMode() ;
//! Returns (modifiable) the mode for applying <br>
//!          ShapeFix::SameParameter after all fixes, by default True. <br>
  Standard_Integer& FixSameParameterMode() ;
//! Returns (modifiable) the mode for applying <br>
//!          ShapeFix::FixVertexPosition before all fixes, by default False. <br>
  Standard_Integer& FixVertexPositionMode() ;
//Standard_EXPORT ~ShapeFix_Shape();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void SameParameter(const TopoDS_Shape& shape,const Standard_Boolean force) ;


 // Fields PROTECTED
 //
TopoDS_Shape myResult;
Handle_ShapeFix_Solid myFixSolid;
TopTools_MapOfShape myMapFixingShape;
Standard_Integer myFixSolidMode;
Standard_Integer myFixShellMode;
Standard_Integer myFixFaceMode;
Standard_Integer myFixWireMode;
Standard_Integer myFixSameParameterMode;
Standard_Integer myFixVertexPositionMode;
Standard_Integer myStatus;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <ShapeFix_Shape.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
