// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeAnalysis_TransferParameters_HeaderFile
#define _ShapeAnalysis_TransferParameters_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_TransferParameters_HeaderFile
#include <Handle_ShapeAnalysis_TransferParameters.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfReal_HeaderFile
#include <Handle_TColStd_HSequenceOfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Face;
class TColStd_HSequenceOfReal;


//! This tool is used for transferring parameters <br>
//!          from 3d curve of the edge to pcurve and vice versa. <br>
class ShapeAnalysis_TransferParameters : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates empty tool with myShift = 0 and myScale = 1 <br>
Standard_EXPORT ShapeAnalysis_TransferParameters();

//! Creates a tool and initializes it with edge and face <br>
Standard_EXPORT ShapeAnalysis_TransferParameters(const TopoDS_Edge& E,const TopoDS_Face& F);

//! Initialize a tool with edge and face <br>
Standard_EXPORT virtual  void Init(const TopoDS_Edge& E,const TopoDS_Face& F) ;

//! Sets maximal tolerance to use linear recomputation of <br>
//!          parameters. <br>
Standard_EXPORT   void SetMaxTolerance(const Standard_Real maxtol) ;

//! Transfers parameters given by sequence Params from 3d curve <br>
//!          to pcurve (if To2d is True) or back (if To2d is False) <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfReal Perform(const Handle(TColStd_HSequenceOfReal)& Params,const Standard_Boolean To2d) ;

//! Transfers parameter given by sequence Params from 3d curve <br>
//!          to pcurve (if To2d is True) or back (if To2d is False) <br>
Standard_EXPORT virtual  Standard_Real Perform(const Standard_Real Param,const Standard_Boolean To2d) ;

//!Recomputes range of curves from NewEdge. <br>
//!	        If Is2d equals True parameters are recomputed by curve2d else by curve3d. <br>
Standard_EXPORT virtual  void TransferRange(TopoDS_Edge& newEdge,const Standard_Real prevPar,const Standard_Real currPar,const Standard_Boolean To2d) ;

//! Returns True if 3d curve of edge and pcurve are SameRange <br>
//!          (in default implementation, if myScale == 1 and myShift == 0) <br>
Standard_EXPORT virtual  Standard_Boolean IsSameRange() const;
//Standard_EXPORT ~ShapeAnalysis_TransferParameters();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Real myFirst;
Standard_Real myLast;
TopoDS_Edge myEdge;
Standard_Real myMaxTolerance;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myShift;
Standard_Real myScale;
Standard_Real myFirst2d;
Standard_Real myLast2d;
TopoDS_Face myFace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
