/***********************************************************************

     FONCTION :
     ----------
        Fichier OpenGl_tgl_funcs.h


     REMARQUES:
     ---------- 
      

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       ??-??-?? : PCT ; creation
       10-07-96 : FMN ; Suppression #define sur calcul matrice
       05-08-97 : PCT ; support texture mapping
       23-12-97 : FMN ; Suppression TelBackInteriorStyle, TelBackInteriorStyleIndex
       15-01-98 : FMN ; Ajout Hidden line
       08-04-98 : FGU ; Ajout emission 
       27-11-98 : CAL ; S4062. Ajout des layers.
       30-11-98 : FMN ; S3819 : Textes toujours visibles
       22-03-04 : SAN ; OCC4895 High-level interface for controlling polygon offsets
       04-10-04 : ABD ; Added User Defined marker type

************************************************************************/

/*----------------------------------------------------------------------*/

#ifndef  OPENGL_TGL_FUNCS_H
#define  OPENGL_TGL_FUNCS_H

#define BUC60570        /* GG 06-09-99
//              The model view SD_NORMAL must shown objects with FLAT shading
*/

#ifndef G003
#define G003            /* EUG 06-10-99 Degeneration support
*/
#endif

#ifndef OCC2934 
#define OCC2934         /* SAN 22/01/04 Texture mapped fonts on WNT */
#endif

/*----------------------------------------------------------------------*/
/*
 * Includes
 */

#include <OpenGl_telem.h>
#include <OpenGl_telem_pick.h>
#include <OpenGl_tsm.h>
#include <InterfaceGraphic_Aspect.hxx>

/*----------------------------------------------------------------------*/
/*
 * Types definis
 */

typedef float matrix3[4][4];

typedef enum {
    TYPE_PARAL,
    TYPE_PERSPECT
} projtype;

typedef enum {
    IND_NO_CLIP,
    IND_CLIP
} clip_ind;

typedef struct {
    float   x;  /* x coordinate */
    float   y;  /* y coordinate */
    float   z;  /* z coordinate */
} point3;

typedef struct {
    float   delta_x;    /* x magnitude */
    float   delta_y;    /* y magnitude */
    float   delta_z;    /* z magnitude */
} vec3;

typedef struct {
    float   x_min;  /* x min */
    float   x_max;  /* x max */
    float   y_min;  /* y min */
    float   y_max;  /* y max */
    float   z_min;  /* z min */
    float   z_max;  /* z max */
} limit3;

typedef struct {
    float   x_min;  /* x min */
    float   x_max;  /* x max */
    float   y_min;  /* y min */
    float   y_max;  /* y max */
} limit;

typedef struct {
    limit   win;    /* window limits */
    limit3  proj_vp;    /* viewport limits */
    projtype    proj_type;  /* projection type */
    point3  proj_ref_point; /* projection reference point */
    float   view_plane; /* view plane distance */
    float   back_plane; /* back plane distance */
    float   front_plane;    /* front plane distance */
} view_map3;

/*----------------------------------------------------------------------*/
/*
 * Prototypes
 */

extern  void  call_func_label(Tint); /* lid */
extern  void  call_func_set_view_ind(Tint); /* vid */
extern  void  call_func_appl_data(void*); /* data */
extern  void  call_func_set_local_tran3(Tmatrix3, TComposeType); /* mat, mode */
extern  void  call_func_set_linewidth(Tfloat); /* lw */
extern  void  call_func_set_linetype(Tint); /* lt */
extern  void  call_func_set_int_style(Tint); /* is */
extern  void  call_func_set_edge_flag(Tint); /* state */
extern  void  call_func_set_edge_type(Tint); /* type */
extern  void  call_func_set_edgewidth(Tfloat); /* width */
extern  void  call_func_set_int_style_ind(Tint); /* ind */
extern  void  call_func_set_face_disting_mode(Tint); /* mode */
extern  void  call_func_set_face_cull_mode(Tint); /* mode */
extern  void  call_func_set_marker_type(Tint); /* type */
extern  void  call_func_set_marker_size(Tfloat); /* size */
extern  void  call_func_exec_struct(Tint); /* stid */
extern  void  call_func_init_tgl(void);
extern  void  call_func_post_struct(Tint, Tint, Tfloat); /* ws, stid, prio */
extern  void  call_func_set_int_shad_meth(Tint); /* method */
extern  void  call_func_set_refl_eqn(Tint); /* eqn */
extern  void  call_func_set_back_refl_eqn(Tint); /* eqn */
extern  void  call_func_set_text_font(Tchar*); /* font */
extern  void  call_func_set_char_space(Tfloat); /* sp */
extern  void  call_func_set_char_expan(Tfloat); /* exp */
extern  void  call_func_set_pick_id(Tint); /* pickid */
extern  void  call_func_redraw_all_structs (Tint, Tint); /* wsid, swap */
extern  void  call_func_redraw_all_structs_begin (Tint); /* wsid */
extern  void  call_func_redraw_all_structs_proc (Tint); /* wsid */
extern  void  call_func_redraw_all_structs_end (Tint, Tint); /* wsid, swap */
extern  void  call_func_set_anno_char_ht(Tfloat); /* height */
extern  void  call_func_set_anno_char_up_vec(Tfloat[2]); /* up_vector */
extern  void  call_func_set_anno_path(Tint); /* path */
extern  void  call_func_set_anno_align(Tint, Tint); /* hor, ver */
extern  void  call_func_anno_text_rel3( tel_point, Tchar* );
extern  void  call_func_dcue_ind(Tint); /* dcid */
extern  void  call_func_set_do_texturemap(Tint); /* bool */
extern  void  call_func_set_texture_id(Tint); /* TextureID */
extern  void  call_func_set_text_style(int); /* style */
extern  void  call_func_set_text_display_type(int); /* display_type */
#ifdef G003
extern  void call_func_set_degenerate_model ( Tint, Tfloat ); /* degenerate model */
#endif  /* G003 */
#if defined(OCC2934) && defined(WNT)
extern  void  call_func_set_tex_mapped_font(Tint); /* texmapped fonts usage */
extern  void  call_func_eval_char_offsets(int);
#endif  /* OCC2934 */
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */
extern  void  call_func_set_polygon_offset_params( Tint,     /* mode */
                                                   Tfloat,   /* factor */
                                                   Tfloat ); /* units */
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */

/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
extern  void call_func_set_transform_persistence( Tint, Tfloat, Tfloat, Tfloat );
/* extern  void  call_func_set_transform_persistence( tel_transform_persistence tp );*/
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */


/* OCC18942: obsolete in OCCT6.3, might be removed in further versions! */
extern void call_func_eval_ori_matrix3( point3 *vrp, vec3 *vpn, vec3 *vup,
                                        int *err_ind, float mout[4][4] );
/* OCC18942: obsolete in OCCT6.3, might be removed in further versions! */
extern void call_func_eval_map_matrix3( view_map3 *Map, int *err_ind,
                                        matrix3 mat );

/*----------------------------------------------------------------------*/
/*
 * Constantes
 */

/* Edge types */
#define  CALL_PHIGS_EDGE_OFF           TOff
#define  CALL_PHIGS_EDGE_ON            TOn

/* Edge data flags */
#define  CALL_PHIGS_EDGE_NONE          TOff
#define  CALL_PHIGS_EDGE_VISIBILITY    TOn

/* Line Types */
#define  CALL_PHIGS_LINE_SOLID         TEL_LS_SOLID
#define  CALL_PHIGS_LINE_DASH          TEL_LS_DASH
#define  CALL_PHIGS_LINE_DOT           TEL_LS_DOT
#define  CALL_PHIGS_LINE_DASH_DOT      TEL_LS_DASH_DOT

/* Marker types */
#define  CALL_PHIGS_MARKER_DOT          TEL_PM_DOT
#define  CALL_PHIGS_MARKER_PLUS         TEL_PM_PLUS
#define  CALL_PHIGS_MARKER_ASTERISK     TEL_PM_STAR
#define  CALL_PHIGS_MARKER_CIRCLE       TEL_PM_CIRC
#define  CALL_PHIGS_MARKER_CROSS        TEL_PM_CROSS
#define  CALL_PHIGS_MARKER_USER_DEFINED TEL_PM_USERDEFINED

/* Text : Path */
#define  CALL_PHIGS_PATH_RIGHT         0
#define  CALL_PHIGS_PATH_LEFT          0
#define  CALL_PHIGS_PATH_UP            0
#define  CALL_PHIGS_PATH_DOWN          0

/*OCC7456 abd 14.12.2004 Text alingnment attributes  */
/* Text : Horizontal alignment */
#define  CALL_PHIGS_HOR_NORM           0
#define  CALL_PHIGS_HOR_LEFT           1
#define  CALL_PHIGS_HOR_CTR            2
#define  CALL_PHIGS_HOR_RIGHT          3

/* Text : Vertical alignment */
#define  CALL_PHIGS_VERT_NORM          0
#define  CALL_PHIGS_VERT_TOP           1
#define  CALL_PHIGS_VERT_CAP           2
#define  CALL_PHIGS_VERT_HALF          3
#define  CALL_PHIGS_VERT_BASE          4
#define  CALL_PHIGS_VERT_BOTTOM        5
/*OCC7456 abd 14.12.2004 Text alingnment attributes  */

/* Interior styles */
#define  CALL_PHIGS_STYLE_HOLLOW       TSM_HOLLOW
#define  CALL_PHIGS_STYLE_SOLID        TSM_SOLID
#define  CALL_PHIGS_STYLE_HATCH        TSM_HATCH
#define  CALL_PHIGS_STYLE_EMPTY        TSM_EMPTY
#define  CALL_PHIGS_STYLE_HIDDENLINE   TSM_HIDDENLINE

/* Light Source Types */
#define  CALL_PHIGS_LIGHT_AMBIENT      TLightAmbient
#define  CALL_PHIGS_LIGHT_DIRECTIONAL  TLightDirectional
#define  CALL_PHIGS_LIGHT_POSITIONAL   TLightPositional
#define  CALL_PHIGS_LIGHT_SPOT         TLightSpot

/* Hatch styles */
#define  CALL_PHIGS_HATCH_HORIZ        TEL_HS_HORIZONTAL
#define  CALL_PHIGS_HATCH_HORIZ_DBL    TEL_HS_HORIZONTAL_SPARSE
#define  CALL_PHIGS_HATCH_VERT         TEL_HS_VERTICAL
#define  CALL_PHIGS_HATCH_VERT_DBL     TEL_HS_VERTICAL_SPARSE
#define  CALL_PHIGS_HATCH_DIAG_45      TEL_HS_DIAG_45
#define  CALL_PHIGS_HATCH_DIAG_45_DBL  TEL_HS_DIAG_45_SPARSE
#define  CALL_PHIGS_HATCH_DIAG_135     TEL_HS_DIAG_135
#define  CALL_PHIGS_HATCH_DIAG_135_DBL TEL_HS_DIAG_135_SPARSE
#define  CALL_PHIGS_HATCH_GRID_R       TEL_HS_GRID
#define  CALL_PHIGS_HATCH_GRID_R_DBL   TEL_HS_GRID_SPARSE
#define  CALL_PHIGS_HATCH_GRID_D       TEL_HS_CROSS
#define  CALL_PHIGS_HATCH_GRID_D_DBL   TEL_HS_CROSS_SPARSE

/* Edit modes */
#define  CALL_PHIGS_EDIT_INSERT        TEditInsert
#define  CALL_PHIGS_EDIT_REPLACE       TEditReplace

/* Transformation */
#define  CALL_PHIGS_TYPE_PRECONCAT     TPreConcatenate
#define  CALL_PHIGS_TYPE_POSTCONCAT    TPostConcatenate
#define  CALL_PHIGS_TYPE_REPLACE       TReplace

/* Clipping indicators */
#define  CALL_PHIGS_IND_NO_CLIP        TOff
#define  CALL_PHIGS_IND_CLIP           TOn

/* Projection types */
#define  CALL_PHIGS_TYPE_PARAL         TelParallel
#define  CALL_PHIGS_TYPE_PERSPECT      TelPerspective

/* shading methods */
#define  CALL_PHIGS_SD_NONE            TEL_SM_FLAT
#define  CALL_PHIGS_SD_COLOUR          TEL_SM_GOURAUD
#define  CALL_PHIGS_SD_DOT_PRODUCT     TEL_SM_GOURAUD
#ifndef BUC60570
#define  CALL_PHIGS_SD_NORMAL          TEL_SM_GOURAUD
#else
#define  CALL_PHIGS_SD_NORMAL          TEL_SM_FLAT
#endif

/* lighting methods */
#define  CALL_PHIGS_REFL_NONE               0x0000
#define  AMBIENT_MASK                       0x0001
#define  DIFFUSE_MASK                       0x0002
#define  SPECULAR_MASK                      0x0004
#define  EMISSIVE_MASK                      0x0008

/*#define  CALL_PHIGS_REFL_AMBIENT            TelLModelAmbient
#define  CALL_PHIGS_REFL_DIFFUS             TelLModelDiffuse
#define  CALL_PHIGS_REFL_SPECULAR           TelLModelSpecular
#define  CALL_PHIGS_REFL_EMISSION           TelLModelEmission
#define  CALL_PHIGS_REFL_AMB_DIFF           TelLModelDiffuse
#define  CALL_PHIGS_REFL_AMB_DIFF_SPEC      TelLModelSpecular
#define  CALL_PHIGS_REFL_AMB_DIFF_SPEC_EMS  TelLModelEmission  */

/* cull mode */
#define  CALL_PHIGS_CULL_NONE          TelCullNone
#define  CALL_PHIGS_CULL_BACKFACE      TelCullBack
#define  CALL_PHIGS_CULL_FRONTFACE     TelCullFront

/* depth cue mode */
#define  CALL_PHIGS_SUPPRESSED         TelDCSuppressed
#define  CALL_PHIGS_ALLOWED            TelDCAllowed

/* distinguish mode */
#define  CALL_PHIGS_DISTING_NO         TOff
#define  CALL_PHIGS_DISTING_YES        TOn

#define  CALL_DEF_ENABLE_ZBUFFER       TOn
#define  CALL_DEF_DISABLE_ZBUFFER      TOff


/* Fonts */
#define  CALL_PHIGS_ASCII_MONO            "Courier" 
#define  CALL_PHIGS_ASCII_SIMPLEX         "Times-Roman"
#define  CALL_PHIGS_ASCII_COMPLEX         "Times-Roman"
#define  CALL_PHIGS_ASCII_DUPLEX          "Times-Bold"
#define  CALL_PHIGS_ASCII_TRIPLEX         "Times-Bold"
#define  CALL_PHIGS_ASCII_ITALIC_COMPLEX  "Times-Italic"
#define  CALL_PHIGS_ASCII_ITALIC_TRIPLEX  "Times-BoldItalic"
#define  CALL_PHIGS_ASCII_SCRIPT_SIMPLEX  "ZapfChancery-MediumItalic"
#define  CALL_PHIGS_ASCII_SCRIPT_COMPLEX  "ZapfChancery-MediumItalic"
#define  CALL_PHIGS_GREEK_MONO            "Symbol"
#define  CALL_PHIGS_GREEK_SIMPLEX         "Symbol"
#define  CALL_PHIGS_GREEK_COMPLEX         "Symbol"
#define  CALL_PHIGS_SYMBOL_MONO           "ZapfDingbats"
#define  CALL_PHIGS_SYMBOL_SIMPLEX        "ZapfDingbats"
#define  CALL_PHIGS_CARTOGRAPHIC_SIMPLEX  "Rock"
#define  CALL_PHIGS_KANJI_MONO            "Iris"
#define  CALL_PHIGS_KATAKANA_MONO         "Iris"

/* style of text */
#define  ASPECT_TOST_NORMAL     0
#define  ASPECT_TOST_ANNOTATION 1

/* display type of the text */
#define  ASPECT_TODT_NORMAL     0
#define  ASPECT_TODT_SUBTITLE   1
#define  ASPECT_TODT_DEKALE     2
#define  ASPECT_TODT_BLEND      3
#ifdef OCC2934
#define  ASPECT_TODT_TEXFONT    4

#define  TEX_CHAR_SIZE          16 /* texture mapped char 16 pixels */
#endif

/* Pick Order */
#define  PTOP_FIRST                       TTopFirst
#define  PBOTTOM_FIRST                    TBottomFirst

/* Facet types */
#define  CALL_PHIGS_SHAPE_COMPLEX         TEL_SHAPE_COMPLEX
#define  CALL_PHIGS_SHAPE_NONCONVEX       TEL_SHAPE_CONCAVE
#define  CALL_PHIGS_SHAPE_CONVEX          TEL_SHAPE_CONVEX
#define  CALL_PHIGS_SHAPE_UNKNOWN         TEL_SHAPE_UNKNOWN

/* Vertex flags */
#define CALL_PHIGS_VERT_COORD                   TEL_VTFLAG_NONE
#define CALL_PHIGS_VERT_COORD_COLOUR            TEL_VTFLAG_COLOUR
#define CALL_PHIGS_VERT_COORD_NORMAL            TEL_VTFLAG_NORMAL
#define CALL_PHIGS_VERT_COORD_COLOUR_NORMAL     TEL_VTFLAG_COLOURNORMAL

/* Facet data flags */
#define CALL_PHIGS_FACET_NONE                   TEL_FAFLAG_NONE
#define CALL_PHIGS_FACET_COLOUR                 TEL_FAFLAG_COLOUR
#define CALL_PHIGS_FACET_NORMAL                 TEL_FAFLAG_NORMAL
#define CALL_PHIGS_FACET_COLOUR_NORMAL          TEL_FAFLAG_COLOURNORMAL

/* functions */
#define  call_func_open_struct         TsmOpenStructure
#define  call_func_close_struct        TsmCloseStructure
#define  call_func_set_edit_mode       TsmSetEditMode
#define  call_func_set_elem_ptr        TsmSetElementPointer
#define  call_func_offset_elem_ptr     TsmOffsetElementPointer
#define  call_func_set_elem_ptr_label  TsmSetElementPointerAtLabel
#define  call_func_del_elem            TsmDeleteElement
#define  call_func_del_elem_range      TsmDeleteElementRange
#define  call_func_del_elems_labels    TsmDeleteElementsBetweenLabels
#define  call_func_empty_struct        TsmEmptyStructure
#define  call_func_del_struct          TsmDeleteStructure 

/*
#define  call_func_eval_view_ori_matrix3   TelEvalViewOrientationMatrix
#define  call_func_eval_view_map_matrix3   TelEvalViewMappingMatrix
#define  call_func_set_view_rep3           TelSetViewRepresentation
*/

#define call_func_inq_elem_ptr             TsmGetCurElemPtr

/*----------------------------------------------------------------------*/

#endif
