// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_PrinterOStream_HeaderFile
#define _Message_PrinterOStream_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Message_PrinterOStream_HeaderFile
#include <Handle_Message_PrinterOStream.hxx>
#endif

#ifndef _Message_Gravity_HeaderFile
#include <Message_Gravity.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Message_Printer_HeaderFile
#include <Message_Printer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TCollection_AsciiString;
class TCollection_ExtendedString;


//! Implementation of a message printer associated with an ostream <br>
//!          The ostream may be either externally defined one (e.g. cout), <br>
//!          or file stream maintained internally (depending on constructor). <br>
class Message_PrinterOStream : public Message_Printer {

public:
 // Methods PUBLIC
 // 

//! Empty constructor, defaulting to cout <br>
Standard_EXPORT Message_PrinterOStream(const Message_Gravity theTraceLevel = Message_Warning);

//! Create printer for output to a specified file. <br>
//!          The option theDoAppend specifies whether file should be <br>
//!          appended or rewritten. <br>
//!          For specific file names (cout, cerr) standard streams are used <br>
Standard_EXPORT Message_PrinterOStream(const Standard_CString theFileName,const Standard_Boolean theDoAppend,const Message_Gravity theTraceLevel = Message_Warning);

//! Flushes the output stream and destroys it if it has been <br>
//!          specified externally with option doFree (or if it is internal <br>
//!          file stream) <br>
Standard_EXPORT   void Close() ;
~Message_PrinterOStream()
{
  Close();
}

//! Return trace level used for filtering messages; <br>
//!          messages with lover gravity will be ignored. <br>
  Message_Gravity GetTraceLevel() const;
//! Set trace level used for filtering messages. <br>
//!          By default, trace level is Message_Info, so that <br>
//!          all messages are output <br>
  void SetTraceLevel(const Message_Gravity theTraceLevel) ;
//! Returns option to convert non-Ascii symbols to UTF8 encoding <br>
  Standard_Boolean GetUseUtf8() const;
//! Sets option to convert non-Ascii symbols to UTF8 encoding <br>
  void SetUseUtf8(const Standard_Boolean useUtf8) ;
//! Returns reference to the output stream <br>
  Standard_OStream& GetStream() const;

//! Puts a message to the current stream <br>
//!          if its gravity is equal or greater <br>
//!          to the trace level set by SetTraceLevel() <br>
Standard_EXPORT virtual  void Send(const Standard_CString theString,const Message_Gravity theGravity,const Standard_Boolean putEndl = Standard_True) const;

//! Puts a message to the current stream <br>
//!          if its gravity is equal or greater <br>
//!          to the trace level set by SetTraceLevel() <br>
Standard_EXPORT virtual  void Send(const TCollection_AsciiString& theString,const Message_Gravity theGravity,const Standard_Boolean putEndl = Standard_True) const;

//! Puts a message to the current stream <br>
//!          if its gravity is equal or greater <br>
//!          to the trace level set by SetTraceLevel() <br>
//!          Non-Ascii symbols are converted to UTF-8 if UseUtf8 <br>
//!          option is set, else replaced by symbols '?' <br>
Standard_EXPORT virtual  void Send(const TCollection_ExtendedString& theString,const Message_Gravity theGravity,const Standard_Boolean putEndl = Standard_True) const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Message_Gravity myTraceLevel;
Standard_Address myStream;
Standard_Boolean myIsFile;
Standard_Boolean myUseUtf8;


};


#include <Message_PrinterOStream.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
