// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshVS_MeshOwner_HeaderFile
#define _MeshVS_MeshOwner_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MeshVS_MeshOwner_HeaderFile
#include <Handle_MeshVS_MeshOwner.hxx>
#endif

#ifndef _Handle_MeshVS_DataSource_HeaderFile
#include <Handle_MeshVS_DataSource.hxx>
#endif
#ifndef _Handle_TColStd_HPackedMapOfInteger_HeaderFile
#include <Handle_TColStd_HPackedMapOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _SelectMgr_EntityOwner_HeaderFile
#include <SelectMgr_EntityOwner.hxx>
#endif
#ifndef _SelectMgr_SOPtr_HeaderFile
#include <SelectMgr_SOPtr.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager_HeaderFile
#include <Handle_PrsMgr_PresentationManager.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class MeshVS_DataSource;
class TColStd_HPackedMapOfInteger;
class PrsMgr_PresentationManager3d;
class PrsMgr_PresentationManager;


//! The custom mesh owner used for advanced mesh selection. This class provides methods to store information: <br>
//! 1) IDs of hilighted mesh nodes and elements <br>
//! 2) IDs of mesh nodes and elements selected on the mesh <br>
class MeshVS_MeshOwner : public SelectMgr_EntityOwner {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT MeshVS_MeshOwner(const SelectMgr_SOPtr& theSelObj,const Handle(MeshVS_DataSource)& theDS,const Standard_Integer thePriority = 0);


Standard_EXPORT  const Handle_MeshVS_DataSource& GetDataSource() const;

//! Returns ids of selected mesh nodes <br>
Standard_EXPORT  const Handle_TColStd_HPackedMapOfInteger& GetSelectedNodes() const;

//! Returns ids of selected mesh elements <br>
Standard_EXPORT  const Handle_TColStd_HPackedMapOfInteger& GetSelectedElements() const;

//! Saves ids of selected mesh entities <br>
Standard_EXPORT   void AddSelectedEntities(const Handle(TColStd_HPackedMapOfInteger)& Nodes,const Handle(TColStd_HPackedMapOfInteger)& Elems) ;

//! Clears ids of selected mesh entities <br>
Standard_EXPORT   void ClearSelectedEntities() ;

//! Returns ids of hilighted mesh nodes <br>
Standard_EXPORT  const Handle_TColStd_HPackedMapOfInteger& GetDetectedNodes() const;

//! Returns ids of hilighted mesh elements <br>
Standard_EXPORT  const Handle_TColStd_HPackedMapOfInteger& GetDetectedElements() const;

//! Saves ids of hilighted mesh entities <br>
Standard_EXPORT   void SetDetectedEntities(const Handle(TColStd_HPackedMapOfInteger)& Nodes,const Handle(TColStd_HPackedMapOfInteger)& Elems) ;


Standard_EXPORT virtual  void HilightWithColor(const Handle(PrsMgr_PresentationManager3d)& PM,const Quantity_NameOfColor theColor,const Standard_Integer Mode = 0) ;


Standard_EXPORT virtual  void Unhilight(const Handle(PrsMgr_PresentationManager)& PM,const Standard_Integer Mode = 0) ;


Standard_EXPORT virtual  Standard_Boolean IsForcedHilight() const;
//Standard_EXPORT ~MeshVS_MeshOwner();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_MeshVS_DataSource myDataSource;
Handle_TColStd_HPackedMapOfInteger mySelectedNodes;
Handle_TColStd_HPackedMapOfInteger mySelectedElems;
Handle_TColStd_HPackedMapOfInteger myDetectedNodes;
Handle_TColStd_HPackedMapOfInteger myDetectedElems;
Standard_Integer myLastID;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
